/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class InfinispanSessionRepositoryTCK
extends AbstractInfinispanTest {
    protected SpringCache springCache;
    protected AbstractInfinispanSessionRepository sessionRepository;
    protected MediaType mediaType;

    protected InfinispanSessionRepositoryTCK mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    protected String parameters() {
        return this.mediaType.toString();
    }

    protected abstract SpringCache createSpringCache();

    protected abstract AbstractInfinispanSessionRepository createRepository(SpringCache var1) throws Exception;

    protected void init() throws Exception {
        this.springCache = this.createSpringCache();
        this.sessionRepository = this.createRepository(this.springCache);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        this.createRepository(null);
    }

    @Test
    public void testCreatingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        AssertJUnit.assertNotNull((Object)session.getId());
        AssertJUnit.assertNotNull((Object)session.getCreationTime());
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test
    public void testSavingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        AssertJUnit.assertNotNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test
    public void testUpdatingTTLOnAccessingData() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        long accessTimeBeforeSaving = session.getLastAccessedTime().toEpochMilli();
        this.sessionRepository.save(session);
        long accessTimeAfterSaving = session.getLastAccessedTime().toEpochMilli();
        long accessTimeAfterAccessing = this.sessionRepository.findById(session.getId()).getLastAccessedTime().toEpochMilli();
        long now = Instant.now().toEpochMilli();
        AssertJUnit.assertTrue((accessTimeBeforeSaving > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeBeforeSaving <= now ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterSaving > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterSaving <= now ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterAccessing > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterAccessing >= accessTimeAfterSaving ? 1 : 0) != 0);
    }

    @Test
    public void testDeletingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        this.sessionRepository.deleteById(session.getId());
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test(timeOut=5000L)
    public void testEvictingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        session.setMaxInactiveInterval(Duration.ofSeconds(1L));
        this.sessionRepository.save(session);
        while (this.sessionRepository.getSession(session.getId(), false) != null) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
    }

    @Test
    public void testExtractingPrincipalWithWrongIndexName() throws Exception {
        int sizeWithWrongIndexName = this.sessionRepository.findByIndexNameAndIndexValue("wrongIndexName", "").size();
        int sizeWithNullIndexName = this.sessionRepository.findByIndexNameAndIndexValue(null, "").size();
        AssertJUnit.assertEquals((int)0, (int)sizeWithNullIndexName);
        AssertJUnit.assertEquals((int)0, (int)sizeWithWrongIndexName);
    }

    @Test
    public void testExtractingPrincipal() throws Exception {
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test1");
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test2");
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test3");
        int numberOfTest1Users = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, "test1").size();
        int numberOfNonExistingUsers = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, "notExisting").size();
        AssertJUnit.assertEquals((int)1, (int)numberOfTest1Users);
        AssertJUnit.assertEquals((int)0, (int)numberOfNonExistingUsers);
    }

    @Test
    public void testChangeSessionId() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        String originalId = session.getId();
        this.sessionRepository.save(session);
        session.changeSessionId();
        String newId = session.getId();
        this.sessionRepository.save(session);
        AssertJUnit.assertNotNull((Object)this.sessionRepository.findById(newId));
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(originalId));
        this.sessionRepository.save(session);
        AssertJUnit.assertNotNull((Object)this.sessionRepository.findById(newId));
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(originalId));
    }

    @Test
    public void testConcurrentSessionAccess() {
        MapSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        MapSession concurrentRequestSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertNotSame((Object)session, (Object)concurrentRequestSession);
        Map sessionAttrs = (Map)TestingUtil.extractField((Object)session, (String)"sessionAttrs");
        Iterator iterator = sessionAttrs.entrySet().iterator();
        concurrentRequestSession.setAttribute("foo", (Object)"bar");
        AssertJUnit.assertFalse((boolean)iterator.hasNext());
    }

    protected void addEmptySessionWithPrincipal(AbstractInfinispanSessionRepository sessionRepository, String principalName) {
        MapSession session = sessionRepository.createSession();
        session.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)principalName);
        sessionRepository.save(session);
    }
}

