/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.nearcache.server;

import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.hornetq.integration.bootstrap.HornetQBootstrapServer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.core.Main;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MessagingHotRodDemo {
    private static final Log log = LogFactory.getLog(MessagingHotRodDemo.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InputStream in = System.in;
        HornetQBootstrapServer.main((String[])new String[]{"hornetq-beans.xml"});
        Main.main((String[])new String[]{"-r", "hotrod"});
        ProtocolServer server = Main.getServer();
        EmbeddedCacheManager cm = Main.getCacheManager();
        InitialContext ctx = new InitialContext();
        Connection con = null;
        try {
            con = ((ConnectionFactory)ctx.lookup("/ConnectionFactory")).createConnection();
            con.start();
            Session s = con.createSession(false, 1);
            Topic topic = (Topic)ctx.lookup("/topic/datagrid");
            cm.getCache().addListener((Object)new InvalidationProducer(s, topic));
        }
        finally {
            while (in.read() != -1) {
            }
            ctx.close();
            if (con != null) {
                con.close();
            }
            server.stop();
            cm.stop();
            System.exit(0);
        }
    }

    @Listener
    public static class InvalidationProducer {
        final MessageProducer msgProducer;
        final Session s;
        final Topic topic;

        public InvalidationProducer(Session s, Topic topic) throws JMSException {
            this.s = s;
            this.topic = topic;
            this.msgProducer = s.createProducer((Destination)topic);
        }

        @CacheEntryModified
        public void invalidateModifiedEntry(CacheEntryModifiedEvent<ByteArrayKey, CacheValue> e) throws JMSException {
            if (e.isPre() && e.getValue() != null) {
                log.infof("Entry modified", new Object[0]);
                this.invalidate((CacheEntryEvent<ByteArrayKey, CacheValue>)e);
            }
        }

        @CacheEntryRemoved
        public void invalidateRemovedEntry(CacheEntryEvent<ByteArrayKey, CacheValue> e) throws JMSException {
            if (e.isPre()) {
                log.infof("Entry removed", new Object[0]);
                this.invalidate(e);
            }
        }

        private void invalidate(CacheEntryEvent<ByteArrayKey, CacheValue> e) throws JMSException {
            byte[] keyBytes = ((ByteArrayKey)e.getKey()).getData();
            BytesMessage msg = this.s.createBytesMessage();
            msg.writeBytes(keyBytes);
            this.msgProducer.send((Message)msg);
            log.infof("Send invalidation message %s", (Object)msg.getJMSMessageID());
        }
    }
}

