/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.nearcache.jms;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteEventListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(RemoteEventListener.class);
    final Cache<Object, Object> cache;
    final StreamingMarshaller marshaller;

    public RemoteEventListener(Cache<Object, Object> cache, StreamingMarshaller marshaller) {
        this.cache = cache;
        this.marshaller = marshaller;
    }

    public void onMessage(Message msg) {
        try {
            Object key = this.getKey(msg);
            log.infof("Received invalidation message[%s] for key=%s, remove from cache", (Object)msg.getJMSMessageID(), key);
            this.cache.remove(key);
        }
        catch (Exception e) {
            throw new CacheException("Unable to process remote cache event", (Throwable)e);
        }
    }

    private Object getKey(Message message) throws Exception {
        BytesMessage msg = (BytesMessage)message;
        byte[] keyBytes = new byte[(int)msg.getBodyLength()];
        msg.readBytes(keyBytes);
        return this.marshaller.objectFromByteBuffer(keyBytes);
    }
}

