/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter;

import java.util.concurrent.CompletableFuture;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.hotrod.impl.Util;
import org.infinispan.hotrod.impl.counter.BaseCounter;
import org.infinispan.hotrod.impl.counter.CounterOperationFactory;
import org.infinispan.hotrod.impl.counter.NotificationManager;

class StrongCounterImpl
extends BaseCounter
implements StrongCounter {
    private final SyncStrongCounter syncCounter = new Sync();

    StrongCounterImpl(String name, CounterConfiguration configuration, CounterOperationFactory operationFactory, NotificationManager notificationManager) {
        super(configuration, name, operationFactory, notificationManager);
    }

    public CompletableFuture<Long> getValue() {
        return this.factory.newGetValueOperation(this.name, this.useConsistentHash()).execute().toCompletableFuture();
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        return this.factory.newAddOperation(this.name, delta, this.useConsistentHash()).execute().toCompletableFuture();
    }

    public CompletableFuture<Long> compareAndSwap(long expect, long update) {
        return this.factory.newCompareAndSwapOperation(this.name, expect, update, super.getConfiguration()).execute().toCompletableFuture();
    }

    public SyncStrongCounter sync() {
        return this.syncCounter;
    }

    public CompletableFuture<Long> getAndSet(long value) {
        return this.factory.newSetOperation(this.name, value, this.useConsistentHash()).execute().toCompletableFuture();
    }

    @Override
    boolean useConsistentHash() {
        return true;
    }

    private class Sync
    implements SyncStrongCounter {
        private Sync() {
        }

        public long addAndGet(long delta) {
            return Util.await(StrongCounterImpl.this.addAndGet(delta));
        }

        public void reset() {
            Util.await(StrongCounterImpl.this.reset());
        }

        public long getValue() {
            return Util.await(StrongCounterImpl.this.getValue());
        }

        public long compareAndSwap(long expect, long update) {
            return Util.await(StrongCounterImpl.this.compareAndSwap(expect, update));
        }

        public long getAndSet(long value) {
            return Util.await(StrongCounterImpl.this.getAndSet(value));
        }

        public String getName() {
            return StrongCounterImpl.this.name;
        }

        public CounterConfiguration getConfiguration() {
            return StrongCounterImpl.this.configuration;
        }

        public void remove() {
            Util.await(StrongCounterImpl.this.remove());
        }
    }
}

