/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.util;

import java.util.Collections;
import java.util.Map;
import org.infinispan.hotrod.test.KeyValueGenerator;

public class MapKVHelper<K, V> {
    private final Map<K, V> entries;
    private final KeyValueGenerator<K, V> kvGenerator;

    public MapKVHelper(Map<K, V> entries, KeyValueGenerator<K, V> kvGenerator) {
        this.entries = Collections.unmodifiableMap(entries);
        this.kvGenerator = kvGenerator;
    }

    public V get(K key) {
        for (Map.Entry<K, V> entry : this.entries.entrySet()) {
            if (!this.kvGenerator.equalKeys(entry.getKey(), key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }
}

