/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import io.smallrye.mutiny.Uni;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.junit.jupiter.api.Assertions;

public class AwaitAssertions {
    public static <T> void assertAwaitEquals(T expected, CompletionStage<T> actualFuture) {
        T actual = AwaitAssertions.await(actualFuture);
        Assertions.assertEquals(expected, actual);
    }

    public static <T> void assertAwaitEquals(T expected, Uni<T> uni) {
        AwaitAssertions.assertAwaitEquals(expected, uni.convert().toCompletionStage());
    }

    public static <T> T await(CompletionStage<T> actual) {
        CompletableFuture<Object> future = actual.toCompletableFuture();
        boolean completed = CompletableFutures.uncheckedAwait(future, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        if (!completed) {
            Assertions.fail((String)"Timeout obtaining responses");
        }
        return future.getNow(null);
    }

    public static <T> T await(Uni<T> actual) {
        return (T)actual.await().atMost(Duration.ofSeconds(10L));
    }
}

