/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.Signal;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.hotrod.exceptions.HotRodClientException;
import org.infinispan.hotrod.exceptions.InvalidResponseException;
import org.infinispan.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.handler.CacheRequestProcessor;
import org.infinispan.hotrod.impl.transport.netty.ClientBaseDecoder;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.impl.transport.netty.Intrinsics;
import org.infinispan.hotrod.impl.transport.netty.ParserUtils;

public class HotRodClientDecoder
extends ClientBaseDecoder {
    private int state;
    private int requestBytes;
    private Object hr4x_returnPossiblePrevValue;
    private MediaType hr4x_valueType;
    private List<Integer> hr4x_ownersInSegments;
    private String hr4x_mediaTypeName;
    private Set<Short> hr4x_serverOps;
    private long hr4x_long;
    private short hr4x_uByte;
    private byte[] hr4x_array;
    private int hr4x_lifespan;
    private int hr4x_numSegments;
    private short hr4x_status;
    private List<List<Integer>> hr4x_segmentOwners;
    private String hr4x_mediaParamName;
    private Map<String, String> hr4x_mediaTypeParams;
    private byte hr4x_mediaTypeDefinition;
    private int hr4x_serverOpsCount;
    private byte hr4x_headerStatus;
    private long hr4x_vLong;
    private String hr4x_mediaParamValue;
    private byte hr4x_byte;
    private MediaType hr4x_mediaType;
    private int hr4x_newTopologyId;
    private long hr4x_lastUsed;
    private int hr4x_vInt;
    private int hr4x_mediaTypeParamsNum;
    private short hr4x_vShort;
    private short hr4x_hashFunctionVersion;
    private short hr4x_resOpCode;
    private long hr4x_creation;
    private MediaType hr4x_mediaTypeDescription;
    private int hr4x_uShort;
    private String hr4x_serverMsg;
    private int hr4x_mediaTypeId;
    private String hr4x_string;
    private long hr4x_messageId;
    private int hr4x_clusterSize;
    private List<InetSocketAddress> hr4x_topologyMembers;
    private int hr4x_maxIdle;
    private byte[] hr4x_getResponseBody;
    private short hr4x_magic;
    private MediaType hr4x_keyType;
    private boolean deadEnd = false;

    public HotRodClientDecoder(HeaderDecoder delegate, CacheRequestProcessor processor) {
        super(delegate, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch1_0(buf)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ByteBuf buf) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(buf);
            }
            case 1: {
                return this.switch1(buf);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                this.deadEnd = false;
                this.state = 2;
            }
            case 2: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_magic = this.hr4x_uByte;
                this.state = 3;
            }
            case 3: {
                if (this.hr4x_magic != 161) {
                    throw new IllegalStateException("Invalid magic response: " + this.hr4x_magic);
                }
                this.state = 4;
            }
            case 4: {
                int pos = buf.readerIndex();
                this.hr4x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_messageId = this.hr4x_vLong;
                this.state = 5;
            }
            case 5: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_resOpCode = this.hr4x_uByte;
                this.state = 6;
            }
            case 6: {
                if (ParserUtils.isEntryEventOp(this.hr4x_resOpCode) || ParserUtils.isCounterEventOp(this.hr4x_resOpCode)) {
                    this.state = 7;
                    return true;
                }
                this.delegate.loadCurrent(this.hr4x_messageId);
                this.state = 8;
                return true;
            }
            case 7: {
                this.delegateParsing(buf, this.hr4x_messageId, this.hr4x_resOpCode, (short)-1);
                this.state = 0;
                return true;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_status = this.hr4x_uByte;
                this.state = 10;
                return true;
            }
            case 9: {
                switch (this.hr4x_resOpCode) {
                    case 24: {
                        this.state = 58;
                        return true;
                    }
                    case 4: {
                        this.state = 103;
                        return true;
                    }
                    case 2: {
                        this.state = 106;
                        return true;
                    }
                }
                this.delegateParsing(buf, this.hr4x_messageId, this.hr4x_resOpCode, this.hr4x_status);
                this.state = 0;
                return true;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 11;
            }
            case 11: {
                if (this.hr4x_uByte == 1) {
                    this.state = 13;
                    return true;
                }
                this.state = 12;
            }
            case 12: {
                if (this.operationResponseHasError(this.hr4x_messageId, this.hr4x_resOpCode)) {
                    this.state = 33;
                    return true;
                }
                this.state = 9;
                return true;
            }
            case 13: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_newTopologyId = this.hr4x_vInt;
                this.state = 14;
            }
            case 14: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_clusterSize = this.hr4x_vInt;
                this.state = 16;
                return true;
            }
            case 15: {
                if (this.isHashDistributionAware(this.hr4x_messageId)) {
                    this.state = 22;
                    return true;
                }
                this.hr4x_hashFunctionVersion = (short)-1;
                this.state = 21;
                return true;
            }
            case 16: {
                this.hr4x_topologyMembers = this.allocList(this.hr4x_clusterSize);
                this.state = 17;
            }
            case 17: {
                if (this.hr4x_clusterSize == 0) {
                    this.state = 15;
                    return true;
                }
                --this.hr4x_clusterSize;
                this.state = 18;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 19;
            }
            case 19: {
                int pos = buf.readerIndex();
                this.hr4x_uShort = Intrinsics.uShort(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 20;
            }
            case 20: {
                this.hr4x_topologyMembers.add(InetSocketAddress.createUnresolved(this.hr4x_string, this.hr4x_uShort));
                this.state = 17;
                return true;
            }
            case 21: {
                if (this.isHashDistributionAware(this.hr4x_messageId)) {
                    this.state = 24;
                    return true;
                }
                this.hr4x_segmentOwners = null;
                this.state = 23;
                return true;
            }
            case 22: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_hashFunctionVersion = this.hr4x_uByte;
                this.state = 21;
                return true;
            }
            case 23: {
                this.responseHandler.topologyUpdate(this.current(), this.hr4x_newTopologyId, this.hr4x_topologyMembers.toArray(new InetSocketAddress[0]), this.hr4x_segmentOwners, this.hr4x_hashFunctionVersion);
                this.state = 12;
                return true;
            }
            case 24: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_numSegments = this.hr4x_vInt;
                this.state = 25;
            }
            case 25: {
                this.hr4x_segmentOwners = this.allocList(this.hr4x_numSegments);
                this.state = 26;
            }
            case 26: {
                if (this.hr4x_numSegments == 0) {
                    this.state = 23;
                    return true;
                }
                --this.hr4x_numSegments;
                this.state = 27;
            }
            case 27: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 29;
                return true;
            }
            case 28: {
                this.hr4x_segmentOwners.add(this.hr4x_ownersInSegments);
                this.state = 26;
                return true;
            }
            case 29: {
                this.hr4x_ownersInSegments = this.allocList(this.hr4x_uByte);
                this.state = 30;
            }
            case 30: {
                if (this.hr4x_uByte == 0) {
                    this.state = 28;
                    return true;
                }
                this.hr4x_uByte = (short)(this.hr4x_uByte - 1);
                this.state = 31;
            }
            case 31: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 32;
            }
            case 32: {
                this.hr4x_ownersInSegments.add(this.hr4x_vInt);
                this.state = 30;
                return true;
            }
            case 33: {
                return this.userSwitch33();
            }
            case 34: {
                this.state = 9;
                return true;
            }
            case 35: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 37;
                return true;
            }
            case 36: {
                throw new HotRodClientException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 37: {
                Log.HOTROD.errorFromServer(this.hr4x_serverMsg);
                this.state = 36;
                return true;
            }
            case 38: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 40;
                return true;
            }
            case 39: {
                throw new HotRodClientException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 40: {
                Log.HOTROD.errorFromServer(this.hr4x_serverMsg);
                this.state = 39;
                return true;
            }
            case 41: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 43;
                return true;
            }
            case 42: {
                throw new HotRodClientException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 43: {
                Log.HOTROD.errorFromServer(this.hr4x_serverMsg);
                this.state = 42;
                return true;
            }
            case 44: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 46;
                return true;
            }
            case 45: {
                throw new HotRodClientException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 46: {
                Log.HOTROD.errorFromServer(this.hr4x_serverMsg);
                this.state = 45;
                return true;
            }
            case 47: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 49;
                return true;
            }
            case 48: {
                throw new HotRodClientException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 49: {
                Log.HOTROD.errorFromServer(this.hr4x_serverMsg);
                this.state = 48;
                return true;
            }
            case 50: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 51;
            }
            case 51: {
                if (log.isTraceEnabled()) {
                    log.tracef("Server-side timeout performing operation: %s", (Object)this.hr4x_serverMsg);
                }
                this.state = 52;
            }
            case 52: {
                throw new HotRodClientException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 53: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 54;
            }
            case 54: {
                throw new RemoteIllegalLifecycleStateException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status, null);
            }
            case 55: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverMsg = this.hr4x_string;
                this.state = 56;
            }
            case 56: {
                throw new RemoteNodeSuspectException(this.hr4x_serverMsg, this.hr4x_messageId, this.hr4x_status);
            }
            case 57: {
                throw new IllegalStateException(String.format("Unknown status: %#04x", this.hr4x_status));
            }
            case 58: {
                int pos = buf.readerIndex();
                this.hr4x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeDefinition = this.hr4x_byte;
                this.state = 60;
                return true;
            }
            case 59: {
                int pos = buf.readerIndex();
                this.hr4x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeDefinition = this.hr4x_byte;
                this.state = 79;
                return true;
            }
            case 60: {
                switch (this.hr4x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 61;
                        return true;
                    }
                    case 1: {
                        this.state = 62;
                        return true;
                    }
                    case 2: {
                        this.state = 70;
                        return true;
                    }
                }
                throw new IllegalStateException("Unknown MediaType definition: " + this.hr4x_mediaTypeDefinition + " for message " + this.hr4x_messageId);
            }
            case 61: {
                this.hr4x_keyType = this.hr4x_mediaType = (this.hr4x_mediaTypeDescription = null);
                this.state = 59;
                return true;
            }
            case 62: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeId = this.hr4x_vInt;
                this.state = 63;
            }
            case 63: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeParamsNum = this.hr4x_vInt;
                this.state = 65;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 64: {
                this.hr4x_keyType = this.hr4x_mediaType = (this.hr4x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr4x_mediaTypeId)).withParameters(this.hr4x_mediaTypeParams));
                this.state = 59;
                return true;
            }
            case 65: {
                this.hr4x_mediaTypeParams = this.allocMap(this.hr4x_mediaTypeParamsNum);
                this.state = 66;
            }
            case 66: {
                if (this.hr4x_mediaTypeParamsNum == 0) {
                    this.state = 64;
                    return true;
                }
                --this.hr4x_mediaTypeParamsNum;
                this.state = 67;
            }
            case 67: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamName = this.hr4x_string;
                this.state = 68;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamValue = this.hr4x_string;
                this.state = 69;
            }
            case 69: {
                this.hr4x_mediaTypeParams.put(this.hr4x_mediaParamName, this.hr4x_mediaParamValue);
                this.state = 66;
                return true;
            }
            case 70: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeName = this.hr4x_string;
                this.state = 71;
            }
            case 71: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeParamsNum = this.hr4x_vInt;
                this.state = 73;
                return true;
            }
            case 72: {
                this.hr4x_keyType = this.hr4x_mediaType = (this.hr4x_mediaTypeDescription = MediaType.fromString((String)this.hr4x_mediaTypeName).withParameters(this.hr4x_mediaTypeParams));
                this.state = 59;
                return true;
            }
            case 73: {
                this.hr4x_mediaTypeParams = this.allocMap(this.hr4x_mediaTypeParamsNum);
                this.state = 74;
            }
            case 74: {
                if (this.hr4x_mediaTypeParamsNum == 0) {
                    this.state = 72;
                    return true;
                }
                --this.hr4x_mediaTypeParamsNum;
                this.state = 75;
            }
            case 75: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamName = this.hr4x_string;
                this.state = 76;
            }
            case 76: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamValue = this.hr4x_string;
                this.state = 77;
            }
            case 77: {
                this.hr4x_mediaTypeParams.put(this.hr4x_mediaParamName, this.hr4x_mediaParamValue);
                this.state = 74;
                return true;
            }
            case 78: {
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 97;
                return true;
            }
            case 79: {
                switch (this.hr4x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 80;
                        return true;
                    }
                    case 1: {
                        this.state = 81;
                        return true;
                    }
                    case 2: {
                        this.state = 89;
                        return true;
                    }
                }
                throw new IllegalStateException("Unknown MediaType definition: " + this.hr4x_mediaTypeDefinition + " for message " + this.hr4x_messageId);
            }
            case 80: {
                this.hr4x_valueType = this.hr4x_mediaType = (this.hr4x_mediaTypeDescription = null);
                this.state = 78;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeId = this.hr4x_vInt;
                this.state = 82;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeParamsNum = this.hr4x_vInt;
                this.state = 84;
                return true;
            }
            case 83: {
                this.hr4x_valueType = this.hr4x_mediaType = (this.hr4x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr4x_mediaTypeId)).withParameters(this.hr4x_mediaTypeParams));
                this.state = 78;
                return true;
            }
            case 84: {
                this.hr4x_mediaTypeParams = this.allocMap(this.hr4x_mediaTypeParamsNum);
                this.state = 85;
            }
            case 85: {
                if (this.hr4x_mediaTypeParamsNum == 0) {
                    this.state = 83;
                    return true;
                }
                --this.hr4x_mediaTypeParamsNum;
                this.state = 86;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamName = this.hr4x_string;
                this.state = 87;
            }
            case 87: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamValue = this.hr4x_string;
                this.state = 88;
            }
            case 88: {
                this.hr4x_mediaTypeParams.put(this.hr4x_mediaParamName, this.hr4x_mediaParamValue);
                this.state = 85;
                return true;
            }
            case 89: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeName = this.hr4x_string;
                this.state = 90;
            }
            case 90: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaTypeParamsNum = this.hr4x_vInt;
                this.state = 92;
                return true;
            }
            case 91: {
                this.hr4x_valueType = this.hr4x_mediaType = (this.hr4x_mediaTypeDescription = MediaType.fromString((String)this.hr4x_mediaTypeName).withParameters(this.hr4x_mediaTypeParams));
                this.state = 78;
                return true;
            }
            case 92: {
                this.hr4x_mediaTypeParams = this.allocMap(this.hr4x_mediaTypeParamsNum);
                this.state = 93;
            }
            case 93: {
                if (this.hr4x_mediaTypeParamsNum == 0) {
                    this.state = 91;
                    return true;
                }
                --this.hr4x_mediaTypeParamsNum;
                this.state = 94;
            }
            case 94: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamName = this.hr4x_string;
                this.state = 95;
            }
            case 95: {
                int pos = buf.readerIndex();
                this.hr4x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_mediaParamValue = this.hr4x_string;
                this.state = 96;
            }
            case 96: {
                this.hr4x_mediaTypeParams.put(this.hr4x_mediaParamName, this.hr4x_mediaParamValue);
                this.state = 93;
                return true;
            }
            case 97: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_serverOpsCount = this.hr4x_vInt;
                this.state = 99;
                return true;
            }
            case 98: {
                this.responseHandler.pingResponse(this.current(), this.hr4x_status, this.hr4x_uByte, this.hr4x_keyType, this.hr4x_valueType, this.hr4x_serverOps);
                this.state = 0;
                return true;
            }
            case 99: {
                this.hr4x_serverOps = this.allocSet(this.hr4x_serverOpsCount);
                this.state = 100;
            }
            case 100: {
                if (this.hr4x_serverOpsCount == 0) {
                    this.state = 98;
                    return true;
                }
                --this.hr4x_serverOpsCount;
                this.state = 101;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.hr4x_vShort = Intrinsics.vShort(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 102;
            }
            case 102: {
                this.hr4x_serverOps.add(this.hr4x_vShort);
                this.state = 100;
                return true;
            }
            case 103: {
                if (!HotRodConstants.isNotExist(this.hr4x_status) && HotRodConstants.isSuccess(this.hr4x_status)) {
                    this.state = 105;
                    return true;
                }
                this.hr4x_getResponseBody = null;
                this.state = 104;
            }
            case 104: {
                this.responseHandler.getResponse(this.current(), this.hr4x_status, this.hr4x_getResponseBody);
                this.state = 0;
                return true;
            }
            case 105: {
                int pos = buf.readerIndex();
                this.hr4x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_getResponseBody = this.hr4x_array;
                this.state = 104;
                return true;
            }
            case 106: {
                if (!HotRodConstants.isSuccess(this.hr4x_status)) {
                    this.state = 108;
                    return true;
                }
                this.state = 107;
            }
            case 107: {
                if (!HotRodConstants.hasPrevious(this.hr4x_status)) {
                    this.state = 110;
                    return true;
                }
                if (HotRodConstants.isNotExist(this.hr4x_status) || !HotRodConstants.isSuccess(this.hr4x_status) && !HotRodConstants.hasPrevious(this.hr4x_status)) {
                    this.state = 111;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr4x_uByte = Intrinsics.uByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 112;
                return true;
            }
            case 108: {
                throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(this.hr4x_status));
            }
            case 109: {
                this.responseHandler.putResponse(this.current(), this.hr4x_returnPossiblePrevValue, this.hr4x_status);
                this.state = 0;
                return true;
            }
            case 110: {
                this.hr4x_returnPossiblePrevValue = null;
                this.state = 109;
                return true;
            }
            case 111: {
                this.hr4x_returnPossiblePrevValue = null;
                this.state = 109;
                return true;
            }
            case 112: {
                if ((this.hr4x_uByte & 1) != 1) {
                    this.state = 114;
                    return true;
                }
                this.hr4x_creation = -1L;
                this.hr4x_lifespan = -1;
                this.state = 113;
            }
            case 113: {
                if ((this.hr4x_uByte & 2) != 2) {
                    this.state = 117;
                    return true;
                }
                this.hr4x_lastUsed = -1L;
                this.hr4x_maxIdle = -1;
                this.state = 116;
                return true;
            }
            case 114: {
                int pos = buf.readerIndex();
                this.hr4x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_creation = this.hr4x_long;
                this.state = 115;
            }
            case 115: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_lifespan = this.hr4x_vInt;
                this.state = 113;
                return true;
            }
            case 116: {
                int pos = buf.readerIndex();
                this.hr4x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 119;
                return true;
            }
            case 117: {
                int pos = buf.readerIndex();
                this.hr4x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_lastUsed = this.hr4x_long;
                this.state = 118;
            }
            case 118: {
                int pos = buf.readerIndex();
                this.hr4x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_maxIdle = this.hr4x_vInt;
                this.state = 116;
                return true;
            }
            case 119: {
                int pos = buf.readerIndex();
                this.hr4x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr4x_returnPossiblePrevValue = this.responseHandler.createCacheEntry(this.current(), this.hr4x_creation, this.hr4x_lifespan, this.hr4x_lastUsed, this.hr4x_maxIdle, this.hr4x_long, this.hr4x_array);
                this.state = 109;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            this.deadEnd = true;
            this.delegate.tryCompleteExceptionally(this.hr4x_messageId, new IllegalStateException("Failed parsing request"));
            this.state = 0;
        }
    }

    private void exceptionally(Throwable t) throws Exception {
        this.state = 0;
        if (!(t instanceof Signal)) {
            if (t instanceof DecoderException) {
                throw (DecoderException)t;
            }
            throw new DecoderException(t);
        }
    }

    private void reset() {
        this.requestBytes = 0;
        this.hr4x_returnPossiblePrevValue = null;
        this.hr4x_valueType = null;
        this.hr4x_ownersInSegments = null;
        this.hr4x_mediaTypeName = null;
        this.hr4x_serverOps = null;
        this.hr4x_long = 0L;
        this.hr4x_uByte = 0;
        this.hr4x_array = null;
        this.hr4x_lifespan = 0;
        this.hr4x_numSegments = 0;
        this.hr4x_status = 0;
        this.hr4x_segmentOwners = null;
        this.hr4x_mediaParamName = null;
        this.hr4x_mediaTypeParams = null;
        this.hr4x_mediaTypeDefinition = 0;
        this.hr4x_serverOpsCount = 0;
        this.hr4x_headerStatus = 0;
        this.hr4x_vLong = 0L;
        this.hr4x_mediaParamValue = null;
        this.hr4x_byte = 0;
        this.hr4x_mediaType = null;
        this.hr4x_newTopologyId = 0;
        this.hr4x_lastUsed = 0L;
        this.hr4x_vInt = 0;
        this.hr4x_mediaTypeParamsNum = 0;
        this.hr4x_vShort = 0;
        this.hr4x_hashFunctionVersion = 0;
        this.hr4x_resOpCode = 0;
        this.hr4x_creation = 0L;
        this.hr4x_mediaTypeDescription = null;
        this.hr4x_uShort = 0;
        this.hr4x_serverMsg = null;
        this.hr4x_mediaTypeId = 0;
        this.hr4x_string = null;
        this.hr4x_messageId = 0L;
        this.hr4x_clusterSize = 0;
        this.hr4x_topologyMembers = null;
        this.hr4x_maxIdle = 0;
        this.hr4x_getResponseBody = null;
        this.hr4x_magic = 0;
        this.hr4x_keyType = null;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch33() throws Exception {
        switch (this.hr4x_status) {
            case 129: {
                this.state = 35;
                return true;
            }
            case 132: {
                this.state = 38;
                return true;
            }
            case 130: {
                this.state = 41;
                return true;
            }
            case 133: {
                this.state = 44;
                return true;
            }
            case 131: {
                this.state = 47;
                return true;
            }
            case 134: {
                this.state = 50;
                return true;
            }
            case 136: {
                this.state = 53;
                return true;
            }
            case 135: {
                this.state = 55;
                return true;
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Unknown status: %#04x", (int)this.hr4x_status);
        }
        this.state = 57;
        return true;
    }
}

