/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.StatsAffectingHotRodOperation;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public abstract class ParallelHotRodOperation<T, SUBOP extends HotRodOperation<T>>
extends StatsAffectingHotRodOperation<T> {
    protected ParallelHotRodOperation(OperationContext operationContext, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, (short)0, (short)0, options, dataFormat);
    }

    @Override
    public CompletableFuture<T> execute() {
        List<SUBOP> operations = this.mapOperations();
        if (operations.isEmpty()) {
            return CompletableFuture.completedFuture(this.createCollector());
        }
        if (operations.size() == 1) {
            return ((HotRodOperation)operations.get(0)).execute().toCompletableFuture();
        }
        return this.executeParallel(operations);
    }

    private CompletableFuture<T> executeParallel(List<SUBOP> operations) {
        T collector = this.createCollector();
        AtomicInteger counter = new AtomicInteger(operations.size());
        for (HotRodOperation operation : operations) {
            operation.execute().whenComplete((? super T result, ? super Throwable throwable) -> {
                if (throwable != null) {
                    this.completeExceptionally((Throwable)throwable);
                } else {
                    if (collector != null) {
                        Object object = collector;
                        synchronized (object) {
                            this.combine(collector, result);
                        }
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.complete(collector);
                    }
                }
            });
        }
        this.exceptionally((T throwable) -> {
            for (HotRodOperation operation : operations) {
                operation.cancel(true);
            }
            return null;
        });
        return this;
    }

    protected abstract List<SUBOP> mapOperations();

    protected abstract T createCollector();

    protected abstract void combine(T var1, T var2);

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        throw new UnsupportedOperationException();
    }
}

