/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import javax.transaction.xa.Xid;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class CompleteTransactionOperation
extends RetryOnFailureOperation<Integer> {
    private final Xid xid;

    public CompleteTransactionOperation(OperationContext operationContext, Xid xid, boolean commit) {
        super(operationContext, commit ? (short)61 : 63, commit ? (short)62 : 64, CacheOptions.DEFAULT, null);
        this.xid = xid;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.estimateSize());
        this.operationContext.getCodec().writeHeader(buf, this.header);
        ByteBufUtil.writeXid(buf, this.xid);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (status == 0) {
            this.complete(buf.readInt());
        } else {
            this.complete(6);
        }
    }

    private int estimateSize() {
        return this.operationContext.getCodec().estimateHeaderSize(this.header) + ByteBufUtil.estimateXidSize(this.xid);
    }
}

