/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.transaction.xa.Xid;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.transaction.TransactionOperationFactory;
import org.infinispan.hotrod.impl.transaction.TransactionTable;
import org.infinispan.hotrod.impl.transaction.operations.CompleteTransactionOperation;
import org.infinispan.hotrod.impl.transaction.operations.ForgetTransactionOperation;

abstract class AbstractTransactionTable
implements TransactionTable {
    private static final Log log = LogFactory.getLog(AbstractTransactionTable.class, Log.class);
    private final long timeout;
    private volatile TransactionOperationFactory operationFactory;

    AbstractTransactionTable(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public final void start(TransactionOperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    TransactionOperationFactory assertStartedAndReturnFactory() {
        TransactionOperationFactory tmp = this.operationFactory;
        if (tmp == null) {
            throw log.transactionTableNotStarted();
        }
        return tmp;
    }

    final long getTimeout() {
        return this.timeout;
    }

    int completeTransaction(Xid xid, boolean commit) {
        try {
            TransactionOperationFactory factory = this.assertStartedAndReturnFactory();
            CompleteTransactionOperation operation = factory.newCompleteTransactionOperation(xid, commit);
            return (Integer)operation.execute().toCompletableFuture().get();
        }
        catch (Exception e) {
            log.debug("Exception while commit/rollback.", e);
            return 6;
        }
    }

    void forgetTransaction(Xid xid) {
        block2: {
            try {
                TransactionOperationFactory factory = this.assertStartedAndReturnFactory();
                ForgetTransactionOperation operation = factory.newForgetTransactionOperation(xid);
                operation.execute();
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.tracef(e, "Exception in forget transaction xid=%s", xid);
            }
        }
    }

    CompletionStage<Collection<Xid>> fetchPreparedTransactions() {
        try {
            TransactionOperationFactory factory = this.assertStartedAndReturnFactory();
            return factory.newRecoveryOperation().execute();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception while fetching prepared transactions", e);
            }
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }
}

