/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.StatsAffectingRetryingOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.marshall.MarshallerUtil;

public class BulkGetKeysOperation<K>
extends StatsAffectingRetryingOperation<Set<K>> {
    private final int scope;
    private final Set<K> result = new HashSet<K>();

    public BulkGetKeysOperation(OperationContext operationContext, CacheOptions options, int scope, DataFormat dataFormat) {
        super(operationContext, (short)29, (short)30, options, dataFormat);
        this.scope = scope;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(this.scope));
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeVInt(buf, this.scope);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result.clear();
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        while (buf.readUnsignedByte() == 1) {
            this.result.add(MarshallerUtil.bytes2obj(this.operationContext.getChannelFactory().getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat().isObjectStorage(), this.operationContext.getConfiguration().getClassAllowList()));
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

