/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.multimap.operations;

import net.jcip.annotations.Immutable;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.HotRodFlag;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.ClientStatistics;
import org.infinispan.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.SizeMultimapOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;

@Immutable
public class MultimapOperationsFactory {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final OperationContext operationContext;
    private final DataFormat dataFormat;

    public MultimapOperationsFactory(ChannelFactory channelFactory, String cacheName, HotRodConfiguration configuration, Codec codec, DataFormat dataFormat, ClientStatistics clientStatistics) {
        this.operationContext = new OperationContext(channelFactory, codec, null, configuration, clientStatistics, null, cacheName);
        this.dataFormat = dataFormat;
    }

    public <K, V> GetKeyMultimapOperation<K, V> newGetKeyMultimapOperation(K key, byte[] keyBytes, CacheOptions options, boolean supportsDuplicates) {
        return new GetKeyMultimapOperation(this.operationContext, key, keyBytes, options, this.dataFormat, supportsDuplicates);
    }

    public <K, V> GetKeyWithMetadataMultimapOperation<K, V> newGetKeyWithMetadataMultimapOperation(K key, byte[] keyBytes, CacheOptions options, boolean supportsDuplicates) {
        return new GetKeyWithMetadataMultimapOperation(this.operationContext, key, keyBytes, options, this.dataFormat, supportsDuplicates);
    }

    public <K> PutKeyValueMultimapOperation<K> newPutKeyValueOperation(K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, boolean supportsDuplicates) {
        return new PutKeyValueMultimapOperation<K>(this.operationContext, key, keyBytes, value, options, null, supportsDuplicates);
    }

    public <K> RemoveKeyMultimapOperation<K> newRemoveKeyOperation(K key, byte[] keyBytes, CacheOptions options, boolean supportsDuplicates) {
        return new RemoveKeyMultimapOperation<K>(this.operationContext, key, keyBytes, options, supportsDuplicates);
    }

    public <K> RemoveEntryMultimapOperation<K> newRemoveEntryOperation(K key, byte[] keyBytes, byte[] value, CacheOptions options, boolean supportsDuplicates) {
        return new RemoveEntryMultimapOperation<K>(this.operationContext, key, keyBytes, value, options, supportsDuplicates);
    }

    public <K> ContainsEntryMultimapOperation<K> newContainsEntryOperation(K key, byte[] keyBytes, byte[] value, CacheOptions options, boolean supportsDuplicates) {
        return new ContainsEntryMultimapOperation<K>(this.operationContext, key, keyBytes, value, options, supportsDuplicates);
    }

    public <K> ContainsKeyMultimapOperation<K> newContainsKeyOperation(K key, byte[] keyBytes, CacheOptions options, boolean supportsDuplicates) {
        return new ContainsKeyMultimapOperation<K>(this.operationContext, key, keyBytes, options, supportsDuplicates);
    }

    public ContainsValueMultimapOperation newContainsValueOperation(byte[] value, CacheOptions options, boolean supportsDuplicates) {
        return new ContainsValueMultimapOperation(this.operationContext, this.flags(), value, options, supportsDuplicates);
    }

    public SizeMultimapOperation newSizeOperation(boolean supportsDuplicates) {
        return new SizeMultimapOperation(this.operationContext, CacheOptions.DEFAULT, supportsDuplicates);
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        return intFlags;
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= HotRodFlag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= HotRodFlag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }
}

