/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Consumer;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.NearCacheConfigurationBuilder;
import org.infinispan.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.hotrod.configuration.TransactionMode;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.transaction.lookup.GenericTransactionManagerLookup;

public class RemoteCacheConfigurationBuilder
implements Builder<RemoteCacheConfiguration> {
    private final HotRodConfigurationBuilder builder;
    private final AttributeSet attributes;
    private final NearCacheConfigurationBuilder nearCache;

    RemoteCacheConfigurationBuilder(HotRodConfigurationBuilder builder, String name) {
        this.builder = builder;
        this.attributes = RemoteCacheConfiguration.attributeDefinitionSet();
        this.attributes.attribute(RemoteCacheConfiguration.NAME).set((Object)name);
        this.nearCache = new NearCacheConfigurationBuilder(builder);
    }

    RemoteCacheConfigurationBuilder(String name) {
        this(null, name);
    }

    public NearCacheConfigurationBuilder nearCache() {
        return this.nearCache;
    }

    public RemoteCacheConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(RemoteCacheConfiguration.FORCE_RETURN_VALUES).set((Object)forceReturnValues);
        return this;
    }

    public RemoteCacheConfigurationBuilder configuration(String configuration) {
        this.attributes.attribute(RemoteCacheConfiguration.CONFIGURATION).set((Object)configuration);
        return this;
    }

    public RemoteCacheConfigurationBuilder configurationURI(URI uri) {
        URL url = !uri.isAbsolute() ? FileLookupFactory.newInstance().lookupFileLocation(uri.toString(), this.getClass().getClassLoader()) : uri.toURL();
        Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.toString()).useDelimiter("\\A");
        try {
            RemoteCacheConfigurationBuilder remoteCacheConfigurationBuilder = this.configuration(scanner.next());
            if (scanner != null) {
                scanner.close();
            }
            return remoteCacheConfigurationBuilder;
        }
        catch (Throwable throwable) {
            try {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
    }

    public RemoteCacheConfigurationBuilder templateName(String templateName) {
        this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).set((Object)templateName);
        return this;
    }

    public RemoteCacheConfigurationBuilder transactionMode(TransactionMode mode) {
        this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MODE).set((Object)mode);
        return this;
    }

    public RemoteCacheConfigurationBuilder marshaller(String className) {
        this.marshaller(Util.loadClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        return this;
    }

    public RemoteCacheConfigurationBuilder marshaller(Class<? extends Marshaller> marshallerClass) {
        this.attributes.attribute(RemoteCacheConfiguration.MARSHALLER_CLASS).set(marshallerClass);
        return this;
    }

    public RemoteCacheConfigurationBuilder marshaller(Marshaller marshaller) {
        this.attributes.attribute(RemoteCacheConfiguration.MARSHALLER).set((Object)marshaller);
        return this;
    }

    public RemoteCacheConfigurationBuilder transactionManagerLookup(TransactionManagerLookup lookup) {
        this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MANAGER).set((Object)lookup);
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(RemoteCacheConfiguration.CONFIGURATION).isModified() && this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).isModified()) {
            throw Log.HOTROD.remoteCacheTemplateNameXorConfiguration((String)this.attributes.attribute(RemoteCacheConfiguration.NAME).get());
        }
        if (this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MODE).get() == null) {
            throw Log.HOTROD.invalidTransactionMode();
        }
        if (this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MANAGER).get() == null) {
            throw Log.HOTROD.invalidTransactionManagerLookup();
        }
    }

    public RemoteCacheConfiguration create() {
        return new RemoteCacheConfiguration(this.attributes.protect(), this.nearCache.create());
    }

    public Builder<?> read(RemoteCacheConfiguration template) {
        this.nearCache.read(template.nearCache());
        this.attributes.read(template.attributes());
        return this;
    }

    public HotRodConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties((Map)properties);
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".configuration", this::configuration);
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".configuration_uri", v -> this.configurationURI(URI.create(v)));
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".template_name", this::templateName);
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".force_return_values", v -> this.forceReturnValues(Boolean.parseBoolean(v)));
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".transaction.transaction_mode", v -> this.transactionMode(TransactionMode.valueOf(v)));
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".transaction.transaction_manager_lookup", this::transactionManagerLookupClass);
        RemoteCacheConfigurationBuilder.findCacheProperty(this.attributes, typed, ".marshaller", this::marshaller);
        this.nearCache.withProperties(properties);
        return this.builder;
    }

    private void transactionManagerLookupClass(String lookupClass) {
        GenericTransactionManagerLookup lookup = lookupClass == null || GenericTransactionManagerLookup.class.getName().equals(lookupClass) ? GenericTransactionManagerLookup.getInstance() : (TransactionManagerLookup)Util.getInstance((Class)Util.loadClass((String)lookupClass, (ClassLoader)HotRod.class.getClassLoader()));
        this.transactionManagerLookup(lookup);
    }

    private static void findCacheProperty(AttributeSet attributes, TypedProperties properties, String name, Consumer<String> consumer) {
        String cacheName = (String)attributes.attribute(RemoteCacheConfiguration.NAME).get();
        String value = null;
        if (properties.containsKey((Object)("infinispan.client.hotrod.cache." + cacheName + name))) {
            value = properties.getProperty("infinispan.client.hotrod.cache." + cacheName + name, true);
        } else if (properties.containsKey((Object)("infinispan.client.hotrod.cache.[" + cacheName + "]" + name))) {
            value = properties.getProperty("infinispan.client.hotrod.cache.[" + cacheName + "]" + name, true);
        }
        if (value != null) {
            consumer.accept(value);
        }
    }
}

