/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.SslConfiguration;
import org.infinispan.hotrod.impl.logging.Log;

public class SslConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<SslConfiguration> {
    private final AttributeSet attributes = SslConfiguration.attributeDefinitionSet();

    SslConfigurationBuilder(HotRodConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SslConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public SslConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_FILENAME).set((Object)keyStoreFileName);
        return this.enable();
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_TYPE).set((Object)keyStoreType);
        return this.enable();
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_PASSWORD).set((Object)keyStorePassword);
        return this.enable();
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.attributes.attribute(SslConfiguration.KEY_ALIAS).set((Object)keyAlias);
        return this.enable();
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.attributes.attribute(SslConfiguration.SSL_CONTEXT).set((Object)sslContext);
        return this.enable();
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.attributes.attribute(SslConfiguration.TRUSTSTORE_FILENAME).set((Object)trustStoreFileName);
        return this.enable();
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.attributes.attribute(SslConfiguration.TRUSTSTORE_TYPE).set((Object)trustStoreType);
        return this.enable();
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.attributes.attribute(SslConfiguration.TRUSTSTORE_PASSWORD).set((Object)trustStorePassword);
        return this.enable();
    }

    public SslConfigurationBuilder sniHostName(String sniHostName) {
        this.attributes.attribute(SslConfiguration.SNI_HOSTNAME).set((Object)sniHostName);
        return this.enable();
    }

    public SslConfigurationBuilder provider(String provider) {
        this.attributes.attribute(SslConfiguration.PROVIDER).set((Object)provider);
        return this.enable();
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.attributes.attribute(SslConfiguration.PROTOCOL).set((Object)protocol);
        return this.enable();
    }

    public SslConfigurationBuilder ciphers(String ... ciphers) {
        this.attributes.attribute(SslConfiguration.CIPHERS).set((Object)ciphers);
        return this.enable();
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(SslConfiguration.ENABLED).get()).booleanValue()) {
            if (this.attributes.attribute(SslConfiguration.SSL_CONTEXT).isNull()) {
                if (!this.attributes.attribute(SslConfiguration.KEYSTORE_FILENAME).isNull() && this.attributes.attribute(SslConfiguration.KEYSTORE_PASSWORD).isNull()) {
                    throw Log.HOTROD.missingKeyStorePassword((String)this.attributes.attribute(SslConfiguration.KEYSTORE_FILENAME).get());
                }
                if (this.attributes.attribute(SslConfiguration.TRUSTSTORE_FILENAME).isNull()) {
                    throw Log.HOTROD.noSSLTrustManagerConfiguration();
                }
                if (!this.attributes.attribute(SslConfiguration.TRUSTSTORE_FILENAME).isNull() && this.attributes.attribute(SslConfiguration.TRUSTSTORE_PASSWORD).isNull() && !"pem".equalsIgnoreCase((String)this.attributes.attribute(SslConfiguration.KEYSTORE_TYPE).get())) {
                    throw Log.HOTROD.missingTrustStorePassword((String)this.attributes.attribute(SslConfiguration.TRUSTSTORE_FILENAME).get());
                }
            } else if (!this.attributes.attribute(SslConfiguration.KEYSTORE_FILENAME).isNull() || !this.attributes.attribute(SslConfiguration.TRUSTSTORE_FILENAME).isNull()) {
                throw Log.HOTROD.xorSSLContext();
            }
        }
    }

    public SslConfiguration create() {
        return new SslConfiguration(this.attributes.protect());
    }

    public Builder read(SslConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder withProperties(Properties properties) {
        this.attributes.fromProperties(TypedProperties.toTypedProperties((Map)properties), "org.infinispan.client.");
        return this.builder;
    }
}

