/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.near;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.commons.util.BloomFilter;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.MurmurHash3BloomFilter;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.configuration.NearCache;
import org.infinispan.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;

public class NearCacheService<K, V>
implements NearCache<K, V> {
    private static final Log log = LogFactory.getLog(NearCacheService.class);
    private final NearCacheConfiguration config;
    private final ClientListenerNotifier listenerNotifier;
    private final AtomicInteger nearCacheRemovals = new AtomicInteger();
    private Object listener;
    private byte[] listenerId;
    private NearCache<K, V> cache;
    private Runnable invalidationCallback;
    private int bloomFilterBits = -1;
    private int bloomFilterUpdateThreshold;
    private RemoteCache<K, V> remote;
    private SocketAddress listenerAddress;

    protected NearCacheService(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        this.config = config;
        this.listenerNotifier = listenerNotifier;
    }

    public SocketAddress start(RemoteCache<K, V> remote) {
        if (this.cache == null) {
            this.cache = this.createNearCache(this.config, this::entryRemovedFromNearCache);
            this.listener = new InvalidatedNearCacheListener(this);
            int maxEntries = this.config.maxEntries();
            if (maxEntries > 0 && this.config.bloomFilter()) {
                this.bloomFilterBits = NearCacheService.determineBloomFilterBits(maxEntries);
                this.bloomFilterUpdateThreshold = maxEntries / 16 + 3;
                this.listenerAddress = remote.addNearCacheListener(this.listener, this.bloomFilterBits);
            }
            this.listenerId = this.listenerNotifier.findListenerId(this.listener);
        }
        this.remote = remote;
        return this.listenerAddress;
    }

    private static int determineBloomFilterBits(int maxEntries) {
        int bloomFilterBitScaler = Integer.parseInt(System.getProperty("infinispan.bloom-filter.bit-multiplier", "4"));
        return maxEntries * bloomFilterBitScaler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void entryRemovedFromNearCache(CacheEntry<K, V> entry) {
        while (true) {
            int removals;
            if ((removals = this.nearCacheRemovals.get()) >= this.bloomFilterUpdateThreshold) {
                if (!this.nearCacheRemovals.compareAndSet(removals, 0)) continue;
                this.remote.updateBloomFilter();
                return;
            }
            if (this.nearCacheRemovals.compareAndSet(removals, removals + 1)) return;
        }
    }

    public void stop(RemoteCache<K, V> remote) {
        if (log.isTraceEnabled()) {
            log.tracef("Stop near cache, remove underlying listener id %s", Util.printArray((byte[])this.listenerId));
        }
        this.cache.clear();
    }

    protected NearCache<K, V> createNearCache(NearCacheConfiguration config, Consumer<CacheEntry<K, V>> removedConsumer) {
        return config.nearCacheFactory().createNearCache(config, removedConsumer);
    }

    public static <K, V> NearCacheService<K, V> create(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        return new NearCacheService<K, V>(config, listenerNotifier);
    }

    @Override
    public void put(CacheEntry<K, V> entry) {
        this.cache.put(entry);
        if (log.isTraceEnabled()) {
            log.tracef("Put %s in near cache (listenerId=%s)", entry, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public void putIfAbsent(CacheEntry<K, V> entry) {
        this.cache.putIfAbsent(entry);
        if (log.isTraceEnabled()) {
            log.tracef("Conditionally put %s if absent in near cache (listenerId=%s)", entry, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public boolean remove(K key) {
        boolean removed = this.cache.remove(key);
        if (removed) {
            if (this.invalidationCallback != null) {
                this.invalidationCallback.run();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Removed key=%s from near cache (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
            }
        } else {
            log.tracef("Received false positive remove for key=%s from near cache (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
            this.entryRemovedFromNearCache(null);
        }
        return removed;
    }

    @Override
    public CacheEntry<K, V> get(K key) {
        boolean listenerConnected = this.isConnected();
        if (listenerConnected) {
            CacheEntry<K, V> entry = this.cache.get(key);
            if (log.isTraceEnabled()) {
                log.tracef("Get key=%s returns entry=%s (listenerId=%s)", key, entry, Util.printArray((byte[])this.listenerId));
            }
            return entry;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Near cache disconnected from server, returning null for key=%s (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
        if (log.isTraceEnabled()) {
            log.tracef("Cleared near cache (listenerId=%s)", Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        return this.cache.iterator();
    }

    boolean isConnected() {
        return this.listenerNotifier.isListenerConnected(this.listenerId);
    }

    public void setInvalidationCallback(Runnable r) {
        this.invalidationCallback = r;
    }

    public int getBloomFilterBits() {
        return this.bloomFilterBits;
    }

    public byte[] getListenerId() {
        return this.listenerId;
    }

    public byte[] calculateBloomBits() {
        if (this.bloomFilterBits <= 0) {
            return null;
        }
        BloomFilter bloomFilter = MurmurHash3BloomFilter.createFilter((int)this.bloomFilterBits);
        for (CacheEntry cacheEntry : this.cache) {
            bloomFilter.addToFilter((Object)this.remote.keyToBytes(cacheEntry.key()));
        }
        IntSet intSet = bloomFilter.getIntSet();
        return intSet.toBitSet();
    }

    private static class InvalidatedNearCacheListener<K, V> {
        private static final Log log = LogFactory.getLog(InvalidatedNearCacheListener.class);
        private final NearCache<K, V> cache;

        private InvalidatedNearCacheListener(NearCache<K, V> cache) {
            this.cache = cache;
        }

        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        public void handleRemovedEvent(ClientCacheEntryRemovedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        public void handleExpiredEvent(ClientCacheEntryExpiredEvent<K> event) {
            this.invalidate(event.getKey());
        }

        public void handleFailover(ClientCacheFailoverEvent e) {
            if (log.isTraceEnabled()) {
                log.trace("Clear near cache after fail-over of server");
            }
            this.cache.clear();
        }

        private void invalidate(K key) {
            this.cache.remove(key);
        }
    }
}

