/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.services.client;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.imixs.workflow.services.WorkflowReportService;
import org.imixs.workflow.services.client.DataObjectUtil;
import org.imixs.workflow.services.client.ServiceClient;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.EntityCollection;

public class WorkflowReportClient
implements WorkflowReportService {
    private ServiceClient serviceClient = null;
    private String NAME_SPACE = "http://imixs.org/workflow/services";

    public WorkflowReportClient(String aServiceEndpoint, String aUserName, String aPassword) {
        this.serviceClient = new ServiceClient(aServiceEndpoint);
        this.serviceClient.setCredentials(aUserName, aPassword);
    }

    public String getNameSpace() {
        return this.NAME_SPACE;
    }

    public void setNameSpace(String s) {
        this.NAME_SPACE = s;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public Entity getReport(String name) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getReport");
        Object[] opArgs = new Object[]{name};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"reportid", "attributes"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof Entity) {
            return (Entity)o;
        }
        return null;
    }

    public EntityCollection getReportList(int start, int count) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getReportList");
        Object[] opArgs = new Object[]{new Integer(start), new Integer(count)};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"startpos", "count", "attributes"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public EntityCollection processQuery(String reportid) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "processQuery");
        Object[] opArgs = new Object[]{reportid};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"reportid", "attributes"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public void updateReport(Entity report) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "updateReport");
        Object[] opArgs = new Object[]{report};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"report"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }

    public void updateReportList(EntityCollection reportList) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "updateReportList");
        Object[] opArgs = new Object[]{reportList};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"reportlist"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }
}

