/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.services.client;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.imixs.workflow.services.WorkflowModelService;
import org.imixs.workflow.services.client.DataObjectUtil;
import org.imixs.workflow.services.client.ServiceClient;
import org.imixs.workflow.services.dataobjects.EntityCollection;

public class WorkflowModelClient
implements WorkflowModelService {
    private ServiceClient serviceClient = null;
    private String NAME_SPACE = "http://imixs.org/workflow/services";

    public WorkflowModelClient(String aServiceEndpoint, String aUserName, String aPassword) {
        this.serviceClient = new ServiceClient(aServiceEndpoint);
        this.serviceClient.setCredentials(aUserName, aPassword);
    }

    public String getNameSpace() {
        return this.NAME_SPACE;
    }

    public void setNameSpace(String s) {
        this.NAME_SPACE = s;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public EntityCollection getProcessList() throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getProcessList");
        Object[] opArgs = new Object[0];
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, null);
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public EntityCollection getProcessListByVersion(String modelVersion) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getProcessListByVersion");
        Object[] opArgs = new Object[]{modelVersion};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"modelversion"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public EntityCollection getActivityList(int processID) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getActivityList");
        Object[] opArgs = new Object[]{new Integer(processID)};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"processid"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public EntityCollection getActivityListByVersion(int processID, String modelVersion) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getActivityListByVersion");
        Object[] opArgs = new Object[]{new Integer(processID), modelVersion};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"processid", "modelversion"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public EntityCollection getEnvironmentList() throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getEnvironmentList");
        Object[] opArgs = new Object[0];
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, null);
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public EntityCollection getEnvironmentListByVersion(String modelVersion) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getEnvironmentListByVersion");
        Object[] opArgs = new Object[]{modelVersion};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"modelversion"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }

    public void updateActivityList(int processID, EntityCollection activityList) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "updateActivityList");
        Object[] opArgs = new Object[]{new Integer(processID), activityList};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"processid", "activitylist"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }

    public void updateEnvironmentList(EntityCollection envList) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "updateEnvironmentList");
        Object[] opArgs = new Object[]{envList};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"environmentlist"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }

    public void updateProcessList(EntityCollection envList) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "updateProcessList");
        Object[] opArgs = new Object[]{envList};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"processlist"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }

    public void removeModelVersion(String modelVersion) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "removeModelVersion");
        Object[] opArgs = new Object[]{modelVersion};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"modelversion"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }
}

