/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.services.client;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.imixs.workflow.services.WorkflowManagerService;
import org.imixs.workflow.services.client.DataObjectUtil;
import org.imixs.workflow.services.client.ServiceClient;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.EntityCollection;

public class WorkflowManagerClient
implements WorkflowManagerService {
    private ServiceClient serviceClient = null;
    private String NAME_SPACE = "http://imixs.org/workflow/services";

    public WorkflowManagerClient(String aServiceEndpoint, String aUserName, String aPassword) {
        this.serviceClient = new ServiceClient(aServiceEndpoint);
        this.serviceClient.setCredentials(aUserName, aPassword);
    }

    public String getNameSpace() {
        return this.NAME_SPACE;
    }

    public void setNameSpace(String s) {
        this.NAME_SPACE = s;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public Entity createWorkItem(int processID) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "createWorkItem");
        Object[] opArgs = new Object[]{new Integer(processID)};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"processid"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof Entity) {
            return (Entity)o;
        }
        return null;
    }

    public Entity getWorkItem(String workitemID) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "getWorkItem");
        Object[] opArgs = new Object[]{workitemID};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"workitemid", "attributes"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof Entity) {
            return (Entity)o;
        }
        return null;
    }

    public EntityCollection getWorkList(String name, int start, int count) throws Exception {
        return this.getWorkListByMethodName("getWorkList", name, start, count);
    }

    public EntityCollection getWorkListByCreator(String name, int start, int count) throws Exception {
        return this.getWorkListByMethodName("getWorkListByCreator", name, start, count);
    }

    public EntityCollection getWorkListByGroup(String name, int start, int count) throws Exception {
        return this.getWorkListByMethodName("getWorkListByGroup", name, start, count);
    }

    public EntityCollection getWorkListByRef(String aref, int startpos, int count) throws Exception {
        return this.getWorkListByMethodName("getWorkListByRef", aref, startpos, count);
    }

    public EntityCollection getWorkListByProcessID(int id, int start, int count) throws Exception {
        return this.getWorkListByMethodName("getWorkListByProcessID", "" + id, start, count);
    }

    public boolean isAuthor(String workitemID) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "isAuthor");
        Object[] opArgs = new Object[]{workitemID};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"workitemid"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Boolean bResult = (Boolean)DataObjectUtil.deserialize(response);
        return bResult;
    }

    public Entity processWorkItem(Entity workitem, int activityID) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "processWorkItem");
        Object[] opArgs = new Object[]{workitem, new Integer(activityID)};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"workitem", "activityid", "attributes"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof Entity) {
            return (Entity)o;
        }
        return null;
    }

    public void removeWorkItem(String workitemid) throws Exception {
        QName opName = new QName(this.NAME_SPACE, "removeWorkItem");
        Object[] opArgs = new Object[]{workitemid};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"workitemid"});
        this.serviceClient.callSOAPAction(opName, requestData);
    }

    private EntityCollection getWorkListByMethodName(String aMethodName, String name, int start, int count) throws Exception {
        QName opName = new QName(this.NAME_SPACE, aMethodName);
        Object[] opArgs = new Object[]{name, new Integer(start), new Integer(count)};
        OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs, new String[]{"key", "startpos", "count", "attributes"});
        OMElement response = this.serviceClient.callSOAPAction(opName, requestData);
        Object o = DataObjectUtil.deserialize(response);
        if (o instanceof EntityCollection) {
            return (EntityCollection)o;
        }
        return new EntityCollection();
    }
}

