/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.services.client;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;

public class ServiceClient {
    public static final int SOAP11 = 11;
    public static final int SOAP12 = 12;
    private SOAPFactory factory = null;
    private int iSoapType = 11;
    private String serviceEndpoint;
    private String sUser = null;
    private String sPassword = null;
    private String encoding = "UTF-8";
    private int iLastHTTPResult = 0;
    private OMElement lastSOAPResponse = null;

    public ServiceClient(String aServiceEndpoint) {
        this.serviceEndpoint = aServiceEndpoint;
    }

    public void setCredentials(String auser, String apw) {
        this.sUser = auser;
        this.sPassword = apw;
    }

    public void setSoapType(int i) {
        this.iSoapType = i;
    }

    public void setEncoding(String aEncoding) {
        this.encoding = aEncoding;
    }

    public OMElement callSOAPAction(QName soapAction, OMElement requestEntity) throws Exception {
        OMElement responseElement = null;
        PrintWriter printWriter = null;
        String sSoapAction = soapAction.getLocalPart();
        try {
            URLConnection urlConnection = new URL(this.serviceEndpoint).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setAllowUserInteraction(false);
            if (this.sUser != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + this.getAccessByUser());
            }
            urlConnection.setRequestProperty("Content-Type", "text/xml; charset=" + this.encoding);
            urlConnection.setRequestProperty("SOAPAction", "/" + sSoapAction);
            SOAPEnvelope envelope = this.createSOAPEnvelope();
            envelope.getBody().addChild((OMNode)requestEntity);
            urlConnection.setRequestProperty("Content-Length", "" + new Integer(envelope.toString().getBytes().length));
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), this.encoding)));
            printWriter.write(envelope.toString());
            printWriter.close();
            String sHTTPResponse = urlConnection.getHeaderField(0);
            try {
                this.iLastHTTPResult = Integer.parseInt(sHTTPResponse.substring(9, 12));
            }
            catch (Exception eNumber) {
                this.iLastHTTPResult = 500;
            }
            InputStream is = urlConnection.getInputStream();
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(is);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            this.lastSOAPResponse = responseElement = builder.getDocumentElement();
            QName opNameBody = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            OMElement soapBody = responseElement.getFirstChildWithName(opNameBody);
            if (soapBody != null) {
                responseElement = soapBody.getFirstElement();
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return responseElement;
    }

    public int getLastHTTPResult() {
        return this.iLastHTTPResult;
    }

    public OMElement getLastSOAPResponse() {
        return this.lastSOAPResponse;
    }

    private SOAPEnvelope createSOAPEnvelope() {
        this.factory = this.iSoapType == 12 ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = this.factory.getDefaultEnvelope();
        return envelope;
    }

    private String getAccessByUser() {
        String sURLAccess = "";
        String sUserCode = String.valueOf(this.sUser) + ":" + this.sPassword;
        sURLAccess = Base64.encode((byte[])sUserCode.getBytes());
        return sURLAccess;
    }
}

