/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.services.client;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.EntityCollection;
import org.imixs.workflow.services.dataobjects.Item;

public class DataObjectUtil {
    static OMFactory factory = null;
    static OMNamespace xsNameSpace = null;
    static OMNamespace xsiNameSpace = null;
    static String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public static OMElement getOMElement(QName qName, Object[] args, String[] argnames) {
        factory = OMAbstractFactory.getOMFactory();
        xsNameSpace = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xs");
        xsiNameSpace = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        OMNamespace ns0 = factory.createOMNamespace(qName.getNamespaceURI(), "ns0");
        OMElement method = factory.createOMElement(qName.getLocalPart(), ns0);
        int i = 0;
        while (i < args.length) {
            Object argumentObject = args[i];
            OMElement argument = null;
            argument = argnames != null && argnames[i] != null ? factory.createOMElement(argnames[i], null) : factory.createOMElement("arg" + i, null);
            DataObjectUtil.writeArgument(argument, argumentObject);
            method.addChild((OMNode)argument);
            ++i;
        }
        return method;
    }

    private static void writeArgument(OMElement value, Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof EntityCollection) {
            EntityCollection entCol = (EntityCollection)o;
            if (entCol.getEntities() != null) {
                OMNamespace ns = value.getNamespace();
                int i = 0;
                while (i < entCol.getEntities().length) {
                    OMElement entities = factory.createOMElement("entity", ns);
                    Entity ent = entCol.getEntities(i);
                    DataObjectUtil.writeEntity(entities, ent);
                    value.addChild((OMNode)entities);
                    ++i;
                }
            }
        } else if (o instanceof Entity) {
            Entity entity = (Entity)o;
            DataObjectUtil.writeEntity(value, entity);
        } else {
            value.addChild((OMNode)factory.createOMText((OMContainer)value, o.toString()));
        }
    }

    private static void writeEntity(OMElement parent, Entity ent) {
        OMNamespace ns = parent.getNamespace();
        int i = 0;
        while (i < ent.getItems().length) {
            OMElement entities = factory.createOMElement("item", ns);
            Item it = ent.getItems(i);
            DataObjectUtil.writeItem(entities, it);
            parent.addChild((OMNode)entities);
            ++i;
        }
    }

    private static void writeItem(OMElement parent, Item item) {
        OMNamespace ns = parent.getNamespace();
        OMElement itemname = factory.createOMElement("name", ns);
        itemname.addChild((OMNode)factory.createOMText((OMContainer)parent, item.getName()));
        parent.addChild((OMNode)itemname);
        Object[] values = item.getValues();
        int i = 0;
        while (i < values.length) {
            Object o = values[i];
            if (o != null) {
                OMElement itemvalue = factory.createOMElement("value", ns);
                itemvalue.declareNamespace(xsNameSpace);
                itemvalue.declareNamespace(xsiNameSpace);
                OMAttribute typeAttribute = null;
                if (o instanceof String) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:string");
                }
                if (o instanceof Integer) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:int");
                }
                if (o instanceof Calendar || o instanceof Date) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:dateTime");
                }
                if (o instanceof Double) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:double");
                }
                if (o instanceof Long) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:long");
                }
                if (o instanceof Short) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:short");
                }
                if (o instanceof Boolean) {
                    typeAttribute = factory.createOMAttribute("type", xsiNameSpace, "xs:boolean");
                }
                if (typeAttribute != null) {
                    itemvalue.addAttribute(typeAttribute);
                }
                String objectValue = "";
                if (o instanceof Calendar || o instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
                    Date aDate = null;
                    aDate = o instanceof Calendar ? ((Calendar)o).getTime() : (Date)o;
                    objectValue = sdf.format(aDate);
                } else {
                    objectValue = o.toString();
                }
                itemvalue.addChild((OMNode)factory.createOMText((OMContainer)parent, objectValue));
                parent.addChild((OMNode)itemvalue);
            }
            ++i;
        }
    }

    public static Object deserialize(OMElement response) {
        EntityCollection entityCollection = new EntityCollection();
        OMElement firstResult = response.getFirstElement();
        Iterator iteratorEntities = firstResult.getChildrenWithName(new QName("", "entity"));
        Iterator iteratorItems = firstResult.getChildrenWithName(new QName("", "item"));
        if (iteratorEntities != null && iteratorEntities.hasNext()) {
            Vector<Entity> vectorEntities = new Vector<Entity>();
            while (iteratorEntities.hasNext()) {
                OMElement entityElement = (OMElement)iteratorEntities.next();
                iteratorItems = entityElement.getChildrenWithName(new QName("", "item"));
                Entity entity = DataObjectUtil.readEntity(iteratorItems);
                vectorEntities.add(entity);
            }
            Entity[] entities = new Entity[vectorEntities.size()];
            int i = 0;
            Iterator iter = vectorEntities.iterator();
            while (iter.hasNext()) {
                Entity entity;
                entities[i] = entity = (Entity)iter.next();
                ++i;
            }
            entityCollection.setEntities(entities);
            return entityCollection;
        }
        if (iteratorItems != null && iteratorItems.hasNext()) {
            Entity entity = DataObjectUtil.readEntity(iteratorItems);
            return entity;
        }
        String sText = firstResult.getText();
        try {
            if ("true".equals(sText) || "false".equals(sText)) {
                return new Boolean(sText);
            }
            if (sText.indexOf(".") > 0 || sText.indexOf(",") > 0) {
                return new Double(sText);
            }
            return new Integer(sText);
        }
        catch (Exception exception) {
            return sText;
        }
    }

    private static Entity readEntity(Iterator iteratorItems) {
        Entity entity = new Entity();
        Vector<Item> vectorItems = new Vector<Item>();
        while (iteratorItems.hasNext()) {
            OMElement itemElement = (OMElement)iteratorItems.next();
            Item item = DataObjectUtil.readItem(itemElement);
            vectorItems.add(item);
        }
        Item[] items = new Item[vectorItems.size()];
        int i = 0;
        Iterator iter = vectorItems.iterator();
        while (iter.hasNext()) {
            Item item;
            items[i] = item = (Item)iter.next();
            ++i;
        }
        entity.setItems(items);
        return entity;
    }

    private static Item readItem(OMElement itemElement) {
        Item item = new Item();
        Iterator itemName = itemElement.getChildrenWithName(new QName("", "name"));
        Iterator itemValues = itemElement.getChildrenWithName(new QName("", "value"));
        if (itemName.hasNext()) {
            OMElement nameElement = (OMElement)itemName.next();
            item.setName(nameElement.getText());
            Vector<Object> vectorValues = new Vector<Object>();
            while (itemValues.hasNext()) {
                OMElement valueElement = (OMElement)itemValues.next();
                String sType = valueElement.getAttributeValue(new QName(xsiNameSpace.getNamespaceURI(), "type"));
                String sValue = valueElement.getText();
                try {
                    if (sType.equals("xs:string")) {
                        vectorValues.add(sValue);
                        continue;
                    }
                    if (sType.equals("xs:int") || sType.equals("xs:integer")) {
                        vectorValues.add(new Integer(sValue));
                        continue;
                    }
                    if (sType.equals("xs:dateTime")) {
                        SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
                        Date date = sdf.parse(sValue);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(date);
                        vectorValues.add(cal);
                        continue;
                    }
                    if (sType.equals("xs:double")) {
                        vectorValues.add(new Double(sValue));
                        continue;
                    }
                    if (sType.equals("xs:long")) {
                        vectorValues.add(new Long(sValue));
                        continue;
                    }
                    if (sType.equals("xs:short")) {
                        vectorValues.add(new Short(sValue));
                        continue;
                    }
                    if (sType.equals("xs:float")) {
                        vectorValues.add(new Float(sValue));
                        continue;
                    }
                    if (sType.equals("xs:boolean")) {
                        vectorValues.add(new Boolean(sValue));
                        continue;
                    }
                    vectorValues.add(sValue);
                }
                catch (Exception e) {
                    vectorValues.add(sValue);
                }
            }
            item.setValues(vectorValues.toArray());
        }
        return item;
    }
}

