/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.scheduler;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.ScheduleExpression;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerConfigurationService;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@Stateless
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SchedulerService {
    public static final String DOCUMENT_TYPE = "scheduler";
    @Resource
    SessionContext ctx;
    @EJB
    DocumentService documentService;
    @Resource
    TimerService timerService;
    @EJB
    SchedulerConfigurationService schedulerSaveService;
    @Inject
    @Any
    private Instance<Scheduler> schedulerHandlers;
    private static Logger logger = Logger.getLogger(SchedulerService.class.getName());

    public ItemCollection loadConfiguration(String name) {
        try {
            String sQuery = "(type:\"scheduler\" AND txtname:\"" + name + "\")";
            List<ItemCollection> col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                ItemCollection configuration = (ItemCollection)col.iterator().next();
                this.updateTimerDetails(configuration);
                return configuration;
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public ItemCollection saveConfiguration(ItemCollection configItemCollection) {
        String name = configItemCollection.getItemValueString("txtname");
        if (name == null || name.isEmpty()) {
            throw new InvalidAccessException(SchedulerService.class.getName(), "INVALID_WORKITEM", " scheduler configuraiton must contain the item 'txtname'");
        }
        configItemCollection.replaceItemValue("type", (Object)DOCUMENT_TYPE);
        configItemCollection.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection.replaceItemValue("$readAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        this.updateTimerDetails(configItemCollection);
        configItemCollection = this.documentService.save(configItemCollection);
        return configItemCollection;
    }

    public ItemCollection start(ItemCollection configuration) throws AccessDeniedException, ParseException {
        Timer timer = null;
        if (configuration == null) {
            return null;
        }
        String id = configuration.getUniqueID();
        timer = this.findTimer(id);
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                logger.warning("...failed to stop existing timer for '" + configuration.getUniqueID() + "'!");
                throw new InvalidAccessException(SchedulerService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        logger.info("...Scheduler Service " + configuration.getUniqueID() + " will be started...");
        String schedulerDescription = configuration.getItemValueString("_scheduler_definition");
        if (!schedulerDescription.isEmpty()) {
            timer = this.createTimerOnCalendar(configuration);
        }
        if (timer != null) {
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String msg = "started at " + dateFormatDE.format(calNow.getTime()) + " by " + this.ctx.getCallerPrincipal().getName();
            configuration.replaceItemValue("_scheduler_status", (Object)msg);
            logger.info("...Scheduler Service " + id + " (" + configuration.getItemValueString("txtName") + ") successfull started.");
        }
        configuration.replaceItemValue("_scheduler_enabled", (Object)true);
        configuration.replaceItemValue("_scheduler_errormessage", (Object)"");
        configuration.replaceItemValue("_scheduler_logmessage", (Object)"");
        return configuration;
    }

    public ItemCollection stop(ItemCollection configuration) {
        Timer timer = this.findTimer(configuration.getUniqueID());
        return this.stop(configuration, timer);
    }

    public ItemCollection stop(ItemCollection configuration, Timer timer) {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Exception e) {
                logger.info("...failed to stop timer for '" + configuration.getUniqueID() + "'!");
            }
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String message = "stopped at " + dateFormatDE.format(calNow.getTime());
            String name = this.ctx.getCallerPrincipal().getName();
            if (name != null && !name.isEmpty() && !"anonymous".equals(name)) {
                message = message + " by " + name;
            }
            configuration.replaceItemValue("_scheduler_status", (Object)message);
            logger.info("... scheduler " + configuration.getItemValueString("txtName") + " stopped: " + configuration.getUniqueID());
        } else {
            String msg = "stopped";
            configuration.replaceItemValue("_scheduler_status", (Object)msg);
        }
        configuration.removeItem("nextTimeout");
        configuration.removeItem("timeRemaining");
        configuration.replaceItemValue("_scheduler_enabled", (Object)false);
        Calendar cal = Calendar.getInstance();
        configuration.appendItemValue("_scheduler_logmessage", (Object)("Stopped: " + cal.getTime()));
        return configuration;
    }

    public void startAllSchedulers() {
        logger.info("...starting Imixs Schedulers....");
        try {
            String sQuery = "(type:\"scheduler\" )";
            List<ItemCollection> col = this.documentService.find(sQuery, 1, 0);
            for (ItemCollection schedulerConfig : col) {
                if (schedulerConfig != null && schedulerConfig.getItemValueBoolean("_scheduler_enabled") && this.findTimer(schedulerConfig.getUniqueID()) == null) {
                    try {
                        this.start(schedulerConfig);
                    }
                    catch (Exception e) {
                        logger.severe("...start of Scheduler Service " + schedulerConfig.getUniqueID() + " failed! - " + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                logger.info("...Scheduler Service " + schedulerConfig.getUniqueID() + " is disabled. ");
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
    }

    public Timer findTimer(String id) {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!id.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    public void updateTimerDetails(ItemCollection configuration) {
        if (configuration == null) {
            return;
        }
        String id = configuration.getUniqueID();
        try {
            Timer timer = this.findTimer(id);
            if (timer != null) {
                configuration.replaceItemValue("nextTimeout", (Object)timer.getNextTimeout());
                configuration.replaceItemValue("timeRemaining", (Object)timer.getTimeRemaining());
            } else {
                configuration.removeItem("nextTimeout");
                configuration.removeItem("timeRemaining");
            }
        }
        catch (Exception e) {
            logger.warning("unable to updateTimerDetails: " + e.getMessage());
            configuration.removeItem("nextTimeout");
            configuration.removeItem("timeRemaining");
        }
    }

    Scheduler findSchedulerByName(String schedulerClassName) {
        if (schedulerClassName == null || schedulerClassName.isEmpty()) {
            return null;
        }
        if (this.schedulerHandlers == null || !this.schedulerHandlers.iterator().hasNext()) {
            logger.finest("......no CDI schedulers injected");
            return null;
        }
        logger.finest("......injecting CDI Scheduler '" + schedulerClassName + "'...");
        for (Scheduler scheduler : this.schedulerHandlers) {
            if (!scheduler.getClass().getName().equals(schedulerClassName)) continue;
            logger.finest("......CDI Scheduler class '" + schedulerClassName + "' successful injected");
            return scheduler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    void onTimeout(Timer timer) throws Exception {
        String errorMes = "";
        long lProfiler = System.currentTimeMillis();
        String id = timer.getInfo().toString();
        ItemCollection configuration = this.documentService.load(id);
        if (configuration == null) {
            logger.severe("...failed to load scheduler configuration for current timer. Timer will be stopped...");
            return;
        }
        try {
            String schedulerClassName = configuration.getItemValueString("_scheduler_class");
            Scheduler scheduler = this.findSchedulerByName(schedulerClassName);
            if (scheduler != null) {
                logger.info("...run scheduler '" + id + "' scheduler class='" + schedulerClassName + "'....");
                Calendar cal = Calendar.getInstance();
                configuration.replaceItemValue("_scheduler_logmessage", (Object)("Started: " + cal.getTime()));
                configuration = scheduler.run(configuration);
                logger.info("...run scheduler  '" + id + "' finished in: " + (System.currentTimeMillis() - lProfiler) + " ms");
                cal = Calendar.getInstance();
                configuration.appendItemValue("_scheduler_logmessage", (Object)("Finished: " + cal.getTime()));
                if (!configuration.getItemValueBoolean("_scheduler_enabled")) {
                    logger.info("...scheduler '" + id + "' disabled -> timer will be stopped...");
                    this.stop(configuration);
                }
            } else {
                errorMes = "Scheduler class='" + schedulerClassName + "' not found!";
                logger.warning("...scheduler '" + id + "' scheduler class='" + schedulerClassName + "' not found, timer will be stopped...");
                configuration.setItemValue("_scheduler_enabled", (Object)false);
                this.stop(configuration);
            }
        }
        catch (RuntimeException | SchedulerException e) {
            if (logger.isLoggable(Level.FINEST)) {
                ((Throwable)e).printStackTrace();
            }
            errorMes = ((Throwable)e).getMessage();
            logger.severe("Scheduler '" + id + "' failed: " + errorMes);
            configuration.appendItemValue("_scheduler_logmessage", (Object)("Error: " + errorMes));
            configuration = this.stop(configuration, timer);
        }
        finally {
            if (configuration != null) {
                configuration.replaceItemValue("_scheduler_errormessage", (Object)errorMes);
                this.schedulerSaveService.storeConfigurationInNewTransaction(configuration);
            }
        }
    }

    Timer createTimerOnCalendar(ItemCollection configItemCollection) throws ParseException {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)((Object)configItemCollection.getUniqueID()));
        ScheduleExpression scheduerExpression = new ScheduleExpression();
        List calendarConfiguation = configItemCollection.getItemValue("_scheduler_definition");
        for (String confgEntry : calendarConfiguation) {
            Date convertedDate;
            SimpleDateFormat dateFormat;
            if (confgEntry.startsWith("second=")) {
                scheduerExpression.second(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("minute=")) {
                scheduerExpression.minute(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("hour=")) {
                scheduerExpression.hour(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfWeek=")) {
                scheduerExpression.dayOfWeek(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfMonth=")) {
                scheduerExpression.dayOfMonth(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("month=")) {
                scheduerExpression.month(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("year=")) {
                scheduerExpression.year(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("timezone=")) {
                scheduerExpression.timezone(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("start=")) {
                dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
                scheduerExpression.start(convertedDate);
            }
            if (!confgEntry.startsWith("end=")) continue;
            dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
            scheduerExpression.end(convertedDate);
        }
        Timer timer = this.timerService.createCalendarTimer(scheduerExpression, timerConfig);
        return timer;
    }
}

