/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.PropertyService;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.engine.lucene.LuceneItemAdapter;
import org.imixs.workflow.exceptions.IndexException;

@Singleton
public class LuceneUpdateService {
    protected static final String DEFAULT_ANALYSER = ClassicAnalyzer.class.getName();
    protected static final String DEFAULT_INDEX_DIRECTORY = "imixs-workflow-index";
    protected static final String ANONYMOUS = "ANONYMOUS";
    public static final String EVENTLOG_TYPE_ADD = "lucene_event_add";
    public static final String EVENTLOG_TYPE_REMOVE = "lucene_event_remove";
    protected static final String EVENTLOG_ID_PRAFIX = "lucene_event_id_";
    protected static final int EVENTLOG_ENTRY_FLUSH_COUNT = 16;
    private List<String> searchFieldList = null;
    private List<String> indexFieldListAnalyse = null;
    private List<String> indexFieldListNoAnalyse = null;
    private String indexDirectoryPath = null;
    private String analyserClass = null;
    private Properties properties = null;
    private static List<String> DEFAULT_SEARCH_FIELD_LIST = Arrays.asList("$workflowsummary", "$workflowabstract");
    private static List<String> DEFAULT_NOANALYSE_FIELD_LIST = Arrays.asList("$modelversion", "$taskid", "$processid", "$workitemid", "$uniqueidref", "type", "$writeaccess", "$modified", "$created", "namcreator", "$creator", "$editor", "$lasteditor", "$workflowgroup", "$workflowstatus", "txtworkflowgroup", "txtname", "namowner", "txtworkitemref", "$uniqueidsource", "$uniqueidversions", "$lasttask", "$lastevent", "$lasteventdate");
    @EJB
    PropertyService propertyService;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @Inject
    LuceneItemAdapter luceneItemAdapter;
    private static Logger logger = Logger.getLogger(LuceneUpdateService.class.getName());

    @PostConstruct
    void init() {
        String sName;
        StringTokenizer st;
        this.properties = this.propertyService.getProperties();
        this.indexDirectoryPath = this.properties.getProperty("lucence.indexDir", DEFAULT_INDEX_DIRECTORY);
        this.analyserClass = this.properties.getProperty("lucence.analyzerClass", DEFAULT_ANALYSER);
        String sFulltextFieldList = this.properties.getProperty("lucence.fulltextFieldList");
        String sIndexFieldListAnalyse = this.properties.getProperty("lucence.indexFieldListAnalyze");
        String sIndexFieldListNoAnalyse = this.properties.getProperty("lucence.indexFieldListNoAnalyze");
        logger.finest("......lucene IndexDir=" + this.indexDirectoryPath);
        logger.finest("......lucene FulltextFieldList=" + sFulltextFieldList);
        logger.finest("......lucene IndexFieldListAnalyse=" + sIndexFieldListAnalyse);
        logger.finest("......lucene IndexFieldListNoAnalyse=" + sIndexFieldListNoAnalyse);
        this.searchFieldList = new ArrayList<String>();
        this.searchFieldList.addAll(DEFAULT_SEARCH_FIELD_LIST);
        if (sFulltextFieldList != null && !sFulltextFieldList.isEmpty()) {
            st = new StringTokenizer(sFulltextFieldList, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName) || this.searchFieldList.contains(sName)) continue;
                this.searchFieldList.add(sName);
            }
        }
        this.indexFieldListAnalyse = new ArrayList<String>();
        if (sIndexFieldListAnalyse != null && !sIndexFieldListAnalyse.isEmpty()) {
            st = new StringTokenizer(sIndexFieldListAnalyse, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
                this.indexFieldListAnalyse.add(sName);
            }
        }
        this.indexFieldListNoAnalyse = new ArrayList<String>();
        this.indexFieldListNoAnalyse.addAll(DEFAULT_NOANALYSE_FIELD_LIST);
        if (sIndexFieldListNoAnalyse != null && !sIndexFieldListNoAnalyse.isEmpty()) {
            st = new StringTokenizer(sIndexFieldListNoAnalyse, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if (this.indexFieldListNoAnalyse.contains(sName)) continue;
                this.indexFieldListNoAnalyse.add(sName);
            }
        }
    }

    public ItemCollection getConfiguration() {
        ItemCollection config = new ItemCollection();
        config.replaceItemValue("lucence.indexDir", (Object)this.indexDirectoryPath);
        config.replaceItemValue("lucence.analyzerClass", (Object)this.analyserClass);
        config.replaceItemValue("lucence.fulltextFieldList", this.searchFieldList);
        config.replaceItemValue("lucence.indexFieldListAnalyze", this.indexFieldListAnalyse);
        config.replaceItemValue("lucence.indexFieldListNoAnalyze", this.indexFieldListNoAnalyse);
        return config;
    }

    public void updateDocument(ItemCollection documentContext) {
        ArrayList<ItemCollection> documents = new ArrayList<ItemCollection>();
        documents.add(documentContext);
        this.updateDocuments(documents);
    }

    public void updateDocuments(Collection<ItemCollection> documents) {
        long ltime = System.currentTimeMillis();
        for (ItemCollection workitem : documents) {
            if (workitem.getItemValueBoolean("$noindex")) continue;
            this.writeEventLogEntry(workitem.getUniqueID(), EVENTLOG_TYPE_ADD);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update eventLog cache in " + (System.currentTimeMillis() - ltime) + " ms (" + documents.size() + " documents to be index)");
        }
    }

    public void updateDocumentsUncommitted(Collection<ItemCollection> documents) {
        IndexWriter awriter = null;
        long ltime = System.currentTimeMillis();
        try {
            awriter = this.createIndexWriter();
            for (ItemCollection workitem : documents) {
                if (workitem.getItemValueBoolean("$noindex")) continue;
                Term term = new Term("$uniqueid", workitem.getItemValueString("$uniqueid"));
                logger.finest("......lucene add/update uncommitted workitem '" + workitem.getItemValueString("$uniqueid") + "' to index...");
                awriter.updateDocument(term, (Iterable)this.createDocument(workitem));
            }
        }
        catch (IOException luceneEx) {
            logger.warning("lucene error: " + luceneEx.getMessage());
            throw new IndexException("INVALID_INDEX", "Unable to update lucene search index", (Exception)luceneEx);
        }
        finally {
            if (awriter != null) {
                logger.finest("......lucene close IndexWriter...");
                try {
                    awriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update worklist in " + (System.currentTimeMillis() - ltime) + " ms (" + documents.size() + " worktiems total)");
        }
    }

    public void removeDocument(String uniqueID) {
        long ltime = System.currentTimeMillis();
        this.writeEventLogEntry(uniqueID, EVENTLOG_TYPE_REMOVE);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update eventLog cache in " + (System.currentTimeMillis() - ltime) + " ms (1 document to be removed)");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean flushEventLog(int junkSize) {
        long total = 0L;
        long count = 0L;
        boolean dirtyIndex = true;
        long l = System.currentTimeMillis();
        while (dirtyIndex) {
            try {
                dirtyIndex = !this.flushEventLogByCount(16);
                if (!dirtyIndex) continue;
                total += 16L;
                if ((count += 16L) >= 100L) {
                    logger.finest("...flush event log: " + total + " entries in " + (System.currentTimeMillis() - l) + "ms...");
                    count = 0L;
                }
                if (total < (long)junkSize) continue;
                logger.finest("...flush event: Issue #439  -> total count >=" + total + " flushEventLog will be continued...");
                return false;
            }
            catch (IndexException e) {
                logger.warning("...unable to flush lucene event log: " + e.getMessage());
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flushEventLogByCount(int count) {
        boolean cacheIsEmpty = true;
        IndexWriter indexWriter = null;
        long l = System.currentTimeMillis();
        logger.finest("......flush eventlog cache....");
        String query = "SELECT document FROM Document AS document ";
        query = query + "WHERE document.type IN ('lucene_event_add','lucene_event_remove') ORDER BY document.created ASC";
        Query q = this.manager.createQuery(query);
        q.setMaxResults(count + 1);
        List documentList = q.getResultList();
        if (documentList != null && documentList.size() > 0) {
            try {
                indexWriter = this.createIndexWriter();
                int _counter = 0;
                for (Document eventLogEntry : documentList) {
                    long l2;
                    String id = eventLogEntry.getId();
                    id = id.substring(EVENTLOG_ID_PRAFIX.length());
                    id = id.substring(id.indexOf("]_") + 2);
                    Document doc = (Document)this.manager.find(Document.class, (Object)id);
                    Term term = new Term("$uniqueid", id);
                    if (doc != null && EVENTLOG_TYPE_ADD.equals(eventLogEntry.getType())) {
                        l2 = System.currentTimeMillis();
                        ItemCollection workitem = new ItemCollection();
                        workitem.setAllItems(doc.getData());
                        if (!workitem.getItemValueBoolean("$noindex")) {
                            indexWriter.updateDocument(term, (Iterable)this.createDocument(workitem));
                            logger.finest("......lucene add/update workitem '" + id + "' to index in " + (System.currentTimeMillis() - l2) + "ms");
                        }
                    } else {
                        l2 = System.currentTimeMillis();
                        indexWriter.deleteDocuments(new Term[]{term});
                        logger.finest("......lucene remove workitem '" + id + "' from index in " + (System.currentTimeMillis() - l2) + "ms");
                    }
                    this.manager.remove((Object)eventLogEntry);
                    if (++_counter < count) continue;
                    cacheIsEmpty = false;
                    break;
                }
            }
            catch (IOException luceneEx) {
                logger.warning("...unable to flush lucene event log: " + luceneEx.getMessage());
                boolean bl = true;
                return bl;
            }
            finally {
                if (indexWriter != null) {
                    logger.finest("......lucene close IndexWriter...");
                    try {
                        indexWriter.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                    }
                }
            }
        }
        logger.fine("...flushEventLog - " + documentList.size() + " documents in " + (System.currentTimeMillis() - l) + " ms");
        return cacheIsEmpty;
    }

    void writeEventLogEntry(String id, String type) {
        Document eventLogEntry = null;
        if (id == null || id.isEmpty()) {
            logger.warning("WriteEventLog failed - given id is empty!");
            return;
        }
        this.manager.setFlushMode(FlushModeType.COMMIT);
        id = "lucene_event_id_[" + LuceneUpdateService.generateEventUID() + "]_" + id;
        eventLogEntry = new Document(id);
        eventLogEntry.setType(type);
        logger.finest("......create new eventLogEntry '" + id + "' => " + type);
        this.manager.persist((Object)eventLogEntry);
    }

    org.apache.lucene.document.Document createDocument(ItemCollection aworkitem) {
        String sValue = null;
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        String sContent = "";
        for (String aFieldname : this.searchFieldList) {
            sValue = "";
            List vValues = aworkitem.getItemValue(aFieldname);
            if (vValues.size() == 0) continue;
            for (Object o : vValues) {
                if (o == null) continue;
                if (o instanceof Calendar || o instanceof Date) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                    String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
                    sValue = sValue + sDateValue + ",";
                    continue;
                }
                sValue = sValue + o.toString() + ",";
            }
            if (sValue == null) continue;
            sContent = sContent + sValue + ",";
        }
        logger.finest("......add lucene field content=" + sContent);
        doc.add((IndexableField)new TextField("content", sContent, Field.Store.NO));
        for (String aFieldname : this.indexFieldListAnalyse) {
            this.addItemValues(doc, aworkitem, aFieldname, true);
        }
        for (String aFieldname : this.indexFieldListNoAnalyse) {
            this.addItemValues(doc, aworkitem, aFieldname, false);
        }
        doc.add((IndexableField)new StringField("$uniqueid", aworkitem.getItemValueString("$uniqueid"), Field.Store.YES));
        List vReadAccess = aworkitem.getItemValue("$readAccess");
        if (vReadAccess.size() == 0 || vReadAccess.size() == 1 && "".equals(((String)vReadAccess.get(0)).toString())) {
            sValue = ANONYMOUS;
            doc.add((IndexableField)new StringField("$readaccess", sValue, Field.Store.NO));
        } else {
            sValue = "";
            for (String sReader : vReadAccess) {
                doc.add((IndexableField)new StringField("$readaccess", sReader, Field.Store.NO));
            }
        }
        return doc;
    }

    void addItemValues(org.apache.lucene.document.Document doc, ItemCollection workitem, String itemName, boolean analyzeValue) {
        if (itemName == null) {
            return;
        }
        List vValues = workitem.getItemValue(itemName = itemName.toLowerCase().trim());
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        boolean firstValue = true;
        for (Object singleValue : vValues) {
            IndexableField indexableField = this.luceneItemAdapter.adaptItemValue(itemName, singleValue, analyzeValue);
            doc.add(indexableField);
            if (!analyzeValue && firstValue) {
                SortedDocValuesField sortedDocField = this.luceneItemAdapter.adaptSortableItemValue(itemName, singleValue);
                doc.add((IndexableField)sortedDocField);
            }
            firstValue = false;
        }
    }

    @Deprecated
    void addItemValuesOld(org.apache.lucene.document.Document doc, ItemCollection workitem, String itemName, boolean analyzeValue) {
        String sValue = null;
        if (itemName == null) {
            return;
        }
        List vValues = workitem.getItemValue(itemName = itemName.toLowerCase().trim());
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        boolean firstValue = true;
        for (Object singleValue : vValues) {
            if (singleValue instanceof Calendar || singleValue instanceof Date) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                String sDateValue = singleValue instanceof Calendar ? dateformat.format(((Calendar)singleValue).getTime()) : dateformat.format((Date)singleValue);
                sValue = sDateValue;
            } else {
                sValue = singleValue.toString();
            }
            logger.finest("......lucene add IndexField (analyse=" + analyzeValue + "): " + itemName + "=" + sValue);
            if (analyzeValue) {
                doc.add((IndexableField)new TextField(itemName, sValue, Field.Store.NO));
            } else {
                doc.add((IndexableField)new StringField(itemName, sValue, Field.Store.NO));
                if (firstValue) {
                    doc.add((IndexableField)new SortedDocValuesField(itemName, new BytesRef((CharSequence)sValue)));
                }
            }
            firstValue = false;
        }
    }

    IndexWriter createIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig;
        FSDirectory indexDir = FSDirectory.open((Path)Paths.get(this.indexDirectoryPath, new String[0]));
        try {
            indexWriterConfig = new IndexWriterConfig((Analyzer)Class.forName(this.analyserClass).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IndexException("INVALID_INDEX", "Unable to create analyzer '" + this.analyserClass + "'", (Exception)e);
        }
        return new IndexWriter((Directory)indexDir, indexWriterConfig);
    }

    static String generateEventUID() {
        int randomNum = ThreadLocalRandom.current().nextInt(10000, 100000);
        return "" + Long.toHexString(System.currentTimeMillis()) + "-" + Integer.toHexString(randomNum);
    }
}

