/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.PropertyService;
import org.imixs.workflow.engine.adminp.AdminPService;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class LuceneSearchService {
    public static final int DEFAULT_MAX_SEARCH_RESULT = 9999;
    public static final int DEFAULT_PAGE_SIZE = 100;
    @EJB
    PropertyService propertyService;
    @EJB
    DocumentService documentService;
    @EJB
    LuceneUpdateService luceneUpdateService;
    @EJB
    AdminPService adminPService;
    private static Logger logger = Logger.getLogger(LuceneSearchService.class.getName());

    @PostConstruct
    void init() {
    }

    public List<ItemCollection> search(String sSearchTerm) throws QueryException {
        return this.search(sSearchTerm, 9999, 0, null, null);
    }

    public List<ItemCollection> search(String sSearchTerm, int pageSize, int pageIndex) throws QueryException {
        return this.search(sSearchTerm, pageSize, pageIndex, null, null);
    }

    public List<ItemCollection> search(String sSearchTerm, int pageSize, int pageIndex, Sort sortOrder, QueryParser.Operator defaultOperator) throws QueryException {
        long ltime = System.currentTimeMillis();
        this.flush();
        if (pageSize <= 0) {
            pageSize = 100;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        logger.finest("......lucene search: pageNumber=" + pageIndex + " pageSize=" + pageSize);
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        sSearchTerm = this.getExtendedSearchTerm(sSearchTerm);
        if (sSearchTerm == null || "".equals(sSearchTerm)) {
            return workitems;
        }
        Properties prop = this.propertyService.getProperties();
        if (prop.isEmpty()) {
            logger.warning("imixs.properties not found!");
            return workitems;
        }
        try {
            IndexSearcher searcher = this.createIndexSearcher(prop);
            QueryParser parser = this.createQueryParser(prop);
            parser.setAllowLeadingWildcard(true);
            if (defaultOperator != null) {
                parser.setDefaultOperator(defaultOperator);
            }
            long lsearchtime = System.currentTimeMillis();
            TopDocs topDocs = null;
            TopScoreDocCollector collector = null;
            int startIndex = pageIndex * pageSize;
            int maxSearchResult = 9999;
            if (startIndex + pageSize > 9999) {
                maxSearchResult = startIndex + 3 * pageSize;
                logger.warning("PageIndex (" + pageSize + "x" + pageIndex + ") exeeded DEFAULT_MAX_SEARCH_RESULT(" + 9999 + ") -> new MAX_SEARCH_RESULT is set to " + maxSearchResult);
            }
            Query query = parser.parse(sSearchTerm);
            if (sortOrder != null) {
                logger.finest("......lucene result sorted by sortOrder= '" + sortOrder + "' ");
                collector = TopFieldCollector.create((Sort)sortOrder, (int)maxSearchResult, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                logger.finest("......lucene result sorted by score ");
                collector = TopScoreDocCollector.create((int)maxSearchResult);
            }
            searcher.search(query, (Collector)collector);
            topDocs = collector.topDocs(startIndex, pageSize);
            ScoreDoc[] scoreDosArray = topDocs.scoreDocs;
            logger.fine("...returned " + scoreDosArray.length + " documents in " + (System.currentTimeMillis() - lsearchtime) + " ms - total hits=" + topDocs.totalHits);
            for (ScoreDoc scoredoc : scoreDosArray) {
                Document doc = searcher.doc(scoredoc.doc);
                String sID = doc.get("$uniqueid");
                logger.finest("......lucene lookup $uniqueid=" + sID);
                ItemCollection itemCol = this.documentService.load(sID);
                if (itemCol != null) {
                    workitems.add(itemCol);
                    continue;
                }
                logger.warning("lucene index returned unreadable workitem : " + sID);
                this.luceneUpdateService.removeDocument(sID);
            }
            searcher.getIndexReader().close();
            logger.fine("...search result computed in " + (System.currentTimeMillis() - ltime) + " ms");
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            logger.severe("Lucene search error: " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return workitems;
    }

    public void flush() {
        long ltime = System.currentTimeMillis();
        int flushCount = 0;
        while (!this.luceneUpdateService.flushEventLog(2048)) {
            flushCount = 2048;
            logger.info("...flush event log: " + flushCount + " entries updated in " + (System.currentTimeMillis() - ltime) + "ms ...");
        }
    }

    public int getTotalHits(String sSearchTerm, int maxResult, QueryParser.Operator defaultOperator) throws QueryException {
        int result;
        if (maxResult <= 0) {
            maxResult = 9999;
        }
        if ((sSearchTerm = this.getExtendedSearchTerm(sSearchTerm)) == null || "".equals(sSearchTerm)) {
            return 0;
        }
        Properties prop = this.propertyService.getProperties();
        if (prop.isEmpty()) {
            logger.warning("imixs.properties not found!");
            return 0;
        }
        try {
            IndexSearcher searcher = this.createIndexSearcher(prop);
            QueryParser parser = this.createQueryParser(prop);
            parser.setAllowLeadingWildcard(true);
            if (defaultOperator != null) {
                parser.setDefaultOperator(defaultOperator);
            }
            TopScoreDocCollector collector = null;
            Query query = parser.parse(sSearchTerm);
            collector = TopScoreDocCollector.create((int)maxResult);
            searcher.search(query, (Collector)collector);
            result = collector.getTotalHits();
            logger.finest("......lucene count result = " + result);
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            logger.severe("Lucene search error: " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    String getExtendedSearchTerm(String sSearchTerm) throws QueryException {
        if (sSearchTerm == null || "".equals(sSearchTerm)) {
            logger.warning("No search term provided!");
            return "";
        }
        if (!this.documentService.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            List<String> userNameList = this.documentService.getUserNameList();
            String sAccessTerm = "($readaccess:ANONYMOUS";
            for (String aRole : userNameList) {
                if ("".equals(aRole)) continue;
                sAccessTerm = sAccessTerm + " OR $readaccess:\"" + aRole + "\"";
            }
            sAccessTerm = sAccessTerm + ") AND ";
            sSearchTerm = sAccessTerm + sSearchTerm;
        }
        logger.finest("......lucene final searchTerm=" + sSearchTerm);
        return sSearchTerm;
    }

    Directory createIndexDirectory(Properties prop) throws IOException {
        logger.finest("......createIndexDirectory...");
        String sIndexDir = prop.getProperty("lucence.indexDir", "imixs-workflow-index");
        FSDirectory indexDir = FSDirectory.open((Path)Paths.get(sIndexDir, new String[0]));
        return indexDir;
    }

    IndexSearcher createIndexSearcher(Properties prop) throws IOException {
        DirectoryReader reader = null;
        logger.finest("......createIndexSearcher...");
        Directory indexDir = this.createIndexDirectory(prop);
        try {
            reader = DirectoryReader.open((Directory)indexDir);
        }
        catch (IOException ioe) {
            if (!DirectoryReader.indexExists((Directory)indexDir)) {
                logger.info("...lucene index does not yet exist, trying to initialize the index....");
                IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new ClassicAnalyzer());
                indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                IndexWriter indexWriter = new IndexWriter(indexDir, indexWriterConfig);
                indexWriter.close();
                reader = DirectoryReader.open((Directory)indexDir);
                logger.info("...lucene index successfull initialized.");
                logger.info("...rebuilding lucene index...");
                ItemCollection job = new ItemCollection();
                job.replaceItemValue("numinterval", (Object)2);
                job.replaceItemValue("job", (Object)"REBUILD_LUCENE_INDEX");
                this.adminPService.createJob(job);
            }
            throw ioe;
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        return searcher;
    }

    QueryParser createQueryParser(Properties prop) {
        QueryParser parser = new QueryParser("content", (Analyzer)new KeywordAnalyzer());
        String defaultOperator = prop.getProperty("lucene.defaultOperator");
        if (defaultOperator != null && "OR".equals(defaultOperator.toUpperCase())) {
            logger.finest("......DefaultOperator: OR");
            parser.setDefaultOperator(QueryParser.Operator.OR);
        } else {
            logger.finest("......DefaultOperator: AND");
            parser.setDefaultOperator(QueryParser.Operator.AND);
        }
        String splitOnWhitespace = prop.getProperty("lucene.splitOnWhitespace", "true");
        boolean bSplitOnWhitespace = Boolean.parseBoolean(splitOnWhitespace);
        logger.finest("......SplitOnWhitespace: " + bSplitOnWhitespace);
        parser.setSplitOnWhitespace(bSplitOnWhitespace);
        return parser;
    }

    public static String escapeSearchTerm(String searchTerm, boolean ignoreBracket) {
        if (searchTerm == null || searchTerm.isEmpty()) {
            return searchTerm;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < searchTerm.length(); ++i) {
            char c = searchTerm.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            if (!(ignoreBracket || c != '(' && c != ')')) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeSearchTerm(String searchTerm) {
        return LuceneSearchService.escapeSearchTerm(searchTerm, false);
    }

    public static String normalizeSearchTerm(String searchTerm) throws QueryException {
        if (searchTerm == null) {
            return "";
        }
        if (searchTerm.trim().isEmpty()) {
            return "";
        }
        ClassicAnalyzer analyzer = new ClassicAnalyzer();
        QueryParser parser = new QueryParser("content", (Analyzer)analyzer);
        parser.setAllowLeadingWildcard(true);
        try {
            Query result = parser.parse(LuceneSearchService.escapeSearchTerm(searchTerm, false));
            searchTerm = result.toString("content");
        }
        catch (ParseException e) {
            logger.warning("Unable to normalze serchTerm '" + searchTerm + "'  -> " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return LuceneSearchService.escapeSearchTerm(searchTerm, true);
    }
}

