/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class TextItemValueAdapter {
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());

    public void onEvent(@Observes TextEvent event) {
        String text = event.getText();
        ItemCollection documentContext = event.getDocument();
        String sFormat = "";
        String sSeparator = " ";
        String sPosition = null;
        if (text == null) {
            return;
        }
        if (text.contains("<itemValue") || text.contains("</itemValue>")) {
            logger.warning("Deprecated <itemValue> tag should be lowercase <itemvalue> !");
            text = text.replace("<itemValue", "<itemvalue");
            text = text.replace("</itemValue>", "</itemvalue>");
        }
        List tagList = XMLParser.findTags((String)text, (String)"itemvalue");
        logger.finest("......" + tagList.size() + " tags found");
        for (String tag : tagList) {
            sFormat = XMLParser.findAttribute((String)tag, (String)"format");
            sSeparator = XMLParser.findAttribute((String)tag, (String)"separator");
            sPosition = XMLParser.findAttribute((String)tag, (String)"position");
            Locale locale = null;
            String sLocale = XMLParser.findAttribute((String)tag, (String)"locale");
            if (sLocale != null && !sLocale.isEmpty()) {
                String sCount;
                String sLang;
                StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
                if (stLocale.countTokens() == 1) {
                    sLang = stLocale.nextToken();
                    sCount = sLang.toUpperCase();
                    locale = new Locale(sLang, sCount);
                } else {
                    sLang = stLocale.nextToken();
                    sCount = stLocale.nextToken();
                    locale = new Locale(sLang, sCount);
                }
            }
            String sItemValue = XMLParser.findTagValue((String)tag, (String)"itemvalue");
            List vValue = documentContext.getItemValue(sItemValue);
            String sResult = TextItemValueAdapter.formatItemValues(vValue, sSeparator, sFormat, locale, sPosition);
            int iStartPos = text.indexOf(tag);
            int iEndPos = text.indexOf(tag) + tag.length();
            text = text.substring(0, iStartPos) + sResult + text.substring(iEndPos);
        }
        event.setText(text);
    }

    public static String formatItemValues(List<?> aItem, String aSeparator, String sFormat, Locale locale, String sPosition) {
        StringBuffer sBuffer = new StringBuffer();
        if (aItem == null || aItem.size() == 0) {
            return "";
        }
        if (sPosition == null || sPosition.isEmpty()) {
            for (Object aSingleValue : aItem) {
                String aValue = TextItemValueAdapter.formatObjectValue(aSingleValue, sFormat, locale);
                sBuffer.append(aValue);
                if (aSeparator != null) {
                    sBuffer.append(aSeparator);
                    continue;
                }
                break;
            }
        } else if ("last".equalsIgnoreCase(sPosition)) {
            sBuffer.append(aItem.get(aItem.size() - 1));
        } else {
            sBuffer.append(aItem.get(0));
        }
        String sString = sBuffer.toString();
        if (aSeparator != null && sString.endsWith(aSeparator)) {
            sString = sString.substring(0, sString.lastIndexOf(aSeparator));
        }
        return sString;
    }

    public static String formatItemValues(List<?> aItem, String aSeparator, String sFormat) {
        return TextItemValueAdapter.formatItemValues(aItem, aSeparator, sFormat, null, null);
    }

    public static String formatItemValues(List<?> aItem, String aSeparator, String sFormat, Locale alocale) {
        return TextItemValueAdapter.formatItemValues(aItem, aSeparator, sFormat, alocale, null);
    }

    private static String formatObjectValue(Object o, String format, Locale locale) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null ? new SimpleDateFormat(format, locale) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("AbstractPlugin: Invalid format String '" + format + "'");
                    logger.warning("AbstractPlugin: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }
}

