/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class SimulationService
implements WorkflowContext {
    @Inject
    @Any
    private Instance<Plugin> plugins;
    @EJB
    ModelService modelService;
    @Resource
    SessionContext ctx;
    @Inject
    protected Event<ProcessingEvent> events;
    private static Logger logger = Logger.getLogger(SimulationService.class.getName());

    public ItemCollection processWorkItem(ItemCollection workitem, List<String> vPlugins) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        long l = System.currentTimeMillis();
        if (workitem == null) {
            throw new ProcessingErrorException(SimulationService.class.getSimpleName(), "INVALID_WORKITEM", "WorkflowService: error - workitem is null");
        }
        if (this.events != null) {
            this.events.fire((Object)new ProcessingEvent(workitem, 1));
        } else {
            logger.warning("CDI Support is missing - ProcessingEvent will not be fired");
        }
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        if (vPlugins != null && vPlugins.size() > 0) {
            for (int i = 0; i < vPlugins.size(); ++i) {
                String aPluginClassName = vPlugins.get(i);
                Plugin aPlugin = this.findPluginByName(aPluginClassName);
                if (aPlugin != null) {
                    logger.fine("register CDI plugin class: " + aPluginClassName + "...");
                    workflowkernel.registerPlugin(aPlugin);
                    continue;
                }
                workflowkernel.registerPlugin(aPluginClassName);
            }
        }
        try {
            workitem = workflowkernel.process(workitem);
        }
        catch (PluginException pe) {
            logger.severe("processing workitem '" + workitem.getItemValueString("$uniqueid") + " failed, rollback transaction...");
            throw pe;
        }
        logger.fine("workitem '" + workitem.getItemValueString("$uniqueid") + "' simulated in " + (System.currentTimeMillis() - l) + "ms");
        if (this.events != null) {
            this.events.fire((Object)new ProcessingEvent(workitem, 2));
        }
        List splitWorkitems = workflowkernel.getSplitWorkitems();
        for (ItemCollection splitWorkitemm : splitWorkitems) {
            if (this.events == null) continue;
            this.events.fire((Object)new ProcessingEvent(splitWorkitemm, 2));
        }
        return workitem;
    }

    public ModelManager getModelManager() {
        return this.modelService;
    }

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    private Plugin findPluginByName(String pluginClassName) {
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        if (this.plugins == null || !this.plugins.iterator().hasNext()) {
            logger.fine("[WorkflowService] no CDI plugins injected");
            return null;
        }
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(pluginClassName)) continue;
            logger.fine("[WorkflowService] CDI plugin '" + pluginClassName + "' successful injected");
            return plugin;
        }
        return null;
    }
}

