/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.AccessPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

public class OwnerPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    ItemCollection documentNextProcessEntity;
    private static Logger logger = Logger.getLogger(AccessPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        try {
            this.documentNextProcessEntity = this.getWorkflowService().evalNextTask(adocumentContext, adocumentActivity);
        }
        catch (ModelException e) {
            throw new PluginException(AccessPlugin.class.getSimpleName(), e.getErrorCode(), e.getMessage());
        }
        if (!(this.documentActivity.getItemValueBoolean("keyupdateacl") || this.documentNextProcessEntity != null && this.documentNextProcessEntity.getItemValueBoolean("keyupdateacl"))) {
            return this.documentContext;
        }
        if (this.documentActivity.getItemValueBoolean("keyupdateacl")) {
            this.updateOwnerByItemCollection(this.documentActivity);
        } else {
            this.updateOwnerByItemCollection(this.documentNextProcessEntity);
        }
        return this.documentContext;
    }

    private void updateOwnerByItemCollection(ItemCollection modelEntity) throws PluginException {
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<Object> newOwnerList = new ArrayList<Object>();
        AccessPlugin.mergeRoles(newOwnerList, modelEntity.getItemValue("namOwnershipNames"), this.documentContext, this.getWorkflowService());
        this.mergeFieldList(this.documentContext, newOwnerList, modelEntity.getItemValue("keyOwnershipFields"));
        newOwnerList = this.uniqueList(newOwnerList);
        this.documentContext.replaceItemValue("namowner", newOwnerList);
        if (logger.isLoggable(Level.FINE) && newOwnerList.size() > 0) {
            logger.finest("......Owners:");
            for (int j = 0; j < newOwnerList.size(); ++j) {
                logger.finest("               '" + (String)newOwnerList.get(j) + "'");
            }
        }
    }
}

