/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class JobHandlerRebuildIndex
implements JobHandler {
    private static final int DEFAULT_BLOCK_SIZE = 500;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @Resource
    SessionContext ctx;
    @EJB
    DocumentService documentService;
    @EJB
    LuceneUpdateService luceneService;
    private static Logger logger = Logger.getLogger(JobHandlerRebuildIndex.class.getName());

    @Override
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        long lProfiler = System.currentTimeMillis();
        int iIndex = adminp.getItemValueInteger("numIndex");
        int iBlockSize = adminp.getItemValueInteger("numBlockSize");
        if (iBlockSize <= 0) {
            iBlockSize = 500;
            adminp.replaceItemValue("numBlockSize", (Object)iBlockSize);
        }
        int iUpdates = adminp.getItemValueInteger("numUpdates");
        int iProcessed = adminp.getItemValueInteger("numProcessed");
        String query = this.buildQuery(adminp);
        logger.finest("......JQPL query: " + query);
        adminp.replaceItemValue("txtQuery", (Object)query);
        Query q = this.manager.createQuery(query);
        q.setFirstResult(iIndex);
        q.setMaxResults(iBlockSize);
        List documentList = q.getResultList();
        ArrayList<ItemCollection> col = new ArrayList<ItemCollection>();
        for (Document doc : documentList) {
            col.add(new ItemCollection(doc.getData()));
        }
        int colSize = col.size();
        logger.info("Job REBUILD_LUCENE_INDEX (" + adminp.getUniqueID() + ") - reindexing " + col.size() + " documents...");
        this.luceneService.updateDocuments(col);
        adminp.replaceItemValue("numUpdates", (Object)(iUpdates += colSize));
        adminp.replaceItemValue("numProcessed", (Object)(iProcessed += colSize));
        adminp.replaceItemValue("numIndex", (Object)(iIndex += col.size()));
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        if (time == 0L) {
            time = 1L;
        }
        logger.info("Job REBUILD_LUCENE_INDEX (" + adminp.getUniqueID() + ") - " + colSize + " documents reindexed in " + time + " sec.  (in total: " + iProcessed);
        if (colSize < iBlockSize) {
            adminp.replaceItemValue("iscompleted", (Object)true);
        }
        return adminp;
    }

    private String buildQuery(ItemCollection adminp) {
        Date datFilterFrom = adminp.getItemValueDate("datfrom");
        Date datFilterTo = adminp.getItemValueDate("datto");
        String typeFilter = adminp.getItemValueString("typelist");
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean bAddAnd = false;
        String query = "SELECT document FROM Document AS document ";
        if (datFilterFrom != null || datFilterTo != null || typeFilter != null && !typeFilter.isEmpty()) {
            query = query + " WHERE ";
        }
        if (typeFilter != null && !typeFilter.isEmpty()) {
            List<String> typeList = Arrays.asList(typeFilter.split("\\s*,\\s*"));
            String sType = "";
            for (String aValue : typeList) {
                sType = sType + "'" + aValue.trim() + "',";
            }
            sType = sType.substring(0, sType.length() - 1);
            query = query + " document.type IN(" + sType + ")";
            bAddAnd = true;
        }
        if (datFilterFrom != null) {
            if (bAddAnd) {
                query = query + " AND ";
            }
            query = query + " document.created>='" + isoFormat.format(datFilterFrom) + "' ";
            bAddAnd = true;
        }
        if (datFilterTo != null) {
            if (bAddAnd) {
                query = query + " AND ";
            }
            query = query + " document.created<='" + isoFormat.format(datFilterTo) + "' ";
            bAddAnd = true;
        }
        query = query + " ORDER BY document.created";
        return query;
    }
}

