/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@LocalBean
public class ModelService
implements ModelManager {
    private Map<String, Model> modelStore = null;
    private static Logger logger = Logger.getLogger(ModelService.class.getName());
    @EJB
    DocumentService documentService;
    @Resource
    SessionContext ctx;

    void init() throws AccessDeniedException {
        logger.info("Initalizing ModelService...");
        List<ItemCollection> col = this.documentService.getDocumentsByType("model");
        for (ItemCollection modelEntity : col) {
            Map files = modelEntity.getFiles();
            if (files == null) continue;
            for (Map.Entry entry : files.entrySet()) {
                String fileName = (String)entry.getKey();
                logger.finest("......loading file:" + fileName);
                List fileData = (List)entry.getValue();
                byte[] rawData = (byte[])fileData.get(1);
                ByteArrayInputStream bpmnInputStream = new ByteArrayInputStream(rawData);
                try {
                    BPMNModel model = BPMNParser.parseModel((InputStream)bpmnInputStream, (String)"UTF-8");
                    this.addModel((Model)model);
                }
                catch (Exception e) {
                    logger.warning("Failed to load model '" + fileName + "' : " + e.getMessage());
                }
            }
        }
    }

    public void addModel(Model model) throws ModelException {
        ItemCollection definition = model.getDefinition();
        if (definition == null) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Definition not provided! ");
        }
        String modelVersion = definition.getModelVersion();
        if (modelVersion.isEmpty()) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Version not provided! ");
        }
        logger.finest("......add BPMNModel '" + modelVersion + "'...");
        this.getModelStore().put(modelVersion, model);
    }

    public void removeModel(String modelversion) {
        this.getModelStore().remove(modelversion);
        logger.finest("......removed BPMNModel '" + modelversion + "'...");
    }

    public Model getModel(String version) throws ModelException {
        Model model = this.getModelStore().get(version);
        if (model == null) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "Modelversion '" + version + "' not found!");
        }
        return model;
    }

    public Model getModelByWorkitem(ItemCollection workitem) throws ModelException {
        String modelVersion = workitem.getModelVersion();
        String workflowGroup = workitem.getItemValueString("$workflowgroup");
        if (workflowGroup.isEmpty()) {
            workflowGroup = workitem.getItemValueString("txtworkflowgroup");
        }
        Model model = null;
        try {
            model = this.getModel(modelVersion);
        }
        catch (ModelException me) {
            logger.finest(me.getMessage());
            if (!workflowGroup.isEmpty()) {
                List<String> versions = this.findVersionsByGroup(workflowGroup);
                if (!versions.isEmpty()) {
                    String newVersion = versions.get(0);
                    logger.warning("Deprecated model version: '" + modelVersion + "' -> migrating $uniqueID=" + workitem.getUniqueID() + ", workflowgroup='" + workflowGroup + "' to model version '" + newVersion + "' ");
                    workitem.replaceItemValue("$modelversion", (Object)newVersion);
                    model = this.getModel(newVersion);
                }
            }
            model = null;
        }
        if (model == null) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "Modelversion '" + modelVersion + "' not found! No matching version found for WorkflowGroup '" + workflowGroup + "' ($uniqueid=" + workitem.getUniqueID() + ")");
        }
        return model;
    }

    public List<String> getVersions() {
        Set<String> set = this.getModelStore().keySet();
        ArrayList<String> result = new ArrayList<String>(set);
        return result;
    }

    public List<String> findVersionsByGroup(String group) {
        ArrayList<String> result = new ArrayList<String>();
        logger.finest("......searching model versions for workflowgroup '" + group + "'...");
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            if (!amodel.getGroups().contains(group)) continue;
            result.add(amodel.getVersion());
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public void saveModel(BPMNModel model) throws ModelException {
        if (model != null) {
            this.deleteModel(model.getVersion());
            logger.finest("......save BPMNModel '" + model.getVersion() + "'...");
            BPMNModel bpmnModel = model;
            this.addModel((Model)model);
            ItemCollection modelItemCol = new ItemCollection();
            modelItemCol.replaceItemValue("type", (Object)"model");
            modelItemCol.replaceItemValue("namcreator", (Object)this.ctx.getCallerPrincipal().getName());
            modelItemCol.replaceItemValue("txtname", (Object)bpmnModel.getVersion());
            modelItemCol.addFile(bpmnModel.getRawData(), bpmnModel.getVersion() + ".bpmn", "application/xml");
            this.documentService.save(modelItemCol);
        }
    }

    public void deleteModel(String version) {
        if (version != null) {
            List<ItemCollection> col;
            logger.finest("......delete BPMNModel '" + version + "'...");
            String searchTerm = "(type:\"model\" AND txtname:\"" + version + "\")";
            try {
                col = this.documentService.find(searchTerm, 0, -1);
            }
            catch (QueryException e) {
                logger.severe("removeModelEntity - invalid query: " + e.getMessage());
                throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
            }
            for (ItemCollection modelEntity : col) {
                this.documentService.remove(modelEntity);
            }
            this.removeModel(version);
        }
    }

    public ItemCollection loadModelEntity(String version) {
        if (version != null) {
            List<ItemCollection> col;
            long loadTime = System.currentTimeMillis();
            String searchTerm = "(type:\"model\" AND txtname:\"" + version + "\")";
            try {
                col = this.documentService.find(searchTerm, 1, 0);
            }
            catch (QueryException e) {
                logger.severe("loadModelEntity - invalid version: " + e.getMessage());
                return null;
            }
            if (col != null && col.size() > 0) {
                ItemCollection model = (ItemCollection)col.iterator().next();
                logger.fine("...load BPMNModel '" + version + "' in " + (System.currentTimeMillis() - loadTime) + "ms");
                return model;
            }
            logger.finest("......BPMNModel Entity '" + version + "' not found!");
        }
        return null;
    }

    private Map<String, Model> getModelStore() {
        if (this.modelStore == null) {
            this.modelStore = new TreeMap<String, Model>();
            this.init();
        }
        return this.modelStore;
    }
}

