/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.jee.ejb.EntityService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class JobHandlerMigration3X
implements JobHandler {
    private static final int DEFAULT_BLOCK_SIZE = 100;
    @Resource
    SessionContext ctx;
    @EJB
    DocumentService documentService;
    @EJB
    EntityService entityService;
    private static Logger logger = Logger.getLogger(JobHandlerMigration3X.class.getName());

    @Override
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        long lProfiler = System.currentTimeMillis();
        int iIndex = adminp.getItemValueInteger("numIndex");
        int iBlockSize = adminp.getItemValueInteger("numBlockSize");
        if (iBlockSize <= 0) {
            iBlockSize = 100;
            adminp.replaceItemValue("numBlockSize", (Object)iBlockSize);
        }
        int iUpdates = adminp.getItemValueInteger("numUpdates");
        int iProcessed = adminp.getItemValueInteger("numProcessed");
        String query = "SELECT entity FROM Entity AS entity  ORDER BY entity.created";
        logger.info("Job " + adminp.getUniqueID() + " - index=" + iIndex + " blocksize=" + iBlockSize + " JQPL=" + query);
        adminp.replaceItemValue("txtQuery", (Object)query);
        List<ItemCollection> col = null;
        try {
            col = this.entityService._findAllEntities(query, iIndex, iBlockSize);
        }
        catch (Exception eerror) {
            logger.severe("Job MIGRATION (" + adminp.getUniqueID() + ") - error at: index=" + iIndex + " blocksize=" + iBlockSize + " : " + eerror.getMessage());
            throw new AdminPException("ERROR", "Error (" + iIndex + "-" + (iIndex + iBlockSize) + ")", eerror);
        }
        int colSize = col.size();
        logger.info("Job MIGRATION (" + adminp.getUniqueID() + ") - verifying " + col.size() + " Entity objects for migration. (" + iUpdates + " Entity objects already migrated) ...");
        for (ItemCollection oldEntiy : col) {
            String uid = oldEntiy.getUniqueID();
            ItemCollection migratedEntity = this.documentService.load(uid);
            if (migratedEntity != null) continue;
            oldEntiy.appendItemValue("txtAdminpLog", (Object)(new Date(System.currentTimeMillis()) + " Migrated from Imixs-Workflow 3.X"));
            oldEntiy.replaceItemValue("$workflowGroup", (Object)oldEntiy.getItemValue("txtworkflowGroup"));
            oldEntiy.replaceItemValue("$workflowStatus", (Object)oldEntiy.getItemValue("txtworkflowStatus"));
            this.documentService.save(oldEntiy);
            logger.info("  -> Entity '" + uid + "' migrated.");
            ++iUpdates;
        }
        adminp.replaceItemValue("numUpdates", (Object)iUpdates);
        adminp.replaceItemValue("numIndex", (Object)(iIndex += col.size()));
        adminp.replaceItemValue("numProcessed", (Object)(iProcessed += col.size()));
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        logger.info("Job MIGRATION (" + adminp.getUniqueID() + ") - finished, " + col.size() + " Entity objects verified in " + time + " sec. (" + iUpdates + " Entity objects total migrated)");
        if (colSize < iBlockSize) {
            adminp.replaceItemValue("iscompleted", (Object)true);
        }
        return adminp;
    }
}

