/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class TextPropertyValueAdapter {
    @EJB
    WorkflowService workflowService;
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());

    public void onEvent(@Observes TextEvent event) {
        String text = event.getText();
        if (text.contains("<propertyValue") || text.contains("</propertyValue>")) {
            logger.warning("Deprecated <propertyValue> tag should be lowercase <propertyvalue> !");
            text = text.replace("<propertyValue", "<propertyvalue");
            text = text.replace("</propertyValue>", "</propertyvalue>");
        }
        List tagList = XMLParser.findTags((String)text, (String)"propertyvalue");
        logger.finest("......" + tagList.size() + " tags found");
        for (String tag : tagList) {
            String sPropertyKey = XMLParser.findTagValue((String)tag, (String)"propertyvalue");
            String vValue = this.workflowService.getPropertyService().getProperties().getProperty(sPropertyKey);
            if (vValue == null) {
                logger.warning("[AbstractPlugin] propertyvalue '" + sPropertyKey + "' is not defined in imixs.properties!");
                vValue = "";
            }
            int iStartPos = text.indexOf(tag);
            int iEndPos = text.indexOf(tag) + tag.length();
            text = text.substring(0, iStartPos) + vValue + text.substring(iEndPos);
        }
        event.setText(text);
    }

    public static String formatItemValues(List<?> aItem, String aSeparator, String sFormat, Locale locale, String sPosition) {
        StringBuffer sBuffer = new StringBuffer();
        if (aItem == null || aItem.size() == 0) {
            return "";
        }
        if (sPosition == null || sPosition.isEmpty()) {
            for (Object aSingleValue : aItem) {
                String aValue = TextPropertyValueAdapter.formatObjectValue(aSingleValue, sFormat, locale);
                sBuffer.append(aValue);
                if (aSeparator != null) {
                    sBuffer.append(aSeparator);
                    continue;
                }
                break;
            }
        } else if ("last".equalsIgnoreCase(sPosition)) {
            sBuffer.append(aItem.get(aItem.size() - 1));
        } else {
            sBuffer.append(aItem.get(0));
        }
        String sString = sBuffer.toString();
        if (aSeparator != null && sString.endsWith(aSeparator)) {
            sString = sString.substring(0, sString.lastIndexOf(aSeparator));
        }
        return sString;
    }

    private static String formatObjectValue(Object o, String format, Locale locale) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null ? new SimpleDateFormat(format, locale) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("AbstractPlugin: Invalid format String '" + format + "'");
                    logger.warning("AbstractPlugin: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }
}

