/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

public class AccessPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    ItemCollection documentNextProcessEntity;
    private static Logger logger = Logger.getLogger(AccessPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        try {
            this.documentNextProcessEntity = this.getWorkflowService().evalNextTask(adocumentContext, adocumentActivity);
        }
        catch (ModelException e) {
            throw new PluginException(AccessPlugin.class.getSimpleName(), e.getErrorCode(), e.getMessage());
        }
        if (!(this.documentActivity.getItemValueBoolean("keyupdateacl") || this.documentNextProcessEntity != null && this.documentNextProcessEntity.getItemValueBoolean("keyupdateacl"))) {
            return this.documentContext;
        }
        this.documentContext.replaceItemValue("$readAccess", new Vector());
        this.documentContext.replaceItemValue("$writeAccess", new Vector());
        if (this.documentActivity.getItemValueBoolean("keyupdateacl")) {
            this.updateACLByItemCollection(this.documentActivity);
        } else {
            this.updateACLByItemCollection(this.documentNextProcessEntity);
        }
        return this.documentContext;
    }

    private void updateACLByItemCollection(ItemCollection modelEntity) {
        int j;
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<?> vectorAccess = this.documentContext.getItemValue("$readAccess");
        this.mergeValueList(vectorAccess, modelEntity.getItemValue("namaddreadaccess"));
        this.mergeFieldList(this.documentContext, vectorAccess, modelEntity.getItemValue("keyaddreadfields"));
        vectorAccess = this.uniqueList((List<Object>)vectorAccess);
        this.documentContext.replaceItemValue("$readAccess", vectorAccess);
        if (logger.isLoggable(Level.FINE) && vectorAccess.size() > 0) {
            logger.fine("[AccessPlugin] ReadAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.fine("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
        vectorAccess = this.documentContext.getItemValue("$writeAccess");
        this.mergeValueList(vectorAccess, modelEntity.getItemValue("namaddwriteaccess"));
        this.mergeFieldList(this.documentContext, vectorAccess, modelEntity.getItemValue("keyaddwritefields"));
        vectorAccess = this.uniqueList((List<Object>)vectorAccess);
        this.documentContext.replaceItemValue("$writeAccess", vectorAccess);
        if (logger.isLoggable(Level.FINE) && vectorAccess.size() > 0) {
            logger.fine("[AccessPlugin] WriteAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.fine("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
    }
}

