/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.engine.lucene.LuceneSearchService;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class DocumentService {
    public static final String ACCESSLEVEL_NOACCESS = "org.imixs.ACCESSLEVEL.NOACCESS";
    public static final String ACCESSLEVEL_READERACCESS = "org.imixs.ACCESSLEVEL.READERACCESS";
    public static final String ACCESSLEVEL_AUTHORACCESS = "org.imixs.ACCESSLEVEL.AUTHORACCESS";
    public static final String ACCESSLEVEL_EDITORACCESS = "org.imixs.ACCESSLEVEL.EDITORACCESS";
    public static final String ACCESSLEVEL_MANAGERACCESS = "org.imixs.ACCESSLEVEL.MANAGERACCESS";
    public static final String UNIQUEID = "$uniqueid";
    public static final String UNIQUEIDREF = "$uniqueidref";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String ISAUTHOR = "$isAuthor";
    public static final String NOINDEX = "$noindex";
    public static final String IMMUTABLE = "$immutable";
    public static final String USER_GROUP_LIST = "org.imixs.USER.GROUPLIST";
    private static final Logger logger = Logger.getLogger(DocumentService.class.getName());
    public static final String OPERATION_NOTALLOWED = "OPERATION_NOTALLOWED";
    public static final String INVALID_PARAMETER = "INVALID_PARAMETER";
    public static final String INVALID_UNIQUEID = "INVALID_UNIQUEID";
    @Resource
    SessionContext ctx;
    @Resource(name="ACCESS_ROLES")
    private String accessRoles = "";
    @Resource(name="DISABLE_OPTIMISTIC_LOCKING")
    private Boolean disableOptimisticLocking = false;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @EJB
    private LuceneUpdateService luceneUpdateService;
    @EJB
    private LuceneSearchService luceneSearchService;
    @Inject
    protected Event<DocumentEvent> events;

    public String getAccessRoles() {
        return this.accessRoles;
    }

    public void setAccessRoles(String accessRoles) {
        this.accessRoles = accessRoles;
    }

    public void setDisableOptimisticLocking(Boolean disableOptimisticLocking) {
        this.disableOptimisticLocking = disableOptimisticLocking;
    }

    public Boolean getDisableOptimisticLocking() {
        return this.disableOptimisticLocking;
    }

    public List<String> getUserNameList() {
        Vector<String> userNameList = new Vector<String>();
        userNameList.add(this.ctx.getCallerPrincipal().getName().toString());
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS,org.imixs.ACCESSLEVEL.MANAGERACCESS," + this.accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            try {
                String testRole = roleListTokens.nextToken().trim();
                if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
                userNameList.add(testRole);
            }
            catch (Exception testRole) {}
        }
        String[] applicationGroups = this.getUserGroupList();
        if (applicationGroups != null) {
            for (String auserRole : applicationGroups) {
                userNameList.add(auserRole);
            }
        }
        return userNameList;
    }

    public boolean isUserContained(List<String> nameList) {
        if (nameList == null) {
            return false;
        }
        List<String> userNameList = this.getUserNameList();
        for (String aName : nameList) {
            if (aName == null || aName.isEmpty()) continue;
            if (!userNameList.stream().anyMatch(aName::equals)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserInRole(String rolename) {
        try {
            return this.ctx.isCallerInRole(rolename);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemCollection save(ItemCollection document) throws AccessDeniedException {
        Calendar cal;
        logger.finest("save - ID=" + document.getUniqueID() + " provided version=" + document.getItemValueInteger("$version"));
        Document persistedDocument = null;
        this.manager.setFlushMode(FlushModeType.COMMIT);
        String sID = document.getItemValueString(UNIQUEID);
        if (!sID.isEmpty() && (persistedDocument = (Document)this.manager.find(Document.class, (Object)sID)) == null) {
            logger.fine("Document '" + sID + "' not found!");
        }
        if (persistedDocument == null) {
            if (!(this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS))) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "You are not allowed to perform this operation");
            }
            persistedDocument = new Document(sID);
            Date datCreated = document.getItemValueDate("$created");
            if (datCreated != null) {
                cal = Calendar.getInstance();
                cal.setTime(datCreated);
                persistedDocument.setCreated(cal);
            }
            logger.finest("persist activeEntity");
            this.manager.persist((Object)persistedDocument);
        } else {
            if (!this.isCallerAuthor(persistedDocument) || !this.isCallerReader(persistedDocument)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "You are not allowed to perform this operation");
            }
            if (ItemCollection.createByReference(persistedDocument.getData()).getItemValueBoolean(IMMUTABLE)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "Operation not allowed, document is immutable!");
            }
        }
        logger.finest("save - ID=" + document.getUniqueID() + " managed version=" + persistedDocument.getVersion());
        document.removeItem("$isauthor");
        String aType = document.getItemValueString("type");
        if ("".equals(aType)) {
            aType = "document";
            document.replaceItemValue("type", (Object)aType);
        }
        persistedDocument.setType(aType);
        cal = Calendar.getInstance();
        document.replaceItemValue(UNIQUEID, (Object)persistedDocument.getId());
        document.replaceItemValue("$modified", (Object)cal.getTime());
        document.replaceItemValue("$created", (Object)persistedDocument.getCreated().getTime());
        this.events.fire((Object)new DocumentEvent(document, 1));
        if (!persistedDocument.getId().equals(document.getUniqueID()) || !persistedDocument.getCreated().getTime().equals(document.getItemValueDate("$created"))) {
            throw new InvalidAccessException("INVALID_ID", "Invalid data after DocumentEvent 'ON_DOCUMENT_SAVE'.");
        }
        if (this.disableOptimisticLocking.booleanValue()) {
            document.removeItem("$Version");
        }
        if (!this.disableOptimisticLocking.booleanValue() && document.hasItem("$Version") && document.getItemValueInteger("$Version") > 0) {
            int version = document.getItemValueInteger("$Version");
            persistedDocument.setVersion(version);
        }
        ItemCollection clone = (ItemCollection)document.clone();
        persistedDocument.setData(clone.getAllItems());
        document.removeItem("$version");
        document.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(persistedDocument));
        if (!document.getItemValueBoolean(NOINDEX)) {
            this.luceneUpdateService.updateDocument(document);
        } else {
            this.luceneUpdateService.removeDocument(document.getUniqueID());
        }
        persistedDocument.setPending(true);
        return document;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection saveByNewTransaction(ItemCollection itemcol) throws AccessDeniedException {
        return this.save(itemcol);
    }

    public ItemCollection load(String id) {
        Document persistedDocument = null;
        persistedDocument = (Document)this.manager.find(Document.class, (Object)id);
        if (persistedDocument != null && this.isCallerReader(persistedDocument)) {
            ItemCollection result = null;
            if (persistedDocument.isPending()) {
                logger.fine("clone manged entity '" + id + "' pending status=" + persistedDocument.isPending());
                result = new ItemCollection(persistedDocument.getData());
            } else {
                result = new ItemCollection();
                result.setAllItems(persistedDocument.getData());
                this.manager.detach((Object)persistedDocument);
            }
            if (this.disableOptimisticLocking.booleanValue()) {
                result.removeItem("$Version");
            } else {
                result.replaceItemValue("$Version", (Object)persistedDocument.getVersion());
            }
            result.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(persistedDocument));
            this.events.fire((Object)new DocumentEvent(result, 2));
            return result;
        }
        return null;
    }

    public void remove(ItemCollection itemcol) throws AccessDeniedException {
        Document persistedDocument = null;
        String sID = itemcol.getItemValueString(UNIQUEID);
        persistedDocument = (Document)this.manager.find(Document.class, (Object)sID);
        if (persistedDocument != null) {
            if (!this.isCallerReader(persistedDocument) || !this.isCallerAuthor(persistedDocument)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "remove - You are not allowed to perform this operation");
            }
        } else {
            throw new AccessDeniedException(INVALID_UNIQUEID, "remove - invalid $uniqueid");
        }
        this.manager.remove((Object)persistedDocument);
        this.luceneUpdateService.removeDocument(itemcol.getUniqueID());
    }

    public int count(String searchTerm) throws QueryException {
        return this.count(searchTerm, 0);
    }

    public int count(String sSearchTerm, int maxResult) throws QueryException {
        return this.luceneSearchService.getTotalHits(sSearchTerm, maxResult, null);
    }

    public int countPages(String searchTerm, int pageSize) throws QueryException {
        double pages = 1.0;
        double count = this.count(searchTerm);
        if (count > 0.0) {
            pages = Math.ceil(count / (double)pageSize);
        }
        return (int)pages;
    }

    public List<ItemCollection> find(String searchTerm, int pageSize, int pageIndex) throws QueryException {
        return this.find(searchTerm, pageSize, pageIndex, null, false);
    }

    public List<ItemCollection> find(String searchTerm, int pageSize, int pageIndex, String sortBy, boolean sortReverse) throws QueryException {
        logger.fine("find - SearchTerm=" + searchTerm + "  , pageSize=" + pageSize + " pageNumber=" + pageIndex + " , sortBy=" + sortBy + " reverse=" + sortReverse);
        Sort sortOrder = null;
        if (sortBy != null && !sortBy.isEmpty()) {
            sortOrder = new Sort(new SortField[]{new SortField(sortBy, SortField.Type.STRING, sortReverse)});
        }
        return this.luceneSearchService.search(searchTerm, pageSize, pageIndex, sortOrder, null);
    }

    public List<ItemCollection> findDocumentsByRef(String uniqueIdRef, int start, int count) {
        String searchTerm = "($uniqueidref:\"" + uniqueIdRef + "\")";
        try {
            return this.find(searchTerm, start, count);
        }
        catch (QueryException e) {
            logger.severe("findDocumentsByRef - invalid query: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getDocumentsByType(String type) {
        if (type == null || type.isEmpty()) {
            throw new InvalidAccessException(INVALID_PARAMETER, "undefined type attribute");
        }
        String query = "SELECT document FROM Document AS document ";
        query = query + " WHERE document.type = '" + type + "'";
        query = query + " ORDER BY document.created DESC";
        return this.getDocumentsByQuery(query);
    }

    public List<ItemCollection> getDocumentsByQuery(String query) {
        return this.getDocumentsByQuery(query, -1);
    }

    public List<ItemCollection> getDocumentsByQuery(String query, int maxResult) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        Query q = this.manager.createQuery(query);
        if (maxResult > 0) {
            q.setMaxResults(maxResult);
        }
        long l = System.currentTimeMillis();
        List documentList = q.getResultList();
        if (documentList == null) {
            logger.fine("getDocumentsByQuery - no ducuments found.");
            return result;
        }
        for (Document doc : documentList) {
            if (!this.isCallerReader(doc)) continue;
            ItemCollection _tmp = null;
            if (doc.isPending()) {
                logger.fine("clone manged entity '" + doc.getId() + "' pending status=" + doc.isPending());
                _tmp = new ItemCollection(doc.getData());
            } else {
                _tmp = new ItemCollection();
                _tmp.setAllItems(doc.getData());
                this.manager.detach((Object)doc);
            }
            if (this.disableOptimisticLocking.booleanValue()) {
                _tmp.removeItem("$Version");
            } else {
                _tmp.replaceItemValue("$Version", (Object)doc.getVersion());
            }
            _tmp.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(doc));
            result.add(_tmp);
        }
        logger.fine("getDocumentsByQuery - found " + documentList.size() + " documents in " + (System.currentTimeMillis() - l) + " ms");
        return result;
    }

    public void backup(String query, String filePath) throws IOException, QueryException {
        boolean hasMoreData = true;
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        int startpos = 0;
        int icount = 0;
        logger.info("backup - starting...");
        logger.info("backup - query=" + query);
        logger.info("backup - target=" + filePath);
        if (filePath == null || filePath.isEmpty()) {
            logger.severe("Invalid FilePath!");
            return;
        }
        FileOutputStream fos = new FileOutputStream(filePath);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        while (hasMoreData) {
            List<ItemCollection> col = this.find(query, JUNK_SIZE, startpos);
            if (col.size() < JUNK_SIZE) {
                hasMoreData = false;
            }
            startpos += col.size();
            totalcount += (long)col.size();
            for (ItemCollection aworkitem : col) {
                Map hmap = aworkitem.getAllItems();
                out.writeObject(hmap);
                ++icount;
            }
            logger.fine(totalcount + " documents backuped....");
        }
        out.close();
        logger.info("Backup finished - " + icount + " documents read totaly.");
    }

    public void restore(String filePath) throws IOException {
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        long errorCount = 0L;
        int icount = 0;
        FileInputStream fis = new FileInputStream(filePath);
        ObjectInputStream in = new ObjectInputStream(fis);
        while (true) {
            try {
                while (true) {
                    Map hmap = (Map)in.readObject();
                    ItemCollection itemCol = new ItemCollection(hmap);
                    itemCol.removeItem("$Version");
                    this.save(itemCol);
                    ++totalcount;
                    if (++icount < JUNK_SIZE) continue;
                    icount = 0;
                    logger.info("[EntityService] Restored " + totalcount + " entities....");
                }
            }
            catch (EOFException eofe) {
            }
            catch (ClassNotFoundException e) {
                logger.warning("[EntityService] error importing workitem at position " + (totalcount + ++errorCount) + " Error: " + e.getMessage());
                continue;
            }
            catch (AccessDeniedException e) {
                logger.warning("[EntityService] error importing workitem at position " + (totalcount + ++errorCount) + " Error: " + e.getMessage());
                continue;
            }
            break;
        }
        in.close();
        String loginfo = "Import successfull! " + totalcount + " Entities imported. " + errorCount + " Errors.  Import FileName:" + filePath;
        logger.info(loginfo);
    }

    private boolean isCallerReader(Document document) {
        ItemCollection itemcol = ItemCollection.createByReference(document.getData());
        List readAccessList = itemcol.getItemValue(READACCESS);
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            return true;
        }
        return this.isEmptyList(readAccessList) || this.isUserContained(readAccessList);
    }

    private boolean isCallerAuthor(Document document) {
        ItemCollection itemcol = ItemCollection.createByReference(document.getData());
        List writeAccessList = itemcol.getItemValue(WRITEACCESS);
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS)) {
            return true;
        }
        return this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS) && this.isUserContained(writeAccessList);
    }

    private boolean isEmptyList(List<String> aList) {
        if (aList == null || aList.size() == 0) {
            return true;
        }
        for (String aEntry : aList) {
            if (aEntry == null || aEntry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String[] getUserGroupList() {
        String[] applicationUserGroupList = (String[])this.ctx.getContextData().get(USER_GROUP_LIST);
        if (applicationUserGroupList != null) {
            for (int i = 0; i < applicationUserGroupList.length; ++i) {
                applicationUserGroupList[i] = applicationUserGroupList[i].trim();
            }
        }
        return applicationUserGroupList;
    }
}

