/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.ResultPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

public class SplitAndJoinPlugin
extends AbstractPlugin {
    public static final String LINK_PROPERTY = "txtworkitemref";
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    public static final String SUBPROCESS_CREATE = "subprocess_create";
    public static final String SUBPROCESS_UPDATE = "subprocess_update";
    public static final String ORIGIN_UPDATE = "origin_update";
    private static Logger logger = Logger.getLogger(SplitAndJoinPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException, AccessDeniedException, ProcessingErrorException {
        ItemCollection evalItemCollection = ResultPlugin.evaluateWorkflowResult(adocumentActivity, adocumentContext, false);
        if (evalItemCollection == null) {
            return adocumentContext;
        }
        try {
            List processValueList;
            if (evalItemCollection.hasItem(SUBPROCESS_CREATE)) {
                logger.fine("processing subprocess_create");
                processValueList = evalItemCollection.getItemValue(SUBPROCESS_CREATE);
                this.createSubprocesses(processValueList, adocumentContext);
            }
            if (evalItemCollection.hasItem(SUBPROCESS_UPDATE)) {
                logger.fine("processing subprocess_update");
                processValueList = evalItemCollection.getItemValue(SUBPROCESS_UPDATE);
                this.updateSubprocesses(processValueList, adocumentContext);
            }
            if (evalItemCollection.hasItem(ORIGIN_UPDATE)) {
                logger.fine("processing origin_update");
                String processValue = evalItemCollection.getItemValueString(ORIGIN_UPDATE);
                this.updateOrigin(processValue, adocumentContext);
            }
        }
        catch (ModelException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        return adocumentContext;
    }

    private void createSubprocesses(List<String> subProcessDefinitions, ItemCollection originWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            String workflowResult;
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = ResultPlugin.parseItemStructure(processValue)) == null) continue;
            ItemCollection workitemSubProcess = new ItemCollection();
            this.copyItemList(processData.getItemValueString("items"), originWorkitem, workitemSubProcess);
            workitemSubProcess.replaceItemValue("$modelversion", (Object)processData.getItemValueString("modelversion"));
            workitemSubProcess.replaceItemValue("$processid", (Object)Integer.valueOf(processData.getItemValueString("processid")));
            workitemSubProcess.replaceItemValue("$activityid", (Object)Integer.valueOf(processData.getItemValueString("activityid")));
            workitemSubProcess.replaceItemValue("$uniqueidref", (Object)originWorkitem.getUniqueID());
            workitemSubProcess = this.getWorkflowService().processWorkItem(workitemSubProcess);
            logger.fine("[SplitAndJoinPlugin] successful created new subprocess.");
            this.addWorkitemRef(workitemSubProcess.getUniqueID(), originWorkitem);
            if (!processData.hasItem("action") || (workflowResult = processData.getItemValueString("action")).isEmpty()) continue;
            workflowResult = new ResultPlugin().replaceDynamicValues(workflowResult, workitemSubProcess);
            originWorkitem.replaceItemValue("action", (Object)workflowResult);
        }
    }

    private void updateSubprocesses(List<String> subProcessDefinitions, ItemCollection originWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = ResultPlugin.parseItemStructure(processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String process_pattern = processData.getItemValueString("processid");
            List<ItemCollection> subprocessList = this.getWorkflowService().getWorkListByRef(originWorkitem.getUniqueID());
            for (ItemCollection workitemSubProcess : subprocessList) {
                String workflowResult;
                String subModelVersion = workitemSubProcess.getModelVersion();
                String subProcessID = "" + workitemSubProcess.getProcessID();
                if (Pattern.compile(model_pattern).matcher(subModelVersion).find() && Pattern.compile(process_pattern).matcher(subProcessID).find()) {
                    logger.fine("[SplitAndJoinPlugin] subprocess matches criteria.");
                    this.copyItemList(processData.getItemValueString("items"), originWorkitem, workitemSubProcess);
                    workitemSubProcess.replaceItemValue("$activityid", (Object)Integer.valueOf(processData.getItemValueString("activityid")));
                    workitemSubProcess = this.getWorkflowService().processWorkItem(workitemSubProcess);
                    if (processData.hasItem("action") && !(workflowResult = processData.getItemValueString("action")).isEmpty()) {
                        workflowResult = new ResultPlugin().replaceDynamicValues(workflowResult, workitemSubProcess);
                        originWorkitem.replaceItemValue("action", (Object)workflowResult);
                    }
                    logger.fine("[SplitAndJoinPlugin] successful updated subprocess.");
                }
                if (!processData.hasItem("action") || (workflowResult = processData.getItemValueString("action")).isEmpty()) continue;
                workflowResult = new ResultPlugin().replaceDynamicValues(workflowResult, workitemSubProcess);
                originWorkitem.replaceItemValue("action", (Object)workflowResult);
            }
        }
    }

    private void updateOrigin(String originProcessDefinition, ItemCollection subprocessWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection originWorkitem = null;
        if (originProcessDefinition == null || originProcessDefinition.isEmpty()) {
            return;
        }
        ItemCollection processData = ResultPlugin.parseItemStructure(originProcessDefinition);
        String model_pattern = processData.getItemValueString("modelversion");
        String process_pattern = processData.getItemValueString("processid");
        List refs = subprocessWorkitem.getItemValue("$uniqueidref");
        for (String ref : refs) {
            String workflowResult;
            originWorkitem = this.getWorkflowService().getWorkItem(ref);
            if (originWorkitem == null) continue;
            String subModelVersion = originWorkitem.getModelVersion();
            String subProcessID = "" + originWorkitem.getProcessID();
            if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(process_pattern).matcher(subProcessID).find()) continue;
            logger.fine("[SplitAndJoinPlugin] origin matches criteria.");
            originWorkitem.replaceItemValue("$activityid", (Object)Integer.valueOf(processData.getItemValueString("activityid")));
            this.copyItemList(processData.getItemValueString("items"), subprocessWorkitem, originWorkitem);
            originWorkitem = this.getWorkflowService().processWorkItem(originWorkitem);
            if (processData.hasItem("action") && !(workflowResult = processData.getItemValueString("action")).isEmpty()) {
                workflowResult = new ResultPlugin().replaceDynamicValues(workflowResult, originWorkitem);
                subprocessWorkitem.replaceItemValue("action", (Object)workflowResult);
            }
            logger.fine("[SplitAndJoinPlugin] successful processed originprocess.");
        }
    }

    private void copyItemList(String items, ItemCollection source, ItemCollection target) {
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            int pos = field.indexOf(124);
            if (pos > -1) {
                target.replaceItemValue(field.substring(pos + 1).trim(), (Object)source.getItemValue(field.substring(0, pos).trim()));
                continue;
            }
            target.replaceItemValue(field, (Object)source.getItemValue(field));
        }
    }

    private void addWorkitemRef(String aUniqueID, ItemCollection workitem) {
        logger.fine("LinkController add workitem reference: " + aUniqueID);
        List refList = workitem.getItemValue(LINK_PROPERTY);
        if (refList.size() == 1 && "".equals(refList.get(0))) {
            refList.remove(0);
        }
        if (refList.indexOf(aUniqueID) == -1) {
            refList.add(aUniqueID);
            workitem.replaceItemValue(LINK_PROPERTY, (Object)refList);
        }
    }
}

