/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.RulePlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResultPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    private static Logger logger = Logger.getLogger(ResultPlugin.class.getName());

    public ItemCollection run(ItemCollection documentContext, ItemCollection adocumentActivity) throws PluginException {
        ItemCollection evalItemCollection = ResultPlugin.evaluateWorkflowResult(adocumentActivity, documentContext, true);
        if (evalItemCollection != null) {
            documentContext.replaceAllItems(evalItemCollection.getAllItems());
        }
        return documentContext;
    }

    public static ItemCollection parseItemStructure(String xmlContent) throws PluginException {
        logger.fine("parseItemStructure...");
        ItemCollection result = new ItemCollection();
        if (xmlContent.length() > 0) {
            xmlContent = "<item>" + xmlContent.trim() + "</item>";
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(new InputSource(new StringReader(xmlContent)));
                Node node = doc.importNode(doc.getDocumentElement(), true);
                DocumentFragment docfrag = doc.createDocumentFragment();
                while (node.hasChildNodes()) {
                    docfrag.appendChild(node.removeChild(node.getFirstChild()));
                }
                NodeList childs = docfrag.getChildNodes();
                int itemCount = childs.getLength();
                for (int i = 0; i < itemCount; ++i) {
                    Node childNode = childs.item(i);
                    if (!(childNode instanceof Element) || childNode.getFirstChild() == null) continue;
                    String name = childNode.getNodeName();
                    String value = ResultPlugin.innerXml(childNode);
                    result.replaceItemValue(name, (Object)value);
                    logger.fine("[ResultPlugin] parsing item '" + name + "' value=" + value);
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
                throw new PluginException(RulePlugin.class.getName(), INVALID_FORMAT, "Parsing item content failed: " + e.getMessage());
            }
        }
        return result;
    }

    public static ItemCollection evaluateWorkflowResult(ItemCollection activityEntity, ItemCollection documentContext, boolean resolveItemValues) throws PluginException {
        boolean invalidPattern = true;
        ItemCollection result = new ItemCollection();
        String workflowResult = activityEntity.getItemValueString("txtActivityResult");
        if (workflowResult.isEmpty()) {
            return null;
        }
        if (resolveItemValues) {
            workflowResult = new ResultPlugin().replaceDynamicValues(workflowResult, documentContext);
        }
        Pattern pattern = Pattern.compile("<item(.*?)>(.*?)</item>|<item(.*?)./>", 32);
        Matcher matcher = pattern.matcher(workflowResult);
        while (matcher.find()) {
            invalidPattern = false;
            String attributes = matcher.group(1);
            String content = matcher.group(2);
            if (attributes == null || content == null) {
                attributes = matcher.group(3);
            }
            if (content == null) {
                content = "";
            }
            if (attributes != null && !attributes.isEmpty()) {
                String spattern = "(\\S+)=[\"']?((?:.(?![\"']?\\s+(?:\\S+)=|[>\"']))+.)[\"']?";
                Pattern attributePattern = Pattern.compile(spattern);
                Matcher attributeMatcher = attributePattern.matcher(attributes);
                HashMap<String, String> attrMap = new HashMap<String, String>();
                while (attributeMatcher.find()) {
                    String attrName = attributeMatcher.group(1);
                    String attrValue = attributeMatcher.group(2);
                    attrMap.put(attrName, attrValue);
                }
                String itemName = (String)attrMap.get("name");
                if (itemName == null) {
                    throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "<item> tag contains no name attribute.");
                }
                if (itemName.startsWith("$")) {
                    throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "<item> tag contains invalid name attribute '" + itemName + "'.");
                }
                for (String attrName : attrMap.keySet()) {
                    if ("name".equals(attrName)) continue;
                    result.appendItemValue(itemName + "." + attrName, attrMap.get(attrName));
                }
                String sType = result.getItemValueString(itemName + ".type");
                if (!sType.isEmpty()) {
                    if ("boolean".equalsIgnoreCase(sType)) {
                        result.appendItemValue(itemName, (Object)Boolean.valueOf(content));
                        continue;
                    }
                    if ("integer".equalsIgnoreCase(sType)) {
                        result.appendItemValue(itemName, (Object)Integer.valueOf(content));
                        continue;
                    }
                    if ("double".equalsIgnoreCase(sType)) {
                        result.appendItemValue(itemName, (Object)Double.valueOf(content));
                        continue;
                    }
                    result.appendItemValue(itemName, (Object)content);
                    continue;
                }
                result.appendItemValue(itemName, (Object)content);
                continue;
            }
            throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "<item> tag contains no name attribute.");
        }
        if (invalidPattern) {
            throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "invalid <item> tag format - expected <item name=\"...\" ...></item>  -> workflowResult=" + workflowResult);
        }
        return result;
    }

    public static ItemCollection evaluateWorkflowResult(ItemCollection activityEntity, ItemCollection documentContext) throws PluginException {
        return ResultPlugin.evaluateWorkflowResult(activityEntity, documentContext, true);
    }

    private static String innerXml(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter writer = new StringWriter();
        String xml = null;
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        xml = writer.toString();
        xml = xml.substring(xml.indexOf(">") + 1, xml.lastIndexOf("</"));
        return xml;
    }
}

