/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.xml.DocumentCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;
import org.imixs.workflow.xml.XSLHandler;

public class ReportPlugin
extends AbstractPlugin {
    public static final String INVALID_CONTEXT = "INVALID_CONTEXT";
    public static final String REPORT_UNDEFINED = "REPORT_UNDEFINED";
    public static final String INVALID_REPORT_DEFINITION = "INVALID_REPORT_DEFINITION";
    private static Logger logger = Logger.getLogger(ReportPlugin.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        String encoding;
        String reportName = adocumentActivity.getItemValueString("txtReportName");
        String reportFilePath = adocumentActivity.getItemValueString("txtReportFilePath");
        if ("".equals(reportFilePath)) {
            reportFilePath = reportName;
        }
        reportFilePath = this.replaceDynamicValues(reportFilePath, adocumentContext);
        String reportTarget = adocumentActivity.getItemValueString("txtReportTarget");
        if ("".equals(reportName)) {
            return adocumentContext;
        }
        ItemCollection itemCol = this.getWorkflowService().getReportService().getReport(reportName);
        if (itemCol == null) {
            throw new PluginException(ReportPlugin.class.getSimpleName(), REPORT_UNDEFINED, "Report '" + reportName + " is undefined", new Object[]{reportName});
        }
        String xslTemplate = itemCol.getItemValueString("xsl").trim();
        if ("".equals(xslTemplate)) {
            return adocumentContext;
        }
        String sContentType = itemCol.getItemValueString("contenttype");
        if ("".equals(sContentType)) {
            sContentType = "text/html";
        }
        if ("".equals(encoding = itemCol.getItemValueString("encoding"))) {
            encoding = "UTF-8";
        }
        try {
            XMLItemCollection xml = XMLItemCollectionAdapter.putItemCollection((ItemCollection)adocumentContext);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DocumentCollection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal((Object)xml, (Writer)writer);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                if ("application/pdf".equals(sContentType.toLowerCase())) {
                    logger.warning("FOP Transformation is not yet implementd");
                } else {
                    XSLHandler.transform((String)writer.toString(), (String)xslTemplate, (String)encoding, (OutputStream)outputStream);
                }
            }
            if (reportTarget.isEmpty() || "0".equals(reportTarget)) {
                adocumentContext.addFile(outputStream.toByteArray(), reportFilePath, sContentType);
            }
            if ("1".equals(reportTarget)) {
                logger.warning("Writing into BlobWorkitem is no longer supported - please use the DMSPlugin for transfer");
            }
            if ("2".equals(reportTarget)) {
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(reportFilePath);
                    fos.write(outputStream.toByteArray());
                    fos.flush();
                }
            }
            return adocumentContext;
        }
        catch (Exception e) {
            throw new PluginException(ReportPlugin.class.getSimpleName(), INVALID_REPORT_DEFINITION, "Unable to process report '" + reportName + "' ", new Object[]{reportName});
        }
    }

    private String unescapeXMLContent(String aContent, List<String> vAttributList, Collection<ItemCollection> col) {
        int entityPos = aContent.indexOf("<document>");
        for (ItemCollection entity : col) {
            for (String fieldname : vAttributList) {
                int end;
                int start;
                int iPos;
                if (!fieldname.toLowerCase().startsWith("html") && !fieldname.toLowerCase().startsWith("xml")) continue;
                String tag = "<name>" + fieldname + "</name>";
                String sOriginValue = entity.getItemValueString(fieldname);
                if (sOriginValue.isEmpty() || (iPos = aContent.indexOf(tag, entityPos)) <= -1 || (start = aContent.indexOf(62, iPos + tag.length())) <= -1 || (end = aContent.indexOf("</value>", start)) <= -1) continue;
                aContent = aContent.substring(0, start + 1) + sOriginValue + aContent.substring(end);
            }
            entityPos = aContent.indexOf("<document>", entityPos + 1);
        }
        return aContent;
    }

    public void close(int status) throws PluginException {
    }

    private String computeEQLParams(String aQuery, String sParamString) {
        if (sParamString.startsWith("?") || sParamString.startsWith("&")) {
            sParamString = sParamString.substring(1);
        }
        StringTokenizer tokenizer = new StringTokenizer(sParamString, "&");
        while (tokenizer.hasMoreTokens()) {
            String aToken = tokenizer.nextToken();
            if (aToken.indexOf(61) == -1) continue;
            String sKeyName = aToken.substring(0, aToken.indexOf(61));
            String sParamValue = aToken.substring(aToken.indexOf(61) + 1);
            if (aQuery.indexOf("?" + sKeyName) <= -1) continue;
            aQuery = aQuery.replace("?" + sKeyName, sParamValue);
        }
        return aQuery;
    }
}

