/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class HistoryPlugin
extends AbstractPlugin {
    private ItemCollection documentContext;
    private ItemCollection documentActivity;
    private List<List<Object>> historyList = null;
    private static Logger logger = Logger.getLogger(HistoryPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        String rtfItemLog;
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        if (this.documentContext.hasItem("txtworkflowhistorylogrev")) {
            this.convertOldFormat();
            this.documentContext.removeItem("txtworkflowhistorylogrev");
        }
        if ((rtfItemLog = this.documentActivity.getItemValueString("rtfresultlog")).isEmpty()) {
            return this.documentContext;
        }
        rtfItemLog = this.replaceDynamicValues(rtfItemLog, this.documentContext);
        List temp = this.documentContext.getItemValue("txtworkflowhistory");
        this.historyList = new Vector<List<Object>>();
        for (Object o : temp) {
            if (!(o instanceof List)) continue;
            this.historyList.add((List)o);
        }
        ArrayList<Object> newEntry = new ArrayList<Object>();
        newEntry.add(new Date());
        newEntry.add(rtfItemLog);
        newEntry.add(this.getWorkflowService().getUserName());
        this.historyList.add(newEntry);
        int iMaxLogLength = this.documentContext.getItemValueInteger("numworkflowhistoryLength");
        if (iMaxLogLength > 0) {
            while (this.historyList.size() > iMaxLogLength) {
                this.historyList.remove(0);
            }
        }
        this.documentContext.replaceItemValue("txtworkflowhistory", this.historyList);
        return this.documentContext;
    }

    protected void convertOldFormat() {
        ArrayList newList = new ArrayList();
        try {
            List oldList = this.documentContext.getItemValue("txtworkflowhistorylog");
            for (String oldEntry : oldList) {
                if (oldEntry == null || oldEntry.isEmpty() || oldEntry.indexOf(" : ") <= -1) continue;
                String sDate = oldEntry.substring(0, oldEntry.indexOf(" : "));
                String sComment = oldEntry.substring(oldEntry.indexOf(" : ") + 3);
                String sUser = "";
                ArrayList<Object> newEntry = new ArrayList<Object>();
                newEntry.add(this.convertDate(sDate));
                newEntry.add(sComment);
                newEntry.add(sUser);
                newList.add(newEntry);
            }
        }
        catch (ClassCastException cce) {
            logger.warning("[HistoryPlugin] can not convert txtworkflowhistorylog into new format!");
            logger.warning(cce.getMessage());
        }
        this.documentContext.replaceItemValue("txtworkflowhistory", newList);
    }

    private Date convertDate(String aDateString) {
        DateFormat df = null;
        try {
            df = DateFormat.getDateTimeInstance(1, 1, new Locale("de", "DE"));
            Date result = df.parse(aDateString);
            return result;
        }
        catch (ParseException parseException) {
            try {
                df = DateFormat.getDateTimeInstance(2, 2, new Locale("de", "DE"));
                Date result = df.parse(aDateString);
                return result;
            }
            catch (ParseException parseException2) {
                try {
                    df = DateFormat.getDateTimeInstance(3, 3, new Locale("de", "DE"));
                    Date result = df.parse(aDateString);
                    return result;
                }
                catch (ParseException parseException3) {
                    try {
                        df = DateFormat.getDateTimeInstance(1, 2, new Locale("de", "DE"));
                        Date result = df.parse(aDateString);
                        return result;
                    }
                    catch (ParseException parseException4) {
                        try {
                            df = DateFormat.getDateTimeInstance(2, 3, new Locale("de", "DE"));
                            Date result = df.parse(aDateString);
                            return result;
                        }
                        catch (ParseException parseException5) {
                            try {
                                df = DateFormat.getDateTimeInstance(3, 2, new Locale("de", "DE"));
                                Date result = df.parse(aDateString);
                                return result;
                            }
                            catch (ParseException parseException6) {
                                try {
                                    df = DateFormat.getDateTimeInstance(2, 1, new Locale("de", "DE"));
                                    Date result = df.parse(aDateString);
                                    return result;
                                }
                                catch (ParseException parseException7) {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

