/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.jpa;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.imixs.workflow.WorkflowKernel;

@Entity
public class Document
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id = WorkflowKernel.generateUniqueID();
    private Integer version;
    private String type;
    private Calendar created;
    private Calendar modified;
    private Map<String, List<Object>> data;
    private boolean pending;

    public Document() {
        Calendar cal;
        this.created = cal = Calendar.getInstance();
    }

    public Document(String aID) {
        this();
        if (aID != null && !"".equals(aID)) {
            this.id = aID;
        }
    }

    @Transient
    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pandingState) {
        this.pending = pandingState;
    }

    @Id
    public String getId() {
        return this.id;
    }

    protected void setId(String aID) {
        this.id = aID;
    }

    @Version
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreated() {
        return this.created;
    }

    public void setCreated(Calendar created) {
        this.created = created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getModified() {
        return this.modified;
    }

    public void setModified(Calendar modified) {
        this.modified = modified;
    }

    @PrePersist
    @PreUpdate
    private void updateModified() {
        Calendar cal;
        this.modified = cal = Calendar.getInstance();
    }

    @Lob
    @Basic(fetch=FetchType.EAGER)
    public Map<String, List<Object>> getData() {
        return this.data;
    }

    public void setData(Map<String, List<Object>> itemCol) {
        this.data = itemCol;
    }
}

