/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.WorkflowManager;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.PropertyService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class WorkflowService
implements WorkflowManager,
WorkflowContext {
    public static final String UNIQUEID = "$uniqueid";
    public static final String UNIQUEIDREF = "$uniqueidref";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String ISAUTHOR = "$isAuthor";
    public static final String WORKITEMID = "$workitemid";
    public static final String PROCESSID = "$processid";
    public static final String MODELVERSION = "$modelversion";
    public static final String ACTIVITYID = "$activityid";
    public static final int SORT_ORDER_CREATED_DESC = 0;
    public static final int SORT_ORDER_CREATED_ASC = 1;
    public static final int SORT_ORDER_MODIFIED_DESC = 2;
    public static final int SORT_ORDER_MODIFIED_ASC = 3;
    @Inject
    @Any
    private Instance<Plugin> plugins;
    @EJB
    DocumentService documentService;
    @EJB
    ModelService modelService;
    @EJB
    ReportService reportService;
    @EJB
    PropertyService propertyService;
    @Resource
    SessionContext ctx;
    private static Logger logger = Logger.getLogger(WorkflowService.class.getName());

    public ItemCollection getWorkItem(String uniqueid) {
        return this.documentService.load(uniqueid);
    }

    public List<ItemCollection> getWorkListByOwner(String name, String type, int pageSize, int pageIndex, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = searchTerm + " namowner:\"" + name + "\" )";
        logger.warning("Sortorder " + sortorder + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByOwner - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByAuthor(String name, String type, int pageSize, int pageIndex, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = searchTerm + " $writeaccess:\"" + name + "\" )";
        logger.warning("Sortorder " + sortorder + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByAuthor - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByCreator(String name, String type, int pageSize, int pageIndex, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = searchTerm + " namcreator:\"" + name + "\" )";
        logger.warning("Sortorder " + sortorder + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByCreator - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByWriteAccess(String type, int pageSize, int pageIndex, int sortorder) {
        StringBuffer nameListBuffer = new StringBuffer();
        String name = this.ctx.getCallerPrincipal().getName();
        nameListBuffer.append("($writeaccess:\"" + name + "\"");
        String accessRoles = this.documentService.getAccessRoles();
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS," + accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            String testRole = roleListTokens.nextToken().trim();
            if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
            nameListBuffer.append(" OR $writeaccess:\"" + testRole + "\"");
        }
        nameListBuffer.append(")");
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND " + nameListBuffer.toString();
        }
        searchTerm = searchTerm + " $writeaccess:\"" + name + "\" )";
        logger.warning("Sortorder " + sortorder + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByWriteAccess - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByGroup(String name, String type, int pageSize, int pageIndex, int sortorder) {
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = searchTerm + " txtworkflowgroup:\"" + name + "\" )";
        logger.warning("Sortorder " + searchTerm + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByGroup - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByProcessID(int aid, String type, int pageSize, int pageIndex, int sortorder) {
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = searchTerm + " $processid:\"" + aid + "\" )";
        logger.warning("Sortorder " + searchTerm + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByProcessID - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByRef(String aref, String type, int pageSize, int pageIndex, int sortorder) {
        String searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = searchTerm + " $uniqueidref:\"" + aref + "\" )";
        logger.warning("Sortorder " + searchTerm + " not implemented!");
        try {
            return this.documentService.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("getWorkListByRef - invalid param: " + e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByRef(String aref) {
        return this.getWorkListByRef(aref, null, -1, 0, 0);
    }

    public List<ItemCollection> getEvents(ItemCollection workitem) throws ModelException {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        int processID = workitem.getProcessID();
        Model model = this.modelService.getModelByWorkitem(workitem);
        List eventList = model.findAllEventsByTask(processID);
        String username = this.getUserName();
        boolean bManagerAccess = this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS");
        for (ItemCollection event : eventList) {
            if ("0".equals(event.getItemValueString("keypublicresult"))) continue;
            List readAccessList = event.getItemValue(READACCESS);
            if (!bManagerAccess && !readAccessList.isEmpty()) {
                boolean accessGranted = false;
                List<String> auserNameList = this.getUserNameList();
                for (String aReadAccess : readAccessList) {
                    if (aReadAccess == null || aReadAccess.isEmpty() || auserNameList.indexOf(aReadAccess) <= -1) continue;
                    accessGranted = true;
                    break;
                }
                if (!accessGranted) continue;
            }
            List restrictedList = event.getItemValue("keyRestrictedVisibility");
            if (!bManagerAccess && !restrictedList.isEmpty()) {
                ArrayList totalNameList = new ArrayList();
                for (String itemName : restrictedList) {
                    totalNameList.addAll(workitem.getItemValue(itemName));
                }
                totalNameList.removeAll(Collections.singleton(null));
                totalNameList.removeAll(Collections.singleton(""));
                if (!totalNameList.isEmpty() && !totalNameList.contains(username)) continue;
            }
            result.add(event);
        }
        return result;
    }

    public ItemCollection processWorkItem(ItemCollection workitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if (workitem == null) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_WORKITEM", "WorkflowService: error - workitem is null");
        }
        ItemCollection currentInstance = this.getWorkItem(workitem.getItemValueString(UNIQUEID));
        if (currentInstance != null) {
            if (!currentInstance.getItemValueBoolean(ISAUTHOR)) {
                throw new AccessDeniedException("OPERATION_NOTALLOWED", "WorkflowService: error - $UnqiueID (" + workitem.getItemValueInteger(UNIQUEID) + ") no Author Access!");
            }
            if (workitem.getItemValueInteger("$ProcessID") > 0 && currentInstance.getItemValueInteger("$ProcessID") != workitem.getItemValueInteger("$ProcessID")) {
                throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_PROCESSID", "WorkflowService: error - $ProcesssID (" + workitem.getItemValueInteger("$ProcessID") + ") did not match expected $ProcesssID (" + currentInstance.getItemValueInteger("$ProcessID") + ")");
            }
            currentInstance.replaceAllItems(workitem.getAllItems());
            workitem = currentInstance;
        }
        Model model = null;
        try {
            model = this.getModelManager().getModelByWorkitem(workitem);
        }
        catch (ModelException e) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_PROCESSID", e.getMessage(), (Exception)((Object)e));
        }
        ItemCollection profile = model.getDefinition();
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        List vPlugins = profile.getItemValue("txtPlugins");
        for (int i = 0; i < vPlugins.size(); ++i) {
            String aPluginClassName = (String)vPlugins.get(i);
            Plugin aPlugin = this.findPluginByName(aPluginClassName);
            if (aPlugin != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("[WorkflowService] register CDI plugin class: " + aPluginClassName + "...");
                }
                workflowkernel.registerPlugin(aPlugin);
                continue;
            }
            workflowkernel.registerPlugin(aPluginClassName);
        }
        String nameEditor = this.ctx.getCallerPrincipal().getName();
        if (workitem.getItemValueString("$creator").isEmpty() && !workitem.getItemValueString("namCreator").isEmpty()) {
            workitem.replaceItemValue("$creator", (Object)workitem.getItemValue("namCreator"));
        }
        if (workitem.getItemValueString("$creator").isEmpty()) {
            workitem.replaceItemValue("$creator", (Object)nameEditor);
            workitem.replaceItemValue("namCreator", (Object)nameEditor);
        }
        if (!nameEditor.equals(workitem.getItemValueString("$editor")) && !workitem.getItemValueString("$editor").isEmpty()) {
            workitem.replaceItemValue("$lasteditor", (Object)workitem.getItemValueString("$editor"));
            workitem.replaceItemValue("namlasteditor", (Object)workitem.getItemValueString("$editor"));
        }
        workitem.replaceItemValue("$editor", (Object)nameEditor);
        workitem.replaceItemValue("namcurrenteditor", (Object)nameEditor);
        workitem = workflowkernel.process(workitem);
        if (logger.isLoggable(Level.FINE)) {
            logger.info("[WorkflowManager] workitem processed sucessfull");
        }
        return this.documentService.save(workitem);
    }

    public void removeWorkItem(ItemCollection aworkitem) throws AccessDeniedException {
        this.documentService.remove(aworkitem);
    }

    public ModelManager getModelManager() {
        return this.modelService;
    }

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public PropertyService getPropertyService() {
        return this.propertyService;
    }

    public String getUserName() {
        return this.ctx.getCallerPrincipal().getName();
    }

    public boolean isUserInRole(String rolename) {
        try {
            return this.ctx.isCallerInRole(rolename);
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getUserNameList() {
        return this.documentService.getUserNameList();
    }

    private Plugin findPluginByName(String pluginClassName) {
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        if (this.plugins == null || !this.plugins.iterator().hasNext()) {
            logger.fine("[WorkflowService] no CDI plugins injected");
            return null;
        }
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(pluginClassName)) continue;
            logger.fine("[WorkflowService] CDI plugin '" + pluginClassName + "' successful injected");
            return plugin;
        }
        return null;
    }
}

