/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee;

import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.jee.AbstractPlugin;

public class MailPlugin
extends AbstractPlugin {
    Session mailSession;
    MimeMessage mailMessage = null;
    Multipart mimeMultipart = null;
    static final String CONTENTTYPE_TEXT_PLAIN = "text/plain";
    static final String CONTENTTYPE_TEXT_HTML = "text/html";
    public static final String INVALID_ADDRESS = "INVALID_ADDRESS";
    String charSet = "ISO-8859-1";
    @Resource(name="IMIXS_MAIL_SESSION")
    private String sMailSession = "org.imixs.workflow.mail";
    private boolean bHTMLMail = false;
    private boolean noMailSessionBound = false;
    private static Logger logger = Logger.getLogger(MailPlugin.class.getName());

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
    }

    @Override
    public int run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        this.mailMessage = null;
        if ("1".equals(documentActivity.getItemValueString("keyMailInactive"))) {
            return 0;
        }
        List<String> vectorRecipients = this.getRecipients(documentContext, documentActivity);
        if (vectorRecipients.isEmpty()) {
            logger.fine("[MailPlugin] No Receipients defined for this Activity...");
            return 0;
        }
        try {
            this.initMailMessage();
            if (this.mailMessage == null) {
                logger.warning("[MailPlugin] mailMessage = null");
                return 1;
            }
            this.mailMessage.setFrom((Address)this.getInternetAddress(this.getFrom(documentContext, documentActivity)));
            this.mailMessage.setRecipients(Message.RecipientType.TO, (Address[])this.getInternetAddressArray(vectorRecipients));
            this.mailMessage.setRecipients(Message.RecipientType.CC, (Address[])this.getInternetAddressArray(this.getRecipientsCC(documentContext, documentActivity)));
            this.mailMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.getInternetAddressArray(this.getRecipientsBCC(documentContext, documentActivity)));
            String sReplyTo = this.getReplyTo(documentContext, documentActivity);
            if (sReplyTo != null && !sReplyTo.isEmpty()) {
                InternetAddress[] resplysAdrs = new InternetAddress[]{this.getInternetAddress(sReplyTo)};
                this.mailMessage.setReplyTo((Address[])resplysAdrs);
            }
            this.mailMessage.setSubject(this.getSubject(documentContext, documentActivity), this.getCharSet());
            String aBodyText = this.getBody(documentContext, documentActivity);
            if (aBodyText == null) {
                aBodyText = "";
            }
            MimeBodyPart messagePart = new MimeBodyPart();
            logger.fine("[MailPlugin] ContentType: '" + this.getContentType() + "'");
            messagePart.setContent((Object)aBodyText, this.getContentType());
            this.mimeMultipart.addBodyPart((BodyPart)messagePart);
        }
        catch (Exception e) {
            logger.warning("[MailPlugin] run - Warning:" + e.toString());
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    @Override
    public void close(int status) throws PluginException {
        if (status == 0 && this.mailSession != null && this.mailMessage != null) {
            try {
                String sTestRecipients;
                if (this.propertyService != null && (sTestRecipients = (String)this.propertyService.getProperties().get("mail.testRecipients")) != null && !"".equals(sTestRecipients)) {
                    Vector<String> vRecipients = new Vector<String>();
                    StringTokenizer st = new StringTokenizer(sTestRecipients, ",", false);
                    while (st.hasMoreElements()) {
                        vRecipients.add(st.nextToken().trim());
                    }
                    logger.info("[MailPlugin] - TestMode - forward to:");
                    for (String adr : vRecipients) {
                        logger.info("[MailPlugin]    " + adr);
                    }
                    try {
                        this.getMailMessage().setRecipients(Message.RecipientType.CC, null);
                        this.getMailMessage().setRecipients(Message.RecipientType.BCC, null);
                        this.getMailMessage().setRecipients(Message.RecipientType.TO, (Address[])this.getInternetAddressArray(vRecipients));
                        String sSubject = this.getMailMessage().getSubject();
                        this.getMailMessage().setSubject("[TEST]: " + sSubject);
                    }
                    catch (MessagingException e) {
                        throw new PluginException(MailPlugin.class.getSimpleName(), INVALID_ADDRESS, "[MailPlugin] unable to set mail recipients: ", (Exception)((Object)e));
                    }
                }
                logger.fine("[MailPlugin] SendMessage now...");
                Transport trans = this.mailSession.getTransport("smtp");
                trans.connect(this.mailSession.getProperty("mail.smtp.user"), this.mailSession.getProperty("mail.smtp.password"));
                this.mailMessage.setContent((Object)this.mimeMultipart, this.getContentType());
                this.mailMessage.saveChanges();
                trans.sendMessage((Message)this.mailMessage, this.mailMessage.getAllRecipients());
                trans.close();
            }
            catch (Exception esend) {
                logger.warning("[MailPlugin] close - Warning:" + esend.toString());
            }
        }
    }

    public String getFrom(ItemCollection documentContext, ItemCollection documentActivity) {
        String sFrom = null;
        if (this.propertyService != null) {
            sFrom = (String)this.propertyService.getProperties().get("mail.defaultSender");
        }
        if (sFrom == null || sFrom.isEmpty()) {
            sFrom = this.getUserName();
        }
        logger.fine("[MailPlugin]  From: " + sFrom);
        return sFrom;
    }

    public String getReplyTo(ItemCollection documentContext, ItemCollection documentActivity) {
        String sReplyTo = null;
        sReplyTo = "1".equals(documentActivity.getItemValueString("keyMailReplyToCurrentUser")) ? this.getUserName() : documentActivity.getItemValueString("namMailReplyToUser");
        logger.fine("[MailPlugin] ReplyTo=" + sReplyTo);
        return sReplyTo;
    }

    public String getSubject(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        String subject = this.replaceDynamicValues(documentActivity.getItemValueString("txtMailSubject"), documentContext);
        logger.fine("[MailPlugin]  Subject: " + subject);
        return subject;
    }

    public List<String> getRecipients(ItemCollection documentContext, ItemCollection documentActivity) {
        Vector<String> vectorRecipients = documentActivity.getItemValue("namMailReceiver");
        if (vectorRecipients == null) {
            vectorRecipients = new Vector<String>();
        }
        this.mergeFieldList(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFields"));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[MailPlugin]  " + vectorRecipients.size() + " Receipients: ");
            for (String rez : vectorRecipients) {
                logger.fine("[MailPlugin]     " + rez);
            }
        }
        return vectorRecipients;
    }

    public List<String> getRecipientsCC(ItemCollection documentContext, ItemCollection documentActivity) {
        Vector<String> vectorRecipients = documentActivity.getItemValue("namMailReceiverCC");
        if (vectorRecipients == null) {
            vectorRecipients = new Vector<String>();
        }
        this.mergeFieldList(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFieldsCC"));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[MailPlugin]  " + vectorRecipients.size() + " ReceipientsCC: ");
            for (String rez : vectorRecipients) {
                logger.fine("[MailPlugin]     " + rez);
            }
        }
        return vectorRecipients;
    }

    public List<String> getRecipientsBCC(ItemCollection documentContext, ItemCollection documentActivity) {
        Vector<String> vectorRecipients = documentActivity.getItemValue("namMailReceiverBCC");
        if (vectorRecipients == null) {
            vectorRecipients = new Vector<String>();
        }
        this.mergeFieldList(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFieldsBCC"));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[MailPlugin]  " + vectorRecipients.size() + " ReceipientsBCC: ");
            for (String rez : vectorRecipients) {
                logger.fine("[MailPlugin]     " + rez);
            }
        }
        return vectorRecipients;
    }

    public String getBody(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        String aBodyText = this.replaceDynamicValues(documentActivity.getItemValueString("rtfMailBody"), documentContext);
        String sTestHTML = aBodyText.trim().toLowerCase();
        this.bHTMLMail = sTestHTML.startsWith("<!doctype") || sTestHTML.startsWith("<html") || sTestHTML.startsWith("<?xml");
        return aBodyText;
    }

    public void initMailMessage() throws AddressException, MessagingException {
        logger.finest("[MailPlugin] initializeMailMessage...");
        this.initMailSession();
        if (this.mailSession != null) {
            if (logger.isLoggable(Level.FINE)) {
                Properties props = this.mailSession.getProperties();
                Enumeration<Object> enumer = props.keys();
                while (enumer.hasMoreElements()) {
                    String aKey = enumer.nextElement().toString();
                    logger.fine("[MailPlugin]  ProperyName= " + aKey);
                    String value = props.getProperty(aKey);
                    if (value == null) {
                        logger.fine("[MailPlugin]  PropertyValue=null");
                        continue;
                    }
                    logger.fine("[MailPlugin]  PropertyValue= " + props.getProperty(aKey).toString());
                }
            }
            this.mailMessage = new MimeMessage(this.mailSession);
            this.mailMessage.setSentDate(new Date());
            this.mailMessage.setFrom();
            this.mimeMultipart = new MimeMultipart();
        }
    }

    public InternetAddress getInternetAddress(String aAddr) throws AddressException {
        InternetAddress inetAddr = null;
        if (aAddr == null) {
            return null;
        }
        try {
            inetAddr = aAddr.indexOf(" ") > -1 ? new InternetAddress("\"" + aAddr + "\"") : new InternetAddress(aAddr);
        }
        catch (AddressException ae) {
            ae.printStackTrace();
            return null;
        }
        return inetAddr;
    }

    private InternetAddress[] getInternetAddressArray(List aList) {
        InternetAddress inetAddr = null;
        if (aList == null) {
            return null;
        }
        Vector<InternetAddress> vReceipsTemp = new Vector<InternetAddress>();
        for (int i = 0; i < aList.size(); ++i) {
            try {
                inetAddr = this.getInternetAddress(aList.get(i).toString());
                if (inetAddr == null || "".equals(inetAddr.getAddress())) continue;
                vReceipsTemp.add(inetAddr);
                continue;
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        InternetAddress[] receipsAdrs = new InternetAddress[vReceipsTemp.size()];
        for (int i = 0; i < vReceipsTemp.size(); ++i) {
            receipsAdrs[i] = (InternetAddress)vReceipsTemp.elementAt(i);
        }
        return receipsAdrs;
    }

    public void initMailSession() {
        String sTestCharSet;
        if (this.mailSession != null || this.noMailSessionBound) {
            return;
        }
        String sJNDINName = "";
        try {
            InitialContext ic = new InitialContext();
            sJNDINName = !this.sMailSession.startsWith("java:") ? "java:comp/env/mail/" + this.sMailSession : this.sMailSession;
            logger.finest("[MailPlugin] Lookup MailSession '" + sJNDINName + "' ...");
            this.mailSession = (Session)ic.lookup(sJNDINName);
            logger.finest("[MailPlugin] Lookup MailSession '" + sJNDINName + "' successful");
        }
        catch (NamingException e) {
            logger.warning("[MailPlugin] Lookup MailSession '" + sJNDINName + "' FAILED!");
            logger.warning("[MailPlugin] Unable to send mails! Verify server resources -> mail session.");
            logger.warning("[MailPlugin] ErrorMessage: " + e.getMessage());
            this.noMailSessionBound = true;
        }
        if (this.propertyService != null && (sTestCharSet = (String)this.propertyService.getProperties().get("mail.charSet")) != null && !sTestCharSet.isEmpty()) {
            this.setCharSet(sTestCharSet);
        }
    }

    public Session getMailSession() {
        if (this.mailSession == null && !this.noMailSessionBound) {
            this.initMailSession();
        }
        return this.mailSession;
    }

    public Message getMailMessage() {
        return this.mailMessage;
    }

    public Multipart getMultipart() {
        return this.mimeMultipart;
    }

    public boolean isHTMLMail() {
        return this.bHTMLMail;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getContentType() {
        String sContentType = "";
        sContentType = this.bHTMLMail ? CONTENTTYPE_TEXT_HTML : CONTENTTYPE_TEXT_PLAIN;
        if (this.getCharSet() != null && !this.getCharSet().isEmpty()) {
            sContentType = sContentType + "; charset=" + this.getCharSet();
        }
        return sContentType;
    }
}

