/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee;

import java.util.logging.Logger;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.jee.util.PropertyService;

public abstract class AbstractPlugin
extends org.imixs.workflow.plugins.AbstractPlugin {
    SessionContext ejbSessionContext;
    public static final String INVALID_PROPERTYVALUE_FORMAT = "INVALID_PROPERTYVALUE_FORMAT";
    PropertyService propertyService = null;
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        this.ejbSessionContext = (SessionContext)this.ctx.getSessionContext();
        String jndiName = "ejb/PropertyService";
        try {
            InitialContext ictx = new InitialContext();
            Context ctx = (Context)ictx.lookup("java:comp/env");
            this.propertyService = (PropertyService)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            logger.fine("[AbstractPlugin] PropertyService not bound!");
            this.propertyService = null;
        }
    }

    public abstract int run(ItemCollection var1, ItemCollection var2) throws PluginException;

    public abstract void close(int var1) throws PluginException;

    public PropertyService getPropertyService() {
        return this.propertyService;
    }

    public void setPropertyService(PropertyService propertyService) {
        this.propertyService = propertyService;
    }

    public String getUserName() {
        return this.ejbSessionContext.getCallerPrincipal().getName();
    }

    public SessionContext getEjbSessionContext() {
        return this.ejbSessionContext;
    }

    public void setEjbSessionContext(SessionContext ejbSessionContext) {
        this.ejbSessionContext = ejbSessionContext;
    }

    @Override
    public String replaceDynamicValues(String aString, ItemCollection documentContext) throws PluginException {
        if (aString == null) {
            return "";
        }
        if (aString.toLowerCase().contains("<propertyvalue") && this.propertyService != null) {
            int iTagStartPos;
            while ((iTagStartPos = aString.toLowerCase().indexOf("<propertyvalue")) != -1) {
                int iTagEndPos = aString.toLowerCase().indexOf("</propertyvalue>", iTagStartPos);
                if (iTagEndPos == -1) {
                    throw new PluginException(this.getClass().getSimpleName(), INVALID_PROPERTYVALUE_FORMAT, "[AbstractPlugin] invalid propertyvalue format: " + aString);
                }
                int iContentStartPos = 0;
                int iContentEndPos = 0;
                String sPropertyKey = "";
                iContentEndPos = iTagEndPos;
                String sTestString = aString.substring(0, iContentEndPos);
                iContentStartPos = sTestString.lastIndexOf(62) + 1;
                if (iContentStartPos >= iContentEndPos) {
                    logger.warning("[AbstractPlugin] invalid text string format: " + aString);
                    break;
                }
                iTagEndPos += "</propertyvalue>".length();
                sPropertyKey = aString.substring(iContentStartPos, iContentEndPos);
                String vValue = this.propertyService.getProperties().getProperty(sPropertyKey);
                if (vValue == null) {
                    logger.warning("[AbstractPlugin] propertyvalue '" + sPropertyKey + "' is not defined in imixs.properties!");
                    vValue = "";
                }
                aString = aString.substring(0, iTagStartPos) + vValue + aString.substring(iTagEndPos);
            }
        }
        return super.replaceDynamicValues(aString, documentContext);
    }
}

