/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class RulePlugin
extends AbstractPlugin {
    public static final String INVALID_SCRIPT = "INVALID_SCRIPT";
    public static final String VALIDATION_ERROR = "VALIDATION_ERROR";
    private static Logger logger = Logger.getLogger(RulePlugin.class.getName());
    private static final HashSet<Class<?>> BASIC_OBJECT_TYPES = RulePlugin.getBasicObjectTypes();

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
    }

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        ScriptEngine engine = this.evaluateBusinessRule(adocumentContext, adocumentActivity);
        if (engine != null) {
            Long nextTask;
            Double d;
            Long followUpActivity;
            Boolean isValidActivity = (Boolean)engine.get("isValid");
            if (isValidActivity != null && !isValidActivity.booleanValue()) {
                String sErrorCode = VALIDATION_ERROR;
                Object oErrorCode = engine.get("errorCode");
                if (oErrorCode != null && oErrorCode instanceof String) {
                    sErrorCode = oErrorCode.toString();
                }
                Object[] params = null;
                params = this.evaluateScriptObject(engine, "errorMessage");
                throw new PluginException(RulePlugin.class.getName(), sErrorCode, "BusinessRule: validation failed - ErrorCode=" + sErrorCode, params);
            }
            this.updateActivityEntity(engine, adocumentActivity);
            Object o = engine.get("followUp");
            if (o != null && (followUpActivity = Long.valueOf((d = Double.valueOf(o.toString())).longValue())) != null && followUpActivity > 0L) {
                adocumentActivity.replaceItemValue("keyFollowUp", (Object)"1");
                adocumentActivity.replaceItemValue("numNextActivityID", (Object)followUpActivity);
            }
            if ((o = engine.get("nextTask")) != null && (nextTask = Long.valueOf((d = Double.valueOf(o.toString())).longValue())) != null && nextTask > 0L) {
                adocumentActivity.replaceItemValue("numNextProcessID", (Object)nextTask);
            }
            return 0;
        }
        return 0;
    }

    public void close(int status) {
    }

    public boolean isValid(ItemCollection documentContext, ItemCollection activity) throws PluginException {
        Boolean isValidActivity;
        ScriptEngine engine = this.evaluateBusinessRule(documentContext, activity);
        if (engine != null && (isValidActivity = (Boolean)engine.get("isValid")) != null) {
            return isValidActivity;
        }
        return true;
    }

    public ScriptEngine evaluateBusinessRule(ItemCollection documentContext, ItemCollection activity) throws PluginException {
        String script = activity.getItemValueString("txtBusinessRule");
        if ("".equals(script.trim())) {
            return null;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        String sEngineType = activity.getItemValueString("txtBusinessRuleEngine");
        if ("".equals(sEngineType)) {
            sEngineType = "javascript";
        }
        ScriptEngine engine = manager.getEngineByName(sEngineType);
        engine.put("activity", this.convertItemCollection(activity));
        engine.put("workitem", this.convertItemCollection(documentContext));
        Map itemList = documentContext.getAllItems();
        for (Map.Entry entry : itemList.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            List value = (List)entry.getValue();
            if (key.startsWith("$") || value.size() <= 0 || !RulePlugin.isBasicObjectType(value.get(0).getClass())) continue;
            engine.put(key, value.toArray());
        }
        logger.fine("SCRIPT:" + script);
        try {
            engine.eval(script);
        }
        catch (ScriptException e) {
            throw new PluginException(RulePlugin.class.getSimpleName(), INVALID_SCRIPT, "BusinessRule contains invalid script:" + e.getMessage(), (Exception)e);
        }
        return engine;
    }

    public Object[] evaluateScriptObject(ScriptEngine engine, String expression) {
        Object[] params = null;
        if (engine == null) {
            logger.severe("RulePlugin evaluateScritpObject error: no script engine! - call run()");
            return null;
        }
        Object objectResult = engine.get(expression);
        if (objectResult != null && objectResult instanceof String) {
            params = new String[]{objectResult.toString()};
            return params;
        }
        try {
            String jsNashorn = " if (typeof importClass != 'function') { load('nashorn:mozilla_compat.js');}";
            String jsCode = "importPackage(java.util);var _evaluateScriptParam = Arrays.asList(" + expression + "); ";
            engine.eval(jsNashorn + jsCode);
            List resultList = (List)engine.get("_evaluateScriptParam");
            if (resultList == null) {
                return null;
            }
            if ("[undefined]".equals(resultList.toString())) {
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("evalueateScript object to Java");
                for (Object val : resultList) {
                    logger.fine(val.toString());
                }
            }
            return resultList.toArray();
        }
        catch (ScriptException se) {
            logger.fine("[RulePlugin] error evaluating " + expression + " - " + se.getMessage());
            return null;
        }
    }

    private void updateActivityEntity(ScriptEngine engine, ItemCollection adocumentActivity) {
        Map<String, Object[]> orginalActivity = this.convertItemCollection(adocumentActivity);
        Map scriptActivity = (Map)engine.get("activity");
        for (Map.Entry entry : scriptActivity.entrySet()) {
            Object[] oActivity;
            String expression = "activity.get('" + (String)entry.getKey() + "')";
            Object[] oScript = this.evaluateScriptObject(engine, expression);
            if (oScript == null || (oActivity = orginalActivity.get(entry.getKey())) == null || Arrays.deepEquals(oScript, oActivity)) continue;
            logger.fine("[RulePlugin] update activity proeperty " + (String)entry.getKey());
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(oScript));
            adocumentActivity.replaceItemValue((String)entry.getKey(), list);
        }
    }

    private Map<String, Object[]> convertItemCollection(ItemCollection itemCol) {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        Map itemList = itemCol.getAllItems();
        for (Map.Entry entry : itemList.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            List value = (List)entry.getValue();
            if (value.size() <= 0 || !RulePlugin.isBasicObjectType(value.get(0).getClass())) continue;
            result.put(key, value.toArray());
        }
        return result;
    }

    private static boolean isBasicObjectType(Class<?> clazz) {
        return BASIC_OBJECT_TYPES.contains(clazz);
    }

    private static HashSet<Class<?>> getBasicObjectTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        ret.add(BigDecimal.class);
        ret.add(BigInteger.class);
        ret.add(String.class);
        ret.add(Object.class);
        ret.add(Date.class);
        ret.add(Calendar.class);
        ret.add(GregorianCalendar.class);
        return ret;
    }
}

