/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;
import org.imixs.workflow.plugins.RulePlugin;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResultPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    ItemCollection documentContext;
    String sActivityResult;
    private static Logger logger = Logger.getLogger(ResultPlugin.class.getName());

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        ItemCollection evalItemCollection = new ItemCollection();
        adocumentContext = ResultPlugin.evaluateWorkflowResult(adocumentActivity, this.documentContext);
        evalItemCollection = adocumentContext;
        if (evalItemCollection != null) {
            this.documentContext.replaceAllItems(evalItemCollection.getAllItems());
        }
        return 0;
    }

    public void close(int status) throws PluginException {
        try {
            if (status < 2) {
                this.documentContext.replaceItemValue("txtworkflowresultmessage", (Object)this.sActivityResult);
            }
        }
        catch (Exception e) {
            System.out.println("[ResultPlugin] Error close(): " + e.toString());
        }
    }

    @Deprecated
    private static ItemCollection evaluate(ItemCollection activityEntity, ItemCollection documentContext) throws PluginException {
        String sResult = activityEntity.getItemValueString("txtActivityResult");
        sResult = new ResultPlugin().replaceDynamicValues(sResult, documentContext);
        ItemCollection evalItemCollection = new ItemCollection();
        ResultPlugin.evaluate(sResult, evalItemCollection);
        return evalItemCollection;
    }

    @Deprecated
    private static void evaluate(String aString, ItemCollection documentContext) throws PluginException {
        int iTagStartPos;
        ArrayList<String> mulitValueItemNames = new ArrayList<String>();
        String sName = "";
        String sType = " ";
        if (aString == null) {
            return;
        }
        while ((iTagStartPos = aString.toLowerCase().indexOf("<item")) != -1) {
            int iTagEndPos = aString.toLowerCase().indexOf("</item>", iTagStartPos);
            if (iTagEndPos == -1) {
                throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "</item>  expected!");
            }
            int iContentStartPos = 0;
            int iContentEndPos = 0;
            int iNameStartPos = 0;
            int iNameEndPos = 0;
            int iTypeStartPos = 0;
            int iTypeEndPos = 0;
            sName = "";
            sType = " ";
            String sItemValue = "";
            iContentEndPos = iTagEndPos;
            String sTestString = aString.substring(0, iContentEndPos);
            iContentStartPos = sTestString.indexOf(62) + 1;
            if (iContentStartPos >= iContentEndPos) {
                return;
            }
            iTagEndPos += "</item>".length();
            iNameStartPos = aString.toLowerCase().indexOf("name=", iTagStartPos);
            if (iNameStartPos > -1 && iNameStartPos < iContentStartPos) {
                String sNamePart = aString.substring(0, iContentStartPos);
                sNamePart = sNamePart.replace("'", "\"");
                iNameStartPos = sNamePart.indexOf("\"", iNameStartPos) + 1;
                iNameEndPos = sNamePart.indexOf("\"", iNameStartPos + 1);
                sName = sNamePart.substring(iNameStartPos, iNameEndPos);
            }
            if ((iTypeStartPos = aString.toLowerCase().indexOf("type=", iTagStartPos)) > -1 && iTypeStartPos < iContentStartPos) {
                String sTypePart = aString.substring(0, iContentStartPos);
                sTypePart = sTypePart.replace("'", "\"");
                iTypeStartPos = sTypePart.indexOf("\"", iTypeStartPos) + 1;
                iTypeEndPos = sTypePart.indexOf("\"", iTypeStartPos + 1);
                sType = sTypePart.substring(iTypeStartPos, iTypeEndPos);
            }
            sItemValue = aString.substring(iContentStartPos, iContentEndPos);
            if (sName != null && !"".equals(sName)) {
                if ((sName = sName.toLowerCase()).startsWith("$")) {
                    logger.warning("ResultPlugin - item '" + sName + "' update not allowed!");
                } else {
                    Object oValue = sItemValue;
                    if ("boolean".equalsIgnoreCase(sType)) {
                        oValue = Boolean.valueOf(sItemValue);
                    }
                    if ("integer".equalsIgnoreCase(sType)) {
                        oValue = new Integer(sItemValue);
                    }
                    if (!mulitValueItemNames.contains(sName)) {
                        documentContext.replaceItemValue(sName, oValue);
                        mulitValueItemNames.add(sName);
                    } else {
                        List values = documentContext.getItemValue(sName);
                        values.add(oValue);
                        documentContext.replaceItemValue(sName, (Object)values);
                    }
                }
            }
            aString = aString.substring(0, iTagStartPos) + "" + aString.substring(iTagEndPos);
        }
    }

    public static ItemCollection parseItemStructure(String xmlContent) throws PluginException {
        logger.fine("Evaluate Subprocess Item...");
        ItemCollection result = new ItemCollection();
        if (xmlContent.length() > 0) {
            xmlContent = "<item>" + xmlContent.trim() + "</item>";
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(new InputSource(new StringReader(xmlContent)));
                Node node = doc.importNode(doc.getDocumentElement(), true);
                DocumentFragment docfrag = doc.createDocumentFragment();
                while (node.hasChildNodes()) {
                    docfrag.appendChild(node.removeChild(node.getFirstChild()));
                }
                NodeList childs = docfrag.getChildNodes();
                int itemCount = childs.getLength();
                for (int i = 0; i < itemCount; ++i) {
                    Node childNode = childs.item(i);
                    if (!(childNode instanceof Element) || childNode.getFirstChild() == null) continue;
                    String name = childNode.getNodeName();
                    String value = childNode.getFirstChild().getNodeValue();
                    result.replaceItemValue(name, (Object)value);
                    logger.fine("[ResultPlugin] parsing item '" + name + "' value=" + value);
                }
            }
            catch (ParserConfigurationException e) {
                throw new PluginException(RulePlugin.class.getName(), INVALID_FORMAT, "Parsing item content failed: " + e.getMessage());
            }
            catch (SAXException e) {
                throw new PluginException(RulePlugin.class.getName(), INVALID_FORMAT, "Parsing item content failed: " + e.getMessage());
            }
            catch (IOException e) {
                throw new PluginException(RulePlugin.class.getName(), INVALID_FORMAT, "Parsing item content failed: " + e.getMessage());
            }
        }
        return result;
    }

    public static ItemCollection evaluateWorkflowResult(ItemCollection activityEntity, ItemCollection documentContext) throws PluginException {
        boolean invalidPattern = true;
        ItemCollection result = new ItemCollection();
        String workflowResult = activityEntity.getItemValueString("txtActivityResult");
        if (workflowResult.isEmpty()) {
            return null;
        }
        workflowResult = new ResultPlugin().replaceDynamicValues(workflowResult, documentContext);
        Pattern pattern = Pattern.compile("<item(.*?)>(.*?)</item>|<item(.*?)./>");
        Matcher matcher = pattern.matcher(workflowResult);
        while (matcher.find()) {
            invalidPattern = false;
            String attributes = matcher.group(1);
            String content = matcher.group(2);
            if (attributes == null || content == null) {
                attributes = matcher.group(3);
            }
            if (content == null) {
                content = "";
            }
            if (attributes != null && !attributes.isEmpty()) {
                String spattern = "(\\S+)=[\"']?((?:.(?![\"']?\\s+(?:\\S+)=|[>\"']))+.)[\"']?";
                Pattern attributePattern = Pattern.compile(spattern);
                Matcher attributeMatcher = attributePattern.matcher(attributes);
                HashMap<String, String> attrMap = new HashMap<String, String>();
                while (attributeMatcher.find()) {
                    String attrName = attributeMatcher.group(1);
                    String attrValue = attributeMatcher.group(2);
                    attrMap.put(attrName, attrValue);
                }
                String itemName = (String)attrMap.get("name");
                if (itemName == null) {
                    throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "<item> tag contains no name attribute.");
                }
                if (itemName.startsWith("$")) {
                    throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "<item> tag contains invalid name attribute '" + itemName + "'.");
                }
                for (String attrName : attrMap.keySet()) {
                    if ("name".equals(attrName)) continue;
                    result.appendItemValue(itemName + "." + attrName, attrMap.get(attrName));
                }
                String sType = result.getItemValueString(itemName + ".type");
                if (!sType.isEmpty()) {
                    if ("boolean".equalsIgnoreCase(sType)) {
                        result.appendItemValue(itemName, (Object)Boolean.valueOf(content));
                        continue;
                    }
                    if ("integer".equalsIgnoreCase(sType)) {
                        result.appendItemValue(itemName, (Object)new Integer(content));
                        continue;
                    }
                    if ("double".equalsIgnoreCase(sType)) {
                        result.appendItemValue(itemName, (Object)new Double(content));
                        continue;
                    }
                    result.appendItemValue(itemName, (Object)content);
                    continue;
                }
                result.appendItemValue(itemName, (Object)content);
                continue;
            }
            throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "<item> tag contains no name attribute.");
        }
        if (invalidPattern) {
            throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "invalid <item> tag format - expected <item name=\"...\" ...></item>");
        }
        return result;
    }
}

