/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;
import org.imixs.workflow.plugins.AccessPlugin;

public class OwnerPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    ItemCollection documentNextProcessEntity;
    Vector<?> itemOwnerRollback;
    private static Logger logger = Logger.getLogger(AccessPlugin.class.getName());

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        this.itemOwnerRollback = (Vector)this.documentContext.getItemValue("namowner");
        if (this.isFallBackMode()) {
            this.processFallBack();
            return 0;
        }
        int iNextProcessID = adocumentActivity.getItemValueInteger("numNextProcessID");
        String aModelVersion = adocumentActivity.getItemValueString("$modelVersion");
        this.documentNextProcessEntity = this.ctx.getModel().getProcessEntity(iNextProcessID, aModelVersion);
        if (!(this.documentActivity.getItemValueBoolean("keyupdateacl") || this.documentNextProcessEntity != null && this.documentNextProcessEntity.getItemValueBoolean("keyupdateacl"))) {
            return 0;
        }
        if (this.documentActivity.getItemValueBoolean("keyupdateacl")) {
            this.updateOwnerByItemCollection(this.documentActivity);
        } else {
            this.updateOwnerByItemCollection(this.documentNextProcessEntity);
        }
        return 0;
    }

    private void updateOwnerByItemCollection(ItemCollection modelEntity) {
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<Object> newOwnerList = new ArrayList<Object>();
        this.mergeValueList(newOwnerList, modelEntity.getItemValue("namOwnershipNames"));
        this.mergeFieldList(this.documentContext, newOwnerList, modelEntity.getItemValue("keyOwnershipFields"));
        newOwnerList = this.uniqueList(newOwnerList);
        this.documentContext.replaceItemValue("namowner", newOwnerList);
        if (this.ctx.getLogLevel() == 2 && newOwnerList.size() > 0) {
            logger.info("[OwnerPlugin] Owners:");
            for (int j = 0; j < newOwnerList.size(); ++j) {
                logger.info("               '" + (String)newOwnerList.get(j) + "'");
            }
        }
    }

    public void close(int status) {
        if (status == 2) {
            this.documentContext.replaceItemValue("namOwner", this.itemOwnerRollback);
        }
    }

    private boolean isFallBackMode() {
        if (this.documentActivity.hasItem("keyupdateacl")) {
            return false;
        }
        return this.documentActivity.hasItem("keyOwnershipMode");
    }

    @Deprecated
    private void processFallBack() {
        Vector<Object> itemOwner = (Vector<Object>)this.documentContext.getItemValue("namowner");
        this.itemOwnerRollback = (Vector)this.documentContext.getItemValue("namOwners");
        List<Object> vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyOwnershipMode")) ? itemOwner : new Vector<Object>();
        if (this.ctx.getLogLevel() == 2) {
            System.out.println("[OwnerPlugin] AccessMode: '" + this.documentActivity.getItemValueString("keyOwnershipMode") + "'");
        }
        if (vectorAccess == null) {
            vectorAccess = new Vector();
        }
        this.mergeValueList(vectorAccess, this.documentActivity.getItemValue("namOwnershipNames"));
        this.mergeFieldList(this.documentContext, vectorAccess, this.documentActivity.getItemValue("keyOwnershipFields"));
        vectorAccess = this.uniqueList(vectorAccess);
        this.documentContext.replaceItemValue("namOwner", vectorAccess);
        if (this.ctx.getLogLevel() == 2 && vectorAccess.size() > 0) {
            System.out.println("[OwnerPlugin] Owner:");
            for (int j = 0; j < vectorAccess.size(); ++j) {
                System.out.println("              " + (String)vectorAccess.get(j));
            }
        }
    }
}

