/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class AccessPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    ItemCollection documentNextProcessEntity;
    List<?> itemReadRollback;
    List<?> itemWriteRollback;
    private static Logger logger = Logger.getLogger(AccessPlugin.class.getName());

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        this.itemReadRollback = (Vector)this.documentContext.getItemValue("$readAccess");
        this.itemWriteRollback = this.documentContext.getItemValue("$writeAccess");
        if (this.isFallBackMode()) {
            this.processFallBack();
            return 0;
        }
        int iNextProcessID = adocumentActivity.getItemValueInteger("numNextProcessID");
        String aModelVersion = adocumentActivity.getItemValueString("$modelVersion");
        this.documentNextProcessEntity = this.ctx.getModel().getProcessEntity(iNextProcessID, aModelVersion);
        if (!(this.documentActivity.getItemValueBoolean("keyupdateacl") || this.documentNextProcessEntity != null && this.documentNextProcessEntity.getItemValueBoolean("keyupdateacl"))) {
            return 0;
        }
        this.documentContext.replaceItemValue("$readAccess", new Vector());
        this.documentContext.replaceItemValue("$writeAccess", new Vector());
        if (this.documentActivity.getItemValueBoolean("keyupdateacl")) {
            this.updateACLByItemCollection(this.documentActivity);
        } else {
            this.updateACLByItemCollection(this.documentNextProcessEntity);
        }
        return 0;
    }

    private void updateACLByItemCollection(ItemCollection modelEntity) {
        int j;
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<?> vectorAccess = this.documentContext.getItemValue("$readAccess");
        this.mergeValueList(vectorAccess, modelEntity.getItemValue("namaddreadaccess"));
        this.mergeFieldList(this.documentContext, vectorAccess, modelEntity.getItemValue("keyaddreadfields"));
        vectorAccess = this.uniqueList((List<Object>)vectorAccess);
        this.documentContext.replaceItemValue("$readAccess", vectorAccess);
        if (this.ctx.getLogLevel() == 2 && vectorAccess.size() > 0) {
            logger.info("[AccessPlugin] ReadAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.info("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
        vectorAccess = this.documentContext.getItemValue("$writeAccess");
        this.mergeValueList(vectorAccess, modelEntity.getItemValue("namaddwriteaccess"));
        this.mergeFieldList(this.documentContext, vectorAccess, modelEntity.getItemValue("keyaddwritefields"));
        vectorAccess = this.uniqueList((List<Object>)vectorAccess);
        this.documentContext.replaceItemValue("$writeAccess", vectorAccess);
        if (this.ctx.getLogLevel() == 2 && vectorAccess.size() > 0) {
            logger.info("[AccessPlugin] WriteAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.info("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
    }

    public void close(int status) {
        if (status == 2) {
            this.documentContext.replaceItemValue("$writeAccess", this.itemWriteRollback);
            this.documentContext.replaceItemValue("$readAccess", this.itemReadRollback);
        }
    }

    @Deprecated
    private boolean isFallBackMode() {
        if (this.documentActivity.hasItem("keyupdateacl")) {
            return false;
        }
        return this.documentActivity.hasItem("keyaccessmode");
    }

    @Deprecated
    private void processFallBack() {
        int j;
        Vector<Object> itemRead = (Vector<Object>)this.documentContext.getItemValue("$readAccess");
        List<Object> vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyaccessmode")) ? itemRead : new Vector<Object>();
        if (this.ctx.getLogLevel() == 2) {
            logger.info("[AccessPlugin] AccessMode: '" + this.documentActivity.getItemValueString("keyaccessmode") + "'");
        }
        if (vectorAccess == null) {
            vectorAccess = new Vector();
        }
        this.mergeValueList(vectorAccess, this.documentActivity.getItemValue("namaddreadaccess"));
        this.mergeFieldList(this.documentContext, vectorAccess, this.documentActivity.getItemValue("keyaddreadfields"));
        vectorAccess = this.uniqueList(vectorAccess);
        this.documentContext.replaceItemValue("$readAccess", vectorAccess);
        if (this.ctx.getLogLevel() == 2 && vectorAccess.size() > 0) {
            logger.info("[AccessPlugin] ReadAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.info("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
        List itemWrite = this.documentContext.getItemValue("$writeAccess");
        vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyaccessmode")) ? itemWrite : new Vector();
        if (vectorAccess == null) {
            vectorAccess = new Vector();
        }
        this.mergeValueList(vectorAccess, this.documentActivity.getItemValue("namaddwriteaccess"));
        this.mergeFieldList(this.documentContext, vectorAccess, this.documentActivity.getItemValue("keyaddwritefields"));
        vectorAccess = this.uniqueList(vectorAccess);
        this.documentContext.replaceItemValue("$writeAccess", vectorAccess);
        if (this.ctx.getLogLevel() == 2 && vectorAccess.size() > 0) {
            logger.info("[AccessPlugin] WriteAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.info("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
    }
}

