/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;

public abstract class AbstractPlugin
implements Plugin {
    public WorkflowContext ctx;
    public static final String INVALID_ITEMVALUE_FORMAT = "INVALID_ITEMVALUE_FORMAT";

    public void init(WorkflowContext actx) throws PluginException {
        this.ctx = actx;
    }

    public String replaceDynamicValues(String aString, ItemCollection documentContext) throws PluginException {
        int iTagStartPos;
        String sFormat = "";
        String sSeparator = " ";
        if (aString == null) {
            return "";
        }
        while ((iTagStartPos = aString.toLowerCase().indexOf("<itemvalue")) != -1) {
            int iTagEndPos = aString.toLowerCase().indexOf("</itemvalue>", iTagStartPos);
            if (iTagEndPos == -1) {
                throw new PluginException(this.getClass().getSimpleName(), INVALID_ITEMVALUE_FORMAT, "[AbstractPlugin] invalid itemvalue format: " + aString);
            }
            int iContentStartPos = 0;
            int iContentEndPos = 0;
            sFormat = "";
            sSeparator = " ";
            String sItemValue = "";
            iContentEndPos = iTagEndPos;
            String sTestString = aString.substring(0, iContentEndPos);
            iContentStartPos = sTestString.lastIndexOf(62) + 1;
            if (iContentStartPos >= iContentEndPos) {
                throw new PluginException(this.getClass().getSimpleName(), INVALID_ITEMVALUE_FORMAT, "[AbstractPlugin] invalid itemvalue format: " + aString);
            }
            iTagEndPos += "</itemvalue>".length();
            sFormat = this.extractAttribute(aString.substring(0, iContentEndPos), "format");
            sSeparator = this.extractAttribute(aString.substring(0, iContentEndPos), "separator");
            Locale locale = null;
            String sLocale = this.extractAttribute(aString.substring(0, iContentEndPos), "locale");
            if (sLocale != null && !sLocale.isEmpty()) {
                String sCount;
                String sLang;
                StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
                if (stLocale.countTokens() == 1) {
                    sLang = stLocale.nextToken();
                    sCount = sLang.toUpperCase();
                    locale = new Locale(sLang, sCount);
                } else {
                    sLang = stLocale.nextToken();
                    sCount = stLocale.nextToken();
                    locale = new Locale(sLang, sCount);
                }
            }
            sItemValue = aString.substring(iContentStartPos, iContentEndPos);
            List vValue = documentContext.getItemValue(sItemValue);
            String sResult = AbstractPlugin.formatItemValues(vValue, sSeparator, sFormat, locale);
            aString = aString.substring(0, iTagStartPos) + sResult + aString.substring(iTagEndPos);
        }
        return aString;
    }

    public static String formatItemValues(Collection<?> aItem, String aSeparator, String sFormat, Locale locale) {
        StringBuffer sBuffer = new StringBuffer();
        if (aItem == null) {
            return "";
        }
        for (Object aSingleValue : aItem) {
            String aValue = AbstractPlugin.formatObjectValue(aSingleValue, sFormat, locale);
            sBuffer.append(aValue);
            if (aSeparator == null) continue;
            sBuffer.append(aSeparator);
        }
        String sString = sBuffer.toString();
        if (aSeparator != null && sString.endsWith(aSeparator)) {
            sString = sString.substring(0, sString.lastIndexOf(aSeparator));
        }
        return sString;
    }

    public static String formatItemValues(Collection<?> aItem, String aSeparator, String sFormat) {
        return AbstractPlugin.formatItemValues(aItem, aSeparator, sFormat, null);
    }

    private static String formatObjectValue(Object o, String format, Locale locale) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null ? new SimpleDateFormat(format, locale) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("AbstractPlugin: Invalid format String '" + format + "'");
                    logger.warning("AbstractPlugin: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }

    private String extractAttribute(String aString, String attributeName) {
        int iTagStartPos = -1;
        String sAttributeValue = null;
        int iAttributeStartPos = aString.toLowerCase().indexOf(attributeName + "=", iTagStartPos);
        if (iAttributeStartPos > -1) {
            iAttributeStartPos = aString.indexOf("\"", iAttributeStartPos) + 1;
            int iAttributEndPos = aString.indexOf("\"", iAttributeStartPos + 1);
            sAttributeValue = aString.substring(iAttributeStartPos, iAttributEndPos);
        }
        return sAttributeValue;
    }

    public void mergeValueList(List valueList, List sourceList) {
        if (sourceList != null && sourceList.size() > 0) {
            for (Object o : sourceList) {
                if (valueList.indexOf(o) != -1) continue;
                valueList.add(o);
            }
        }
    }

    public void mergeFieldList(ItemCollection documentContext, List valueList, List<String> fieldList) {
        if (valueList == null || fieldList == null) {
            return;
        }
        List<String> values = null;
        if (fieldList.size() > 0) {
            for (String key : fieldList) {
                if (key == null || (values = (key = key.trim()).startsWith("[") && key.endsWith("]") || key.startsWith("{") && key.endsWith("}") ? Arrays.asList(key.substring(1, key.length() - 1).split("\\s*,\\s*")) : documentContext.getItemValue(key.toString())) == null || values.size() <= 0) continue;
                for (String o : values) {
                    if (valueList.indexOf(o) != -1) continue;
                    valueList.add(o);
                }
            }
        }
    }

    public List<?> uniqueList(List<Object> valueList) {
        int iVectorSize = valueList.size();
        Vector<Object> cleanedVector = new Vector<Object>();
        for (int i = 0; i < iVectorSize; ++i) {
            Object o = valueList.get(i);
            if (o == null || cleanedVector.indexOf(o) > -1 || "".equals(o.toString())) continue;
            cleanedVector.add(o);
        }
        valueList = cleanedVector;
        if (valueList.size() == 0) {
            valueList.add("");
        }
        return valueList;
    }
}

