/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.WorkflowManager;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.ReportService;
import org.imixs.workflow.jee.ejb.WorkflowServiceRemote;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class WorkflowService
implements WorkflowManager,
WorkflowContext,
WorkflowServiceRemote {
    public static final String UNIQUEID = "$uniqueid";
    public static final String UNIQUEIDREF = "$uniqueidref";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String ISAUTHOR = "$isAuthor";
    public static final String WORKITEMID = "$workitemid";
    public static final String PROCESSID = "$processid";
    public static final String MODELVERSION = "$modelversion";
    public static final String ACTIVITYID = "$activityid";
    public static final int SORT_ORDER_CREATED_DESC = 0;
    public static final int SORT_ORDER_CREATED_ASC = 1;
    public static final int SORT_ORDER_MODIFIED_DESC = 2;
    public static final int SORT_ORDER_MODIFIED_ASC = 3;
    private int logLevel = 0;
    @Inject
    @Any
    private Instance<Plugin> plugins;
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;
    @EJB
    ReportService reportService;
    @Resource
    SessionContext ctx;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    @PostConstruct
    private void initIndexProperties() throws AccessDeniedException {
        this.entityService.addIndex("namCreator", 0);
        this.entityService.addIndex("txtWorkflowGroup", 0);
        this.entityService.addIndex("$ProcessID", 1);
        this.entityService.addIndex(WORKITEMID, 0);
        this.entityService.addIndex(UNIQUEIDREF, 0);
        this.entityService.addIndex("txtname", 0);
        this.entityService.addIndex("namowner", 0);
        this.entityService.addIndex("txtworkitemref", 0);
    }

    @Override
    public ItemCollection getWorkItem(String uniqueid) {
        return this.entityService.load(uniqueid);
    }

    @Override
    public List<ItemCollection> getWorkList(int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkList() {
        return this.getWorkList(0, -1, null, 0);
    }

    @Override
    public List<ItemCollection> getWorkListByAuthor(String name, int startpos, int count, String type, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.writeAccessList as wa JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " wa.value = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkListByAuthor(String name) {
        return this.getWorkListByAuthor(name, 0, -1, null, 0);
    }

    @Override
    public List<ItemCollection> getWorkListByCreator(String name, int startpos, int count, String type, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = 'namcreator' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkListByOwner(String name, int startpos, int count, String type, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = 'namowner' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkListByWriteAccess(int startpos, int count, String type, int sortorder) {
        StringBuffer nameListBuffer = new StringBuffer();
        String name = this.ctx.getCallerPrincipal().getName();
        nameListBuffer.append("'" + name + "'");
        String accessRoles = this.entityService.getAccessRoles();
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS," + accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            String testRole = roleListTokens.nextToken().trim();
            if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
            nameListBuffer.append(",'" + testRole + "'");
        }
        String sQuery = "SELECT wi FROM Entity as wi  JOIN wi.writeAccessList wa  WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' ";
        }
        sQuery = sQuery + " AND wa.value IN (" + nameListBuffer.toString() + ")" + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkListByGroup(String name, int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as t  JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = 'txtworkflowgroup' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkListByProcessID(int aid, int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.integerItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = '$processid' and t.itemValue = '" + aid + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    @Override
    public List<ItemCollection> getWorkListByRef(String aref) {
        return this.getWorkListByRef(aref, 0, -1, null, 0);
    }

    @Override
    public List<ItemCollection> getWorkListByRef(String aref, int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = '$uniqueidref' and t.itemValue = '" + aref + "'" + " and s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    private String createSortOrderClause(int asortorder) {
        switch (asortorder) {
            case 1: {
                return " ORDER BY wi.created asc";
            }
            case 3: {
                return " ORDER BY wi.modified asc";
            }
            case 2: {
                return " ORDER BY wi.modified desc";
            }
        }
        return " ORDER BY wi.created desc";
    }

    @Override
    public ItemCollection processWorkItem(ItemCollection workitem) throws AccessDeniedException, ProcessingErrorException, PluginException {
        ItemCollection profile;
        if (workitem == null) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_WORKITEM", "WorkflowService: error - workitem is null");
        }
        ItemCollection currentInstance = this.getWorkItem(workitem.getItemValueString(UNIQUEID));
        if (currentInstance != null) {
            if (!currentInstance.getItemValueBoolean(ISAUTHOR)) {
                throw new AccessDeniedException("OPERATION_NOTALLOWED", "WorkflowService: error - $UnqiueID (" + workitem.getItemValueInteger(UNIQUEID) + ") no Author Access!");
            }
            if (workitem.getItemValueInteger("$ProcessID") > 0 && currentInstance.getItemValueInteger("$ProcessID") != workitem.getItemValueInteger("$ProcessID")) {
                throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_PROCESSID", "WorkflowService: error - $ProcesssID (" + workitem.getItemValueInteger("$ProcessID") + ") did not match expected $ProcesssID (" + currentInstance.getItemValueInteger("$ProcessID") + ")");
            }
            currentInstance.replaceAllItems(workitem.getAllItems());
            workitem = currentInstance;
        }
        String modelversion = workitem.getItemValueString(MODELVERSION);
        int processID = workitem.getItemValueInteger(PROCESSID);
        ItemCollection processEntity = this.modelService.getProcessEntity(processID, modelversion);
        if (processEntity == null) {
            try {
                String newModelVersion = this.modelService.getLatestVersionByWorkitem(workitem);
                if (newModelVersion != null && !newModelVersion.isEmpty()) {
                    modelversion = newModelVersion;
                    logger.info("WorkflowService: $modelversion '" + workitem.getItemValueString(MODELVERSION) + "' no longer provided, updating to $modelversion '" + modelversion + "'");
                    workitem.replaceItemValue(MODELVERSION, (Object)modelversion);
                }
            }
            catch (ModelException e) {
                throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_MODELVERSION", "WorkflowService: fatal error - no valid model version '" + modelversion + "' found! Verify WorkflowModels: " + e.getMessage());
            }
        }
        if ((profile = this.findModelProfile(modelversion)) == null) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_MODELVERSION", "WorkflowService: fatal error - no valid model version '" + modelversion + "' found! Verify WorkflowModels.");
        }
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        List vPlugins = profile.getItemValue("txtPlugins");
        for (int i = 0; i < vPlugins.size(); ++i) {
            String aPluginClassName = (String)vPlugins.get(i);
            Plugin aPlugin = this.findPluginByName(aPluginClassName);
            if (aPlugin != null) {
                if (this.getLogLevel() == 2) {
                    logger.info("[WorkflowService] register CDI plugin class: " + aPluginClassName + "...");
                }
                workflowkernel.registerPlugin(aPlugin);
                continue;
            }
            workflowkernel.registerPlugin(aPluginClassName);
        }
        String sDebug = profile.getItemValueString("keyDebugLevel");
        try {
            int idebug;
            this.logLevel = idebug = Integer.parseInt(sDebug);
        }
        catch (NumberFormatException e) {
            this.logLevel = 0;
        }
        String nameEditor = this.ctx.getCallerPrincipal().getName();
        if (workitem.getItemValueString("namCreator").isEmpty()) {
            workitem.replaceItemValue("namCreator", (Object)nameEditor);
        }
        if (!nameEditor.equals(workitem.getItemValueString("namcurrenteditor")) && !workitem.getItemValueString("namcurrenteditor").isEmpty()) {
            workitem.replaceItemValue("namlasteditor", (Object)workitem.getItemValueString("namcurrenteditor"));
        }
        workitem.replaceItemValue("namcurrenteditor", (Object)nameEditor);
        workflowkernel.process(workitem);
        if (this.getLogLevel() == 2) {
            logger.info("[WorkflowManager] workitem processed sucessfull");
        }
        return this.entityService.save(workitem);
    }

    private Plugin findPluginByName(String pluginClassName) {
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        if (this.plugins == null || !this.plugins.iterator().hasNext()) {
            logger.fine("[WorkflowService] no CDI plugins injected");
            return null;
        }
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(pluginClassName)) continue;
            logger.fine("[WorkflowService] CDI plugin '" + pluginClassName + "' successful injected");
            return plugin;
        }
        return null;
    }

    @Override
    public void removeWorkItem(ItemCollection aworkitem) throws AccessDeniedException {
        this.entityService.remove(aworkitem);
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public Model getModel() {
        return this.modelService;
    }

    public Object getSessionContext() {
        return this.ctx;
    }

    private ItemCollection findModelProfile(String modelversion) throws ProcessingErrorException {
        if (modelversion == null || "".equals(modelversion)) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_MODELVERSION", "WorkflowService: fatal error - no valid model version provided");
        }
        String sQuery = null;
        sQuery = "SELECT";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery = sQuery + " environment FROM Entity AS environment JOIN environment.textItems as n  JOIN environment.textItems as v  WHERE environment.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "' ", 0, 1);
        if (col.size() == 0) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    @Override
    public ModelService getModelService() {
        return this.modelService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    @Override
    public String getUserName() {
        return this.ctx.getCallerPrincipal().getName();
    }

    @Override
    public boolean isUserInRole(String rolename) {
        try {
            return this.ctx.isCallerInRole(rolename);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<String> getUserNameList() {
        return this.entityService.getUserNameList();
    }
}

