/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.Model;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelServiceRemote;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class ModelService
implements Model,
ModelServiceRemote {
    @EJB
    EntityService entityService;
    @Resource
    SessionContext ctx;
    private static Logger logger = Logger.getLogger(ModelService.class.getName());

    @PostConstruct
    void initIndex() throws AccessDeniedException {
        this.entityService.addIndex("numProcessID", 1);
        this.entityService.addIndex("numActivityID", 1);
        this.entityService.addIndex("$modelversion", 0);
        this.entityService.addIndex("Type", 0);
        this.entityService.addIndex("txtname", 0);
        this.entityService.addIndex("txtworkflowgroup", 0);
    }

    @Override
    public ItemCollection getActivityEntity(int processid, int activityid, String modelVersion) {
        return this.findActivityEntity(processid, activityid, modelVersion);
    }

    @Override
    public ItemCollection getProcessEntity(int processid, String modelversion) {
        return this.findProcessEntity(processid, modelversion);
    }

    @Override
    public List<ItemCollection> getActivityEntityList(int processid, String aModelVersion) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity AS wi JOIN wi.integerItems as i1  JOIN wi.integerItems as i2  JOIN wi.textItems AS v WHERE wi.type= 'ActivityEntity'  AND i1.itemName = 'numprocessid' AND i1.itemValue = '" + processid + "' " + " AND i2.itemName = 'numactivityid' " + " AND v.itemName = '$modelversion' AND v.itemValue = '" + aModelVersion + "'" + " ORDER BY i2.itemValue ASC";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    @Override
    public List<ItemCollection> getProcessEntityList(String aModelVersion) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity AS wi  JOIN wi.integerItems as i   JOIN wi.textItems AS v WHERE wi.type= 'ProcessEntity'  AND i.itemName = 'numprocessid'  AND v.itemName = '$modelversion' AND v.itemValue = '" + aModelVersion + "'" + " ORDER BY i.itemValue ASC";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    @Override
    public void saveActivityEntity(ItemCollection ic) throws ModelException, AccessDeniedException {
        int processid = ic.getItemValueInteger("numProcessID");
        if (processid <= 0) {
            throw new ModelException("INVALID_MODEL_ENTRY", "invalid ProcessEntity");
        }
        int activityid = ic.getItemValueInteger("numActivityID");
        if (activityid <= 0) {
            throw new ModelException("INVALID_MODEL_ENTRY", "invalid ActivityEntity id: " + activityid);
        }
        ic.replaceItemValue("Type", (Object)"ActivityEntity");
        this.entityService.save(ic);
    }

    @Override
    public void saveProcessEntity(ItemCollection ic) throws ModelException, AccessDeniedException {
        int processid = ic.getItemValueInteger("numProcessID");
        if (processid <= 0) {
            throw new ModelException("INVALID_MODEL_ENTRY", "invalid ProcessEntity: " + processid);
        }
        ic.replaceItemValue("Type", (Object)"ProcessEntity");
        this.entityService.save(ic);
    }

    @Override
    public void saveEnvironmentEntity(ItemCollection ic) throws ModelException, AccessDeniedException {
        ic.replaceItemValue("Type", (Object)"WorkflowEnvironmentEntity");
        this.entityService.save(ic);
    }

    @Override
    public void removeModel(String modelversion) throws ModelException, AccessDeniedException {
        logger.fine("remove $modelversion: " + modelversion + "...");
        String sQuery = null;
        sQuery = "";
        sQuery = modelversion != null ? "SELECT entity FROM Entity AS entity  JOIN entity.textItems as v WHERE entity.type IN ('ProcessEntity', 'ActivityEntity', 'WorkflowEnvironmentEntity') AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'" : "SELECT entity FROM Entity AS entity  WHERE entity.type IN ('ProcessEntity', 'ActivityEntity', 'WorkflowEnvironmentEntity')";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, -1);
        logger.fine(col.size() + " model entities will be removed...");
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.entityService.remove((ItemCollection)it.next());
        }
        logger.info("removed $modelversion: " + modelversion);
    }

    @Override
    public void removeModelGroup(String workflowgroup, String modelversion) throws ModelException, AccessDeniedException {
        logger.fine("remove ModelGroup: " + workflowgroup + " $modelversion: " + modelversion + " ...");
        String sQuery = null;
        sQuery = "";
        if (modelversion == null) {
            throw new ModelException("UNDEFINED_MODEL_ENTRY", "modelversion not defined!");
        }
        sQuery = "SELECT entity FROM Entity AS entity  JOIN entity.textItems as v JOIN entity.textItems as g WHERE entity.type IN ('ProcessEntity') AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'" + " AND g.itemName = 'txtworkflowgroup' AND g.itemValue = '" + workflowgroup + "'";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, -1);
        logger.fine(col.size() + " ProcessEntities will be removed...");
        for (ItemCollection processEntity : col) {
            int processID = processEntity.getItemValueInteger("numprocessid");
            sQuery = "SELECT entity FROM Entity AS entity  JOIN entity.textItems as v JOIN entity.integerItems as g WHERE entity.type IN ('ActivityEntity') AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'" + " AND g.itemName = 'numprocessid' AND g.itemValue = '" + processID + "'";
            List<ItemCollection> colactivities = this.entityService.findAllEntities(sQuery, 0, -1);
            logger.fine(colactivities.size() + " ActivityEntities will be removed...");
            Iterator it = colactivities.iterator();
            while (it.hasNext()) {
                this.entityService.remove((ItemCollection)it.next());
            }
            this.entityService.remove(processEntity);
        }
        logger.info("removed ModelGroup: " + workflowgroup + " $modelversion: " + modelversion);
    }

    private ItemCollection findEnvironmentEntity(String name, String modelversion) {
        String sQuery = null;
        sQuery = "SELECT";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery = sQuery + " environment FROM Entity AS environment  JOIN environment.textItems AS n  JOIN environment.textItems as v WHERE environment.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' and n.itemValue = '" + name + "'" + " AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        Iterator it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    private ItemCollection findProcessEntity(int processid, String modelversion) {
        String sQuery = null;
        sQuery = "SELECT";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery = sQuery + " process FROM Entity AS process  JOIN process.integerItems AS i  JOIN process.textItems as v WHERE process.type = 'ProcessEntity' AND i.itemName = 'numprocessid' and i.itemValue = '" + processid + "'" + " AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        Iterator it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    private ItemCollection findActivityEntity(int processid, int activityid, String modelversion) {
        String sQuery = null;
        sQuery = "SELECT";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery = sQuery + " activity FROM Entity as activity  JOIN activity.integerItems as i  JOIN activity.integerItems as i2  JOIN activity.textItems as v WHERE activity.type = 'ActivityEntity' AND i.itemName = 'numprocessid'  AND i.itemValue = '" + processid + "'" + " AND i2.itemName = 'numactivityid' and i2.itemValue = '" + activityid + "' " + " AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        Iterator it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    @Override
    public String getLatestVersion() throws ModelException {
        String sQuery = "SELECT process FROM Entity AS process JOIN process.textItems as v JOIN process.textItems as n WHERE process.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName='$modelversion'  ORDER BY v.itemValue DESC";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, 1);
        if (col.size() > 0) {
            Iterator iter = col.iterator();
            String sModelVersion = ((ItemCollection)iter.next()).getItemValueString("$modelversion");
            return sModelVersion;
        }
        throw new ModelException("UNDEFINED_MODEL_ENTRY", "[ModelService] no model definition found!");
    }

    public String getLatestVersionByWorkitem(ItemCollection workitem) throws ModelException {
        String workflowGroup = workitem.getItemValueString("txtWorkflowGroup");
        int processId = workitem.getItemValueInteger("$processid");
        String sQuery = "SELECT process FROM Entity AS process JOIN process.textItems as g JOIN process.integerItems as n WHERE process.type = 'ProcessEntity' AND n.itemName = 'numprocessid' AND n.itemValue = " + processId + " AND g.itemName='txtworkflowgroup' AND g.itemValue= '" + workflowGroup + "'";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, -1);
        Collections.sort(col, new ItemCollectionComparator("$modelversion"));
        if (col.size() > 0) {
            Iterator<ItemCollection> iter = col.iterator();
            String sModelVersion = iter.next().getItemValueString("$modelversion");
            return sModelVersion;
        }
        throw new ModelException("UNDEFINED_MODEL_ENTRY", "[ModelService] no matching model definition found for $processid=" + processId + " workflowgroup='" + workflowGroup + "'!");
    }

    @Override
    public List<ItemCollection> getAllModelProfiles() {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        String sQuery = "SELECT process FROM Entity AS process JOIN process.textItems as v JOIN process.textItems as n WHERE process.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName='$modelversion'  ORDER BY v.itemValue DESC";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, -1);
        for (ItemCollection ic : col) {
            result.add(ic);
        }
        return result;
    }

    @Override
    public List<String> getAllModelVersions() {
        ArrayList<String> result = new ArrayList<String>();
        List<ItemCollection> pofileList = this.getAllModelProfiles();
        for (ItemCollection profile : pofileList) {
            String sVersion = profile.getItemValueString("$modelversion");
            if (result.indexOf(sVersion) != -1) continue;
            result.add(sVersion);
        }
        return result;
    }

    @Override
    public List<ItemCollection> getPublicActivities(int aprocessid, String version) {
        ArrayList<ItemCollection> colActivities = null;
        try {
            List<ItemCollection> colEntities = this.getActivityEntityList(aprocessid, version);
            colActivities = new ArrayList<ItemCollection>();
            for (ItemCollection aworkitem : colEntities) {
                if ("0".equals(aworkitem.getItemValueString("keypublicresult"))) continue;
                colActivities.add(aworkitem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colActivities;
    }

    @Override
    public List<String> getAllWorkflowGroups(String modelVersion) {
        ArrayList<String> colGroups = new ArrayList<String>();
        try {
            List<ItemCollection> colEntities = this.getProcessEntityList(modelVersion);
            for (ItemCollection aworkitem : colEntities) {
                String sGroup = aworkitem.getItemValueString("txtworkflowgroup");
                if (colGroups.indexOf(sGroup) != -1) continue;
                colGroups.add(sGroup);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colGroups;
    }

    @Deprecated
    public List<String> getAllWorkflowGroupsByVersion(String version) {
        ArrayList<String> colGroups = new ArrayList<String>();
        try {
            List<ItemCollection> colEntities = this.getProcessEntityList(version);
            for (ItemCollection aworkitem : colEntities) {
                String sGroup = aworkitem.getItemValueString("txtworkflowgroup");
                if (colGroups.indexOf(sGroup) != -1) continue;
                colGroups.add(sGroup);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colGroups;
    }

    @Override
    public List<ItemCollection> getAllStartProcessEntities(String version) {
        HashMap<String, ItemCollection> cashBestProcessID = new HashMap<String, ItemCollection>();
        ArrayList<ItemCollection> colStartProcessEntities = new ArrayList<ItemCollection>();
        try {
            List<ItemCollection> colEntities = this.getProcessEntityList(version);
            for (ItemCollection processEntity : colEntities) {
                String sGroup = processEntity.getItemValueString("txtworkflowgroup");
                Integer iProcessID = processEntity.getItemValueInteger("numProcessID");
                Integer iBestProcessID = null;
                ItemCollection itemColBestProcess = (ItemCollection)cashBestProcessID.get(sGroup);
                if (itemColBestProcess != null) {
                    iBestProcessID = itemColBestProcess.getItemValueInteger("numProcessID");
                }
                if (iBestProcessID != null && iProcessID >= iBestProcessID) continue;
                cashBestProcessID.put(sGroup, processEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ItemCollection bestProcessEntity : cashBestProcessID.values()) {
            colStartProcessEntities.add(bestProcessEntity);
        }
        Collections.sort(colStartProcessEntities, new ItemCollectionComparator("numProcessID"));
        return colStartProcessEntities;
    }

    @Override
    public List<ItemCollection> getAllProcessEntitiesByGroup(String aGroup, String aversion) {
        ArrayList<ItemCollection> processList = new ArrayList<ItemCollection>();
        String sQuery = "SELECT DISTINCT process FROM Entity AS process  JOIN process.textItems AS t2 JOIN process.integerItems AS t3 WHERE process.type= 'ProcessEntity' AND t2.itemName = 'txtworkflowgroup'  AND t2.itemValue = '" + aGroup + "' " + " AND t3.itemName = 'numprocessid'" + " ORDER BY t3.itemValue asc";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, -1);
        for (ItemCollection aworkitem : col) {
            String sVersion = aworkitem.getItemValueString("$ModelVersion");
            if (aversion != null && !aversion.equals(sVersion)) continue;
            processList.add(aworkitem);
        }
        return processList;
    }

    @Override
    public void importModel(InputStream input) throws ModelException, AccessDeniedException {
        String sModelVersion = null;
        if (input == null) {
            return;
        }
        EntityCollection ecol = null;
        logger.info("[ModelService] importModel, verifing file content....");
        Object jaxbObject = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntityCollection.class});
            Unmarshaller m = context.createUnmarshaller();
            jaxbObject = m.unmarshal(input);
        }
        catch (JAXBException e) {
            throw new ModelException("INVALID_MODEL", "[ModelService] error - wrong xml file format - unable to import model file: ", (Exception)((Object)e));
        }
        if (jaxbObject == null) {
            throw new ModelException("INVALID_MODEL", "[ModelService] error - wrong xml file format - unable to import model file!");
        }
        ecol = (EntityCollection)jaxbObject;
        if (ecol.getEntity().length > 0) {
            ItemCollection itemCollection;
            for (XMLItemCollection aentity : ecol.getEntity()) {
                itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)aentity);
                if (!"WorkflowEnvironmentEntity".equals(itemCollection.getItemValueString("type")) || !"environment.profile".equals(itemCollection.getItemValueString("txtName"))) continue;
                if (sModelVersion != null) {
                    throw new ModelException("INVALID_MODEL", "[ModelService] error importModel - file contains more than one modelversion!");
                }
                sModelVersion = itemCollection.getItemValueString("$ModelVersion");
            }
            if (sModelVersion == null) {
                throw new ModelException("INVALID_MODEL", "[ModelService] error importModel - file did not contain a environment.profile entity with a valid modelversion!");
            }
            logger.info("[ModelService] removing existing configuration for model version '" + sModelVersion + "'");
            this.removeModel(sModelVersion);
            for (int i = 0; i < ecol.getEntity().length; ++i) {
                XMLItemCollection entity = ecol.getEntity()[i];
                itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)entity);
                String sType = itemCollection.getItemValueString("Type");
                if ("ProcessEntity".equals(sType) || "ActivityEntity".equals(sType) || "WorkflowEnvironmentEntity".equals(sType)) {
                    itemCollection.replaceItemValue("$modelVersion", (Object)sModelVersion);
                    this.entityService.save(itemCollection);
                    continue;
                }
                logger.warning("[ModelService] importModel: unsported entity type=" + sType + "!");
            }
            logger.info("[ModelService] " + ecol.getEntity().length + " model entries sucessfull imported");
        }
    }

    public void importBPMNModel(BPMNModel bpmnmodel) throws ModelException {
        if (bpmnmodel == null || bpmnmodel.getProfile() == null) {
            throw new ModelException("INVALID_MODEL", "Invalid Model file: No Imixs Definitions Extension found! ");
        }
        String modelVersion = bpmnmodel.getProfile().getItemValueString("$ModelVersion");
        logger.fine("import BPMN model $modelversion=" + modelVersion + "....");
        if (modelVersion.isEmpty()) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Version not provided! ");
        }
        for (String group : bpmnmodel.getWorkflowGroups()) {
            this.removeModelGroup(group, modelVersion);
        }
        logger.fine("update profile...");
        if (bpmnmodel.getProfile() != null) {
            ItemCollection oldProfile = null;
            while ((oldProfile = this.findEnvironmentEntity("environment.profile", modelVersion)) != null) {
                this.entityService.remove(oldProfile);
            }
            this.entityService.save(bpmnmodel.getProfile());
        }
        for (ItemCollection processEntity : bpmnmodel.getProcessEntityList(modelVersion)) {
            int processID = processEntity.getItemValueInteger("numprocessid");
            logger.fine("update processEntity: " + processID);
            this.entityService.save(processEntity);
            for (ItemCollection acitivtyEntity : bpmnmodel.getActivityEntityList(processID, modelVersion)) {
                logger.fine("update activityEntity: " + processID + "." + acitivtyEntity.getItemValueInteger("numactivityid"));
                this.entityService.save(acitivtyEntity);
            }
        }
        logger.fine("update finished! ");
        logger.info("imported BPMN model $modelversion=" + modelVersion);
    }
}

