/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee.extended;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.plugins.AbstractPlugin;

public class LucenePlugin
extends AbstractPlugin {
    public static final String UNDEFINED_ERROR = "UNDEFINED_ERROR";
    public static final String INVALID_INDEX = "INVALID_INDEX";
    IndexWriter writer = null;
    static List<String> searchFieldList = null;
    static List<String> indexFieldListAnalyse = null;
    static List<String> indexFieldListNoAnalyse = null;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");
    private static int maxResult = 100;

    public int getMaxResult() {
        return maxResult;
    }

    public void setMaxResult(int searchCount) {
        maxResult = searchCount;
    }

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
    }

    public int run(ItemCollection documentContext, ItemCollection activity) throws PluginException {
        int nextProcessID = activity.getItemValueInteger("numnextprocessid");
        int currentProcessID = documentContext.getItemValueInteger("$processid");
        if (!documentContext.hasItem("$Created")) {
            documentContext.replaceItemValue("$Created", (Object)Calendar.getInstance().getTime());
        }
        documentContext.replaceItemValue("$modified", (Object)Calendar.getInstance().getTime());
        documentContext.replaceItemValue("$processid", (Object)nextProcessID);
        LucenePlugin.updateWorkitem(documentContext);
        documentContext.replaceItemValue("$processid", (Object)currentProcessID);
        return 0;
    }

    public void close(int status) throws PluginException {
    }

    public static boolean updateWorkitem(ItemCollection documentContext) throws PluginException {
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        workitems.add(documentContext);
        LucenePlugin.updateWorklist(workitems);
        return true;
    }

    public static boolean updateWorklist(Collection<ItemCollection> worklist) throws PluginException {
        IndexWriter awriter = null;
        Properties prop = LucenePlugin.loadProperties();
        if (prop.isEmpty()) {
            return false;
        }
        try {
            awriter = LucenePlugin.createIndexWriter(prop);
            for (ItemCollection workitem : worklist) {
                Term term = new Term("$uniqueid", workitem.getItemValueString("$uniqueid"));
                if (LucenePlugin.matchConditions(prop, workitem)) {
                    awriter.updateDocument(term, (Iterable)LucenePlugin.createDocument(prop, workitem));
                    continue;
                }
                awriter.deleteDocuments(term);
            }
        }
        catch (IOException luceneEx) {
            logger.warning(" Lucene Exception : " + luceneEx.getMessage());
            throw new PluginException(LucenePlugin.class.getSimpleName(), INVALID_INDEX, "Unable to update search index", (Exception)luceneEx);
        }
        finally {
            if (awriter != null) {
                logger.fine(" close writer");
                try {
                    awriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new PluginException(LucenePlugin.class.getSimpleName(), INVALID_INDEX, "Unable to update search index", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new PluginException(LucenePlugin.class.getSimpleName(), INVALID_INDEX, "Unable to update search index", (Exception)e);
                }
            }
        }
        logger.fine(" update worklist successfull");
        return true;
    }

    public static void removeWorkitem(String uniqueID) throws PluginException {
        IndexWriter awriter = null;
        Properties prop = LucenePlugin.loadProperties();
        if (!prop.isEmpty()) {
            try {
                awriter = LucenePlugin.createIndexWriter(prop);
                Term term = new Term("$uniqueid", uniqueID);
                awriter.deleteDocuments(term);
            }
            catch (CorruptIndexException e) {
                throw new PluginException(LucenePlugin.class.getSimpleName(), INVALID_INDEX, "Unable to remove workitem '" + uniqueID + "' from search index", (Exception)((Object)e));
            }
            catch (LockObtainFailedException e) {
                throw new PluginException(LucenePlugin.class.getSimpleName(), INVALID_INDEX, "Unable to remove workitem '" + uniqueID + "' from search index", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new PluginException(LucenePlugin.class.getSimpleName(), INVALID_INDEX, "Unable to remove workitem '" + uniqueID + "' from search index", (Exception)e);
            }
        }
    }

    public static boolean matchConditions(Properties prop, ItemCollection aworktiem) {
        String typePattern = prop.getProperty("lucence.matchingType");
        String processIDPattern = prop.getProperty("lucence.matchingProcessID");
        String type = aworktiem.getItemValueString("Type");
        String sPid = aworktiem.getItemValueInteger("$Processid") + "";
        if (typePattern != null && !"".equals(typePattern) && !type.matches(typePattern)) {
            return false;
        }
        return processIDPattern == null || "".equals(processIDPattern) || sPid.matches(processIDPattern);
    }

    public static List<ItemCollection> search(String sSearchTerm, WorkflowService workflowService) {
        return LucenePlugin.search(sSearchTerm, workflowService, null);
    }

    public static List<ItemCollection> search(String sSearchTerm, WorkflowService workflowService, Sort sortOrder) {
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        if (sSearchTerm == null || "".equals(sSearchTerm)) {
            return workitems;
        }
        long ltime = System.currentTimeMillis();
        Properties prop = LucenePlugin.loadProperties();
        if (prop.isEmpty()) {
            return workitems;
        }
        try {
            IndexSearcher searcher = LucenePlugin.createIndexSearcher(prop);
            QueryParser parser = LucenePlugin.createQueryParser(prop);
            if (!workflowService.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
                List<String> userNameList = workflowService.getUserNameList();
                String sAccessTerm = "($readaccess:ANONYMOUS";
                for (String aRole : userNameList) {
                    if ("".equals(aRole)) continue;
                    sAccessTerm = sAccessTerm + " $readaccess:\"" + aRole + "\"";
                }
                sAccessTerm = sAccessTerm + ") AND ";
                sSearchTerm = sAccessTerm + sSearchTerm;
            }
            logger.info("  lucene search:" + sSearchTerm);
            if (!"".equals(sSearchTerm)) {
                ScoreDoc[] scoreDosArray;
                parser.setAllowLeadingWildcard(true);
                Object topDocs = null;
                topDocs = sortOrder != null ? searcher.search(parser.parse(sSearchTerm), maxResult, sortOrder) : searcher.search(parser.parse(sSearchTerm), maxResult);
                logger.fine("  total hits=" + topDocs.totalHits);
                for (ScoreDoc scoredoc : scoreDosArray = topDocs.scoreDocs) {
                    Document doc = searcher.doc(scoredoc.doc);
                    String sID = doc.get("$uniqueid");
                    logger.fine("  lucene $uniqueid=" + sID);
                    ItemCollection itemCol = workflowService.getEntityService().load(sID);
                    if (itemCol != null) {
                        workitems.add(itemCol);
                        continue;
                    }
                    logger.warning("[LucenePlugin] index returned unreadable workitem : " + sID);
                }
            }
            searcher.getIndexReader().close();
            logger.info(" lucene serach: " + (System.currentTimeMillis() - ltime) + " ms");
        }
        catch (Exception e) {
            logger.warning("  lucene error!");
            e.printStackTrace();
        }
        return workitems;
    }

    static Document createDocument(Properties prop, ItemCollection aworkitem) {
        String sValue = null;
        Document doc = new Document();
        String sContent = "";
        for (String aFieldname : searchFieldList) {
            sValue = "";
            List vValues = aworkitem.getItemValue(aFieldname);
            if (vValues.size() == 0) continue;
            for (Object o : vValues) {
                if (o == null) continue;
                if (o instanceof Calendar || o instanceof Date) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
                    String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
                    sValue = sValue + sDateValue + ",";
                    continue;
                }
                sValue = sValue + o.toString() + ",";
            }
            if (sValue == null) continue;
            logger.fine("  add SearchField: " + aFieldname + " = " + sValue);
            sContent = sContent + sValue + ",";
        }
        logger.fine("  content = " + sContent);
        doc.add((IndexableField)new TextField("content", sContent, Field.Store.NO));
        for (String aFieldname : indexFieldListAnalyse) {
            LucenePlugin.addFieldValue(doc, aworkitem, aFieldname, true);
        }
        for (String aFieldname : indexFieldListNoAnalyse) {
            LucenePlugin.addFieldValue(doc, aworkitem, aFieldname, false);
        }
        doc.add((IndexableField)new StringField("$uniqueid", aworkitem.getItemValueString("$uniqueid"), Field.Store.YES));
        List vReadAccess = aworkitem.getItemValue("$readAccess");
        if (vReadAccess.size() == 0 || vReadAccess.size() == 1 && "".equals(((String)vReadAccess.get(0)).toString())) {
            sValue = "ANONYMOUS";
            doc.add((IndexableField)new StringField("$readaccess", sValue, Field.Store.NO));
        } else {
            sValue = "";
            for (String sReader : vReadAccess) {
                doc.add((IndexableField)new StringField("$readaccess", sReader, Field.Store.NO));
            }
        }
        return doc;
    }

    static void addFieldValue(Document doc, ItemCollection aworkitem, String aFieldname, boolean analyzeValue) {
        String sValue = null;
        List vValues = aworkitem.getItemValue(aFieldname);
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        for (Object singleValue : vValues) {
            if (singleValue instanceof Calendar || singleValue instanceof Date) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
                String sDateValue = singleValue instanceof Calendar ? dateformat.format(((Calendar)singleValue).getTime()) : dateformat.format((Date)singleValue);
                sValue = sDateValue;
            } else {
                sValue = singleValue.toString();
            }
            logger.fine("  add IndexField (analyse=" + analyzeValue + "): " + aFieldname + " = " + sValue);
            if (analyzeValue) {
                doc.add((IndexableField)new TextField(aFieldname, sValue, Field.Store.NO));
                continue;
            }
            doc.add((IndexableField)new StringField(aFieldname, sValue, Field.Store.NO));
        }
    }

    public static IndexWriter createIndexWriter(Properties prop) throws IOException {
        String sName;
        String sLuceneVersion = prop.getProperty("Version", "LUCENE_45");
        String sIndexDir = prop.getProperty("lucence.indexDir");
        String sFulltextFieldList = prop.getProperty("lucence.fulltextFieldList");
        String sIndexFieldListAnalyse = prop.getProperty("lucence.indexFieldListAnalyze");
        String sIndexFieldListNoAnalyse = prop.getProperty("lucence.indexFieldListNoAnalyze");
        logger.fine("IndexDir:" + sIndexDir);
        logger.fine("FulltextFieldList:" + sFulltextFieldList);
        logger.fine("IndexFieldListAnalyse:" + sIndexFieldListAnalyse);
        logger.fine("IndexFieldListNoAnalyse:" + sIndexFieldListNoAnalyse);
        StringTokenizer st = new StringTokenizer(sFulltextFieldList, ",");
        searchFieldList = new ArrayList<String>();
        while (st.hasMoreElements()) {
            sName = st.nextToken().toLowerCase();
            if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
            searchFieldList.add(sName);
        }
        st = new StringTokenizer(sIndexFieldListAnalyse, ",");
        indexFieldListAnalyse = new ArrayList<String>();
        while (st.hasMoreElements()) {
            sName = st.nextToken().toLowerCase();
            if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
            indexFieldListAnalyse.add(sName);
        }
        st = new StringTokenizer(sIndexFieldListNoAnalyse, ",");
        indexFieldListNoAnalyse = new ArrayList<String>();
        while (st.hasMoreElements()) {
            sName = st.nextToken().toLowerCase();
            if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
            indexFieldListNoAnalyse.add(sName);
        }
        Directory indexDir = LucenePlugin.createIndexDirectory(prop);
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_45);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_45, (Analyzer)analyzer);
        indexWriterConfig.setWriteLockTimeout(10000L);
        return new IndexWriter(indexDir, indexWriterConfig);
    }

    public static IndexSearcher createIndexSearcher(Properties prop) throws Exception {
        logger.fine("[LucenePlugin] createIndexSearcher...");
        Directory indexDir = LucenePlugin.createIndexDirectory(prop);
        DirectoryReader reader = DirectoryReader.open((Directory)indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        return searcher;
    }

    public static Directory createIndexDirectory(Properties prop) throws IOException {
        logger.fine("[LucenePlugin] createIndexDirectory...");
        String sLuceneLockFactory = prop.getProperty("lucence.lockFactory");
        String sIndexDir = prop.getProperty("lucence.indexDir");
        FSDirectory indexDir = FSDirectory.open((File)new File(sIndexDir));
        if (sLuceneLockFactory != null && !"".equals(sLuceneLockFactory)) {
            logger.fine("[LucenePlugin] set LockFactory=" + sLuceneLockFactory);
            try {
                Class<?> fsFactoryClass = Class.forName(sLuceneLockFactory);
                LockFactory factoryInstance = (LockFactory)fsFactoryClass.newInstance();
                indexDir.setLockFactory(factoryInstance);
            }
            catch (ClassNotFoundException e) {
                logger.severe("[LucenePlugin] unable to create Lucene LockFactory!");
                e.printStackTrace();
                return null;
            }
            catch (InstantiationException e) {
                logger.severe("[LucenePlugin] unable to create Lucene LockFactory!");
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                logger.severe("[LucenePlugin] unable to create Lucene LockFactory!");
                e.printStackTrace();
                return null;
            }
        }
        return indexDir;
    }

    public static QueryParser createQueryParser(Properties prop) {
        String sLuceneVersion = prop.getProperty("Version", "LUCENE_45");
        KeywordAnalyzer analyzer = new KeywordAnalyzer();
        QueryParser parser = new QueryParser(Version.LUCENE_45, "content", (Analyzer)analyzer);
        return parser;
    }

    static Properties loadProperties() {
        Properties prop = new Properties();
        try {
            prop.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }
}

