/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee;

import java.util.List;
import javax.ejb.EJBTransactionRolledbackException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.plugins.jee.AbstractPlugin;

public class VersionPlugin
extends AbstractPlugin {
    public static final String INVALID_CONTEXT = "INVALID_CONTEXT";
    public static final String INVALID_WORKITEM = "INVALID_WORKITEM";
    private EntityService entityService = null;
    private WorkflowService workflowService = null;
    private String versionMode = "";
    private int versionActivityID = -1;
    private ItemCollection version = null;

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        if (actx instanceof WorkflowService) {
            this.workflowService = (WorkflowService)actx;
            this.entityService = this.workflowService.getEntityService();
        }
        if (this.workflowService == null) {
            throw new PluginException(VersionPlugin.class.getSimpleName(), INVALID_CONTEXT, "VersionPlugin unable to access WorkflowSerive");
        }
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public ItemCollection getVersion() {
        return this.version;
    }

    public void setVersion(ItemCollection version) {
        this.version = version;
    }

    @Override
    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.versionMode = adocumentActivity.getItemValueString("keyVersion");
        this.versionActivityID = adocumentActivity.getItemValueInteger("numVersionActivityID");
        try {
            if ("1".equals(this.versionMode) || "2".equals(this.versionMode)) {
                if ("1".equals(this.versionMode)) {
                    this.version = this.createVersion(adocumentContext);
                    if (this.ctx.getLogLevel() > 0) {
                        System.out.println("[VersionPlugin] new version created");
                    }
                    if (this.versionActivityID > 0) {
                        this.version.replaceItemValue("$ActivityID", (Object)this.versionActivityID);
                        this.version = this.workflowService.processWorkItem(this.version);
                    } else {
                        this.version = this.entityService.save(this.version);
                    }
                    return 0;
                }
                if ("2".equals(adocumentActivity.getItemValueString("keyVersion"))) {
                    String sworkitemID = adocumentContext.getItemValueString("$WorkItemID");
                    String query = " SELECT workitem FROM Entity AS workitem  JOIN workitem.textItems AS t1 WHERE t1.itemName = '$workitemid' AND t1.itemValue ='" + sworkitemID + "'";
                    List<ItemCollection> col = this.entityService.findAllEntities(query, 0, -1);
                    for (ItemCollection aVersion : col) {
                        String sWorkitemRef = aVersion.getItemValueString("$workitemIDRef");
                        if (!"".equals(sWorkitemRef)) continue;
                        String id = adocumentContext.getItemValueString("$uniqueID");
                        aVersion.replaceItemValue("$WorkItemIDRef", (Object)id);
                        if (this.versionActivityID > 0) {
                            aVersion.replaceItemValue("$ActivityID", (Object)this.versionActivityID);
                            aVersion = this.workflowService.processWorkItem(aVersion);
                        } else {
                            aVersion = this.entityService.save(aVersion);
                        }
                        this.version = aVersion;
                    }
                    adocumentContext.removeItem("$WorkItemIDRef");
                }
            }
        }
        catch (AccessDeniedException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        catch (ProcessingErrorException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        return 0;
    }

    @Override
    public void close(int status) throws PluginException {
        if (status == 2) {
            throw new EJBTransactionRolledbackException();
        }
    }

    public ItemCollection createVersion(ItemCollection sourceItemCollection) throws PluginException {
        ItemCollection itemColNewVersion = new ItemCollection();
        itemColNewVersion.replaceAllItems(sourceItemCollection.getAllItems());
        String id = sourceItemCollection.getItemValueString("$uniqueid");
        if ("".equals(id)) {
            throw new PluginException(VersionPlugin.class.getSimpleName(), INVALID_WORKITEM, "Error - unable to create a version from a new workitem!");
        }
        itemColNewVersion.getAllItems().remove("$uniqueid");
        itemColNewVersion.replaceItemValue("$WorkItemIDRef", (Object)id);
        return itemColNewVersion;
    }
}

