/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee;

import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.jee.AbstractPlugin;

public class MailPlugin
extends AbstractPlugin {
    Session mailSession;
    MimeMessage mailMessage = null;
    Multipart mimeMultipart = null;
    boolean isHTMLMail = false;
    String charSet = "text/html; charset=ISO-8859-1";
    @Resource(name="IMIXS_MAIL_SESSION")
    private String sMailSession = "org.imixs.workflow.mail";
    private static Logger logger = Logger.getLogger(MailPlugin.class.getName());

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        try {
            InitialContext ic = new InitialContext();
            String snName = "";
            snName = "java:comp/env/mail/" + this.sMailSession;
            this.mailSession = (Session)ic.lookup(snName);
            logger.finest("[MailPlugin] MailSession '" + this.sMailSession + "' found");
        }
        catch (NamingException e) {
            logger.warning("[MailPlugin] Unable to send mails! Verify server resources -> mail session.");
            logger.warning("[MailPlugin] Mail Session for jndi name:'mail/" + this.sMailSession + "' missing.");
            logger.warning("[MailPlugin] ErrorMessage: " + e.getMessage());
        }
    }

    @Override
    public int run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        String sReplyTo = "";
        if (this.mailSession == null) {
            return 1;
        }
        try {
            this.mailMessage = null;
            if ("1".equals(documentActivity.getItemValueString("keyMailInactive"))) {
                return 0;
            }
            String snamMailReceifer = documentActivity.getItemValueString("namMailReceiver");
            logger.finest("[MailPlugin] namMailReceiver=" + snamMailReceifer);
            String skeyMailReceiverFields = documentActivity.getItemValueString("keyMailReceiverFields");
            logger.finest("[MailPlugin] keyMailReceiverFields=" + skeyMailReceiverFields);
            Object inetAddr = null;
            if (snamMailReceifer != null && !"".equals(documentActivity.getItemValueString("namMailReceiver")) || skeyMailReceiverFields != null && !"".equals(documentActivity.getItemValueString("keyMailReceiverFields"))) {
                List vectorRecipients;
                String sFrom = this.getUserName();
                logger.finest("[MailPlugin] userName (from) = " + sFrom);
                if (sFrom == null || "".equals(sFrom)) {
                    return 0;
                }
                this.initializeMailMessage();
                sReplyTo = "1".equals(documentActivity.getItemValueString("keyMailReplyToCurrentUser")) ? this.getUserName() : documentActivity.getItemValueString("namMailReplyToUser");
                logger.finest("[MailPlugin] ReplyTo=" + sReplyTo);
                this.mailMessage.setFrom((Address)this.getInternetAddress(sFrom));
                if (sReplyTo != null && !"".equals(sReplyTo)) {
                    InternetAddress[] resplysAdrs = new InternetAddress[]{this.getInternetAddress(sReplyTo)};
                    this.mailMessage.setReplyTo((Address[])resplysAdrs);
                }
                if ((vectorRecipients = documentActivity.getItemValue("namMailReceiver")) == null) {
                    vectorRecipients = new Vector();
                }
                this.mergeMappedFieldValues(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFields"));
                if (vectorRecipients.size() == 0) {
                    this.mailMessage = null;
                    return 0;
                }
                InternetAddress[] recipientsTo = this.getInternetAddressArray(vectorRecipients);
                this.mailMessage.setRecipients(Message.RecipientType.TO, (Address[])recipientsTo);
                vectorRecipients = documentActivity.getItemValue("namMailReceiverCC");
                if (vectorRecipients == null) {
                    vectorRecipients = new Vector();
                }
                this.mergeMappedFieldValues(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFieldsCC"));
                InternetAddress[] recipientsCC = this.getInternetAddressArray(vectorRecipients);
                this.mailMessage.setRecipients(Message.RecipientType.CC, (Address[])recipientsCC);
                this.mailMessage.setSubject(this.replaceDynamicValues(documentActivity.getItemValueString("txtMailSubject"), documentContext));
                String aBodyText = documentActivity.getItemValueString("rtfMailBody");
                this.isHTMLMail = false;
                if (aBodyText != null) {
                    MimeBodyPart messagePart = new MimeBodyPart();
                    String sTestHTML = (aBodyText = this.replaceDynamicValues(aBodyText, documentContext)).trim().toLowerCase();
                    if (sTestHTML.startsWith("<!doctype") || sTestHTML.startsWith("<html") || sTestHTML.startsWith("<?xml")) {
                        logger.fine("[MailPlugin] creating html mail body ...");
                        messagePart = new MimeBodyPart();
                        messagePart.setContent((Object)aBodyText, this.getCharSet());
                        this.isHTMLMail = true;
                    } else {
                        logger.fine("[MailPlugin] creating plaintext mail body ...");
                        messagePart.setText(aBodyText);
                    }
                    this.mimeMultipart.addBodyPart((BodyPart)messagePart);
                }
                if (recipientsTo.length > 0 && this.ctx.getLogLevel() == 2) {
                    logger.info("[MailPlugin] Creating new PlainText mail....");
                    logger.info("[MailPlugin] From: " + sFrom);
                    logger.info("[MailPlugin] To (" + recipientsTo.length + " Receipients):");
                    if (recipientsTo.length > 0) {
                        for (int j = 0; j < recipientsTo.length; ++j) {
                            logger.info("[MailPlugin]     " + recipientsTo[j].getAddress());
                        }
                    } else {
                        logger.info("[MailPlugin] no receipients defined");
                    }
                    if (recipientsCC.length > 0) {
                        logger.info("[MailPlugin] CopyTo (" + recipientsCC.length + " Receipients):");
                        for (int j = 0; j < recipientsCC.length; ++j) {
                            logger.info("[MailPlugin]     " + recipientsCC[j].getAddress());
                        }
                    } else {
                        logger.info("[MailPlugin] no CC defined");
                    }
                }
            } else if (this.ctx.getLogLevel() == 2) {
                logger.info("[MailPlugin] No Receipients defined for this Activity...");
            }
        }
        catch (Exception e) {
            logger.warning("[MailPlugin] run - Warning:" + e.toString());
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    @Override
    public void close(int status) throws PluginException {
        if (status == 0 && this.mailSession != null && this.mailMessage != null) {
            try {
                if (this.ctx.getLogLevel() == 2) {
                    logger.info("[MailPlugin] SendMessage now...");
                }
                Transport trans = this.mailSession.getTransport("smtp");
                trans.connect(this.mailSession.getProperty("mail.smtp.user"), this.mailSession.getProperty("mail.smtp.password"));
                if (this.isHTMLMail()) {
                    this.mailMessage.setContent((Object)this.mimeMultipart, this.getCharSet());
                } else {
                    this.mailMessage.setContent(this.mimeMultipart);
                }
                this.mailMessage.saveChanges();
                trans.sendMessage((Message)this.mailMessage, this.mailMessage.getAllRecipients());
                trans.close();
            }
            catch (Exception esend) {
                logger.warning("[MailPlugin] close - Warning:" + esend.toString());
            }
        }
    }

    public void initializeMailMessage() throws AddressException, MessagingException {
        logger.finest("[MailPlugin] initializeMailMessage...");
        if (logger.isLoggable(Level.FINE)) {
            Properties props = this.mailSession.getProperties();
            Enumeration<Object> enumer = props.keys();
            while (enumer.hasMoreElements()) {
                String aKey = enumer.nextElement().toString();
                logger.fine("[MailPlugin]  ProperyName= " + aKey);
                String value = props.getProperty(aKey);
                if (value == null) {
                    logger.fine("[MailPlugin]  PropertyValue=null");
                    continue;
                }
                logger.fine("[MailPlugin]  PropertyValue= " + props.getProperty(aKey).toString());
            }
        }
        this.mailMessage = new MimeMessage(this.mailSession);
        this.mailMessage.setSentDate(new Date());
        this.mailMessage.setFrom();
        this.mimeMultipart = new MimeMultipart();
    }

    public InternetAddress getInternetAddress(String aAddr) throws AddressException {
        InternetAddress inetAddr = null;
        if (aAddr == null) {
            return null;
        }
        try {
            inetAddr = aAddr.indexOf(" ") > -1 ? new InternetAddress("\"" + aAddr + "\"") : new InternetAddress(aAddr);
        }
        catch (AddressException ae) {
            ae.printStackTrace();
            return null;
        }
        return inetAddr;
    }

    private InternetAddress[] getInternetAddressArray(List aList) {
        InternetAddress inetAddr = null;
        if (aList == null) {
            return null;
        }
        Vector<InternetAddress> vReceipsTemp = new Vector<InternetAddress>();
        for (int i = 0; i < aList.size(); ++i) {
            try {
                inetAddr = this.getInternetAddress(aList.get(i).toString());
                if (inetAddr == null || "".equals(inetAddr.getAddress())) continue;
                vReceipsTemp.add(inetAddr);
                continue;
            }
            catch (AddressException e) {
                // empty catch block
            }
        }
        InternetAddress[] receipsAdrs = new InternetAddress[vReceipsTemp.size()];
        for (int i = 0; i < vReceipsTemp.size(); ++i) {
            receipsAdrs[i] = (InternetAddress)vReceipsTemp.elementAt(i);
        }
        return receipsAdrs;
    }

    public Session getMailSession() {
        return this.mailSession;
    }

    public Message getMailMessage() {
        return this.mailMessage;
    }

    public Multipart getMultipart() {
        return this.mimeMultipart;
    }

    public boolean isHTMLMail() {
        return this.isHTMLMail;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }
}

